/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.video;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.AudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MicNoVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.MixVideoId;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.VideoLayoutController;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.video.IVideoViewController;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.releasemanager.ObjectReleaseBeforeInitManager;
import com.yymobile.core.flowmanagement.compatiblecore.audience.VideoMixtureManager;
import java.util.List;

public class AudienceVideoViewController
implements IVideoViewController,
ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject {
    private static final String TAG = "AudienceVideoViewController";
    private AudienceVideoView mAudienceVideoView;
    private ViewGroup mVideoParent;
    private Context mContext;
    private VideoLayoutController mVideoLayoutController;

    public AudienceVideoViewController(ViewGroup videoParent, List<AbsVideoLayoutParser> parsers) {
        this.mContext = videoParent.getContext();
        this.mVideoParent = videoParent;
        this.init(parsers);
    }

    private void init(List<AbsVideoLayoutParser> parsers) {
        this.initVideoView();
        this.mVideoLayoutController = new VideoLayoutController(this.mAudienceVideoView, parsers);
    }

    @Override
    public void switchOrientation(int orientation) {
        if (this.mVideoLayoutController != null) {
            this.mVideoLayoutController.switchOrientation(orientation);
        }
    }

    @Override
    public void setVideoEnable(boolean enable) {
        MLog.info((Object)TAG, (String)("setVideoEnable called with: enable = [" + enable + "]"), (Object[])new Object[0]);
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.setVideoEnable(enable);
        }
    }

    @Override
    public void onStop() {
        this.mAudienceVideoView.setVideoEnable(false);
    }

    @Override
    public void onResume() {
        if (AudienceVideoEnableManager.getInstance().isVideoEnable()) {
            this.mAudienceVideoView.setVideoEnable(true);
        } else {
            MLog.info((Object)TAG, (String)"onResume, current is not video mode, do not enable video", (Object[])new Object[0]);
        }
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"release called", (Object[])new Object[0]);
        ObjectReleaseBeforeInitManager.getInstance().callRelease((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
    }

    private void innerRelease() {
        MLog.info((Object)TAG, (String)"innerRelease called", (Object[])new Object[0]);
        this.mVideoLayoutController.release();
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.release();
        }
    }

    @Override
    public void removeVideoView() {
        MLog.info((Object)TAG, (String)"removeVideoView called", (Object[])new Object[0]);
        if (this.mAudienceVideoView != null) {
            this.mVideoParent.removeView((View)this.mAudienceVideoView);
            this.mAudienceVideoView.release();
            this.mAudienceVideoView = null;
        }
    }

    @Override
    public void startVideo() {
        MLog.info((Object)TAG, (String)"startVideo called", (Object[])new Object[0]);
        this.innerStartVideo();
    }

    @Override
    public void initVideoView() {
        ObjectReleaseBeforeInitManager.getInstance().callInit((ObjectReleaseBeforeInitManager.ReleaseBeforeInitObject)this);
        boolean needMixture = !this.isMeAsLinkUser();
        MLog.info((Object)TAG, (String)"initVideoView , video need mixture: %b", (Object[])new Object[]{needMixture});
        VideoMixtureManager.getInstance().setVideoNeedMixture(needMixture);
        this.mAudienceVideoView = new AudienceVideoView(this.mContext);
        this.mAudienceVideoView.setZOrderMediaOverlay(false);
        this.mVideoParent.addView((View)this.mAudienceVideoView);
        this.mAudienceVideoView.setVideoEnable(AudienceVideoEnableManager.getInstance().isVideoEnable());
        this.innerStartVideo();
    }

    private void innerStartVideo() {
        boolean needMixture = !this.isMeAsLinkUser();
        MLog.info((Object)TAG, (String)"innerStartVideo called, needMixture: %b", (Object[])new Object[]{needMixture});
        if (this.mAudienceVideoView != null) {
            this.mAudienceVideoView.start((AbsVideoId)(needMixture ? new MixVideoId() : new MicNoVideoId(0)));
        }
    }

    private boolean isMeAsLinkUser() {
        return false;
    }

    public void onInit() {
    }

    public void onRelease() {
        MLog.info((Object)TAG, (String)"onRelease called", (Object[])new Object[0]);
        this.innerRelease();
    }

    public String getType() {
        return "AUDIENCE_VIDEO";
    }
}

