/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.nonmixlayout.layoutparser.vertical;

import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class NormalVertical1v1Parser
extends AbsVideoLayoutParser {
    private static final String TAG = "NormalVertical1v1Parser";

    @Override
    public String getLogTag() {
        return TAG;
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        return sizeInfo.isVerticalOrientation && sizeInfo.videoCount == 2;
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        boolean isFirstMic = sizeInfo.micNo == 0;
        int halfWidth = sizeInfo.parentWidth / 2;
        VideoRect videoRect = new VideoRect();
        videoRect.videoScaleMode = VideoScaleMode.CLIP_TO_BOUNDS;
        videoRect.left = isFirstMic ? 0 : halfWidth;
        videoRect.top = (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)context);
        videoRect.width = halfWidth;
        videoRect.height = (int)(0.75 * (double)sizeInfo.parentWidth);
        return videoRect;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        boolean isFirstMic;
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)TAG, (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        boolean bl = isFirstMic = sizeInfo.micNo == 0;
        if (isFirstMic) {
            MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)context), sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
            list2.add(firstVideo);
        } else {
            MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(sizeInfo.parentWidth / 2, (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)context), sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
            list2.add(secondVideo);
        }
        return list2;
    }
}

