/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.lianmai.layoutchangemanager;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onLianMaiLiveStart_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onLianMaiLiveStop_EventArgs;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.playstatus.AudienceVideoPlayStatusEvent;
import com.yy.mobile.ui.lianmai.layoutchangemanager.LianmaiLayoutChangeListener;
import com.yy.mobile.ui.lianmai.layoutchangemanager.LianmaiLayoutChangeSequenceForAnchor$$EventBinder;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.flowmanagement.util.BaseBusEventReceiver;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class LianmaiLayoutChangeSequenceForAnchor
extends BaseBusEventReceiver {
    private static final String TAG = "LianmaiLayoutChangeSequenceForAnchor";
    private static final int TIME_OUT_MILLIS = 15000;
    private Disposable mLianmaiStartDisposable;
    private LianmaiLayoutChangeListener mLianmaiLayoutChangeListener;
    private boolean mHasReceiveLianMaiStartPush;
    private boolean mIsSecondMicPlaying;
    private boolean mIsTimeout;
    private EventBinder mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder;

    public void init() {
        super.init();
        MLog.info((Object)TAG, (String)"init", (Object[])new Object[0]);
    }

    public void unInit() {
        super.unInit();
        MLog.info((Object)TAG, (String)"unInit", (Object[])new Object[0]);
        this.mLianmaiLayoutChangeListener = null;
        this.disposeLianmaiStartDisposable();
    }

    public void setLayoutChangeListener(LianmaiLayoutChangeListener listener2) {
        this.mLianmaiLayoutChangeListener = listener2;
    }

    @BusEvent
    public void onAudiencePlayStatusChange(AudienceVideoPlayStatusEvent event) {
        boolean isLianmaiFirst = false;
        if (isLianmaiFirst && VideoPlayStatus.LOADING.equals((Object)event.playStatus) && event.videoPlayInfo.micPos == 1) {
            MLog.info((Object)TAG, (String)"onAudiencePlayStatusChange: onLianMaiLiveStart", (Object[])new Object[0]);
            this.on2maiVideoPlay();
        } else {
            MLog.info((Object)TAG, (String)"onAudiencePlayStatusChange: isLianmaiFirst:%b, event:%s", (Object[])new Object[]{isLianmaiFirst, event});
        }
    }

    @BusEvent(sync=true)
    public void onLianMaiLiveStart(IMobileLiveClient_onLianMaiLiveStart_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onLianMaiLiveStart", (Object[])new Object[0]);
        this.onLianmaiStart();
    }

    @BusEvent(sync=true)
    public void onLianMaiLiveStop(IMobileLiveClient_onLianMaiLiveStop_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)"onLianMaiLiveStop", (Object[])new Object[0]);
        this.onLianmaiStop();
    }

    private void onLianmaiStart() {
        this.disposeLianmaiStartDisposable();
        this.resetCondition();
        this.setHasReceiveLianMaiStartPush(true);
        this.tryToChangeLianmaiLayoutOnLianmaiStart();
        this.mLianmaiStartDisposable = Observable.timer((long)15000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                MLog.error((Object)LianmaiLayoutChangeSequenceForAnchor.TAG, (String)"onLianmaiStart timeout!!!!! try to change lian mai layout", (Object[])new Object[0]);
                LianmaiLayoutChangeSequenceForAnchor.this.setTimeout(true);
                LianmaiLayoutChangeSequenceForAnchor.this.tryToChangeLianmaiLayoutOnLianmaiStart();
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"onLianmaiStart"));
    }

    private void on2maiVideoPlay() {
        MLog.info((Object)TAG, (String)"on2maiVideoPlay tryToChangeLianmaiLayoutOnLianmaiStart", (Object[])new Object[0]);
        this.setSecondMicPlaying(true);
        this.tryToChangeLianmaiLayoutOnLianmaiStart();
    }

    private void onLianmaiStop() {
        this.disposeLianmaiStartDisposable();
        this.changeLianmaiLayoutOnLianmaiStop();
        this.resetCondition();
    }

    private void disposeLianmaiStartDisposable() {
        RxUtils.dispose((Disposable)this.mLianmaiStartDisposable);
    }

    private void tryToChangeLianmaiLayoutOnLianmaiStart() {
        if (this.mLianmaiLayoutChangeListener == null) {
            MLog.info((Object)TAG, (String)"tryToChangeLianmaiLayoutOnLianmaiStart: null listener", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"tryToChangeLianmaiLayoutOnLianmaiStart mHasReceiveLianMaiStartPush:%b, mIsTimeout:%b, mIsSecondMicPlaying:%b", (Object[])new Object[]{this.mHasReceiveLianMaiStartPush, this.mIsTimeout, this.mIsSecondMicPlaying});
        if (this.mHasReceiveLianMaiStartPush && (this.mIsTimeout || this.mIsSecondMicPlaying)) {
            MLog.info((Object)TAG, (String)"tryToChangeLianmaiLayoutOnLianmaiStart: callback onLianmaiStart", (Object[])new Object[0]);
            this.disposeLianmaiStartDisposable();
            this.mLianmaiLayoutChangeListener.onLianmaiStart();
            this.resetCondition();
        }
    }

    private void resetCondition() {
        MLog.info((Object)TAG, (String)"resetCondition", (Object[])new Object[0]);
        this.setTimeout(false);
        this.setSecondMicPlaying(false);
        this.setHasReceiveLianMaiStartPush(false);
    }

    private void changeLianmaiLayoutOnLianmaiStop() {
        MLog.info((Object)TAG, (String)"changeLianmaiLayoutOnLianmaiStop", (Object[])new Object[0]);
        if (this.mLianmaiLayoutChangeListener != null) {
            this.mLianmaiLayoutChangeListener.onLianmaiStop();
        } else {
            MLog.info((Object)TAG, (String)"changeLianmaiLayoutOnLianmaiStop: null listener", (Object[])new Object[0]);
        }
    }

    public void setHasReceiveLianMaiStartPush(boolean hasReceiveLianMaiStartPush) {
        MLog.info((Object)TAG, (String)("setHasReceiveLianMaiStartPush() called with: hasReceiveLianMaiStartPush = [" + hasReceiveLianMaiStartPush + "]"), (Object[])new Object[0]);
        this.mHasReceiveLianMaiStartPush = hasReceiveLianMaiStartPush;
    }

    public void setSecondMicPlaying(boolean secondMicPlaying) {
        MLog.info((Object)TAG, (String)("setSecondMicPlaying() called with: secondMicPlaying = [" + secondMicPlaying + "]"), (Object[])new Object[0]);
        this.mIsSecondMicPlaying = secondMicPlaying;
    }

    public void setTimeout(boolean timeout) {
        MLog.info((Object)TAG, (String)("setTimeout() called with: timeout = [" + timeout + "]"), (Object[])new Object[0]);
        this.mIsTimeout = timeout;
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder == null) {
            this.mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder = new LianmaiLayoutChangeSequenceForAnchor$$EventBinder();
        }
        this.mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder != null) {
            this.mLianmaiLayoutChangeSequenceForAnchorSniperEventBinder.unBindEvent();
        }
    }
}

