/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.lianmai;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.lianmai.LainMainLoadingView$EventObject1$$EventBinder;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.lianmai.ILianMaiCore;
import com.yymobile.core.user.UserInfo;

public class LainMainLoadingView
extends RelativeLayout
implements EventCompat {
    private static final int SECONDS = 60;
    private LinearLayout mLianMaiApply;
    private LinearLayout mLianMaiCancel;
    private ImageView mLianMaiGif;
    private TextView mTimeTextView;
    private CircleImageView mAnchorLogo;
    EventCompat object = new EventObject1();
    private CircleImageView mUserLogo;

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    public LainMainLoadingView(Context context) {
        super(context);
    }

    public LainMainLoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mLianMaiApply = (LinearLayout)this.findViewById(R.id.apply_show);
        this.mLianMaiCancel = (LinearLayout)this.findViewById(R.id.cancel_show);
        this.mLianMaiGif = (ImageView)this.findViewById(R.id.lianmai_gif);
        this.mTimeTextView = (TextView)this.findViewById(R.id.time_textView);
        this.mAnchorLogo = (CircleImageView)this.findViewById(R.id.anchor_logo);
        this.mUserLogo = (CircleImageView)this.findViewById(R.id.user_logo);
    }

    public void setLoadingShow(boolean needResetTimer) {
        this.mLianMaiApply.setVisibility(8);
        this.mLianMaiCancel.setVisibility(0);
        this.showMusicGif();
        if (needResetTimer) {
            ((ILianMaiCore)ICoreManagerBase.getCore(ILianMaiCore.class)).cancelLianMaiTimer();
            ((ILianMaiCore)ICoreManagerBase.getCore(ILianMaiCore.class)).resetLianMaiTimer();
            ((ILianMaiCore)ICoreManagerBase.getCore(ILianMaiCore.class)).startLianMaiTimer();
        }
        this.loadLogo();
    }

    private void loadLogo() {
        UserInfo userInfo = ICoreManagerBase.getUserCore().getCacheLoginUserInfo();
        if (userInfo != null) {
            ImageLoader.loadImage((String)userInfo.iconUrl, (RecycleImageView)this.mUserLogo, (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.default_portrait);
        }
        long anchorId = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        UserInfo anchorInfo = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(anchorId);
        if (anchorInfo != null) {
            ImageLoader.loadImage((String)anchorInfo.iconUrl, (RecycleImageView)this.mAnchorLogo, (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.default_portrait);
        } else {
            ICoreManagerBase.getUserCore().requestDetailUserInfo(anchorId, false);
            ICoreManagerBase.addClient((Object)this.object);
        }
    }

    public void setNormalShow() {
        this.mLianMaiApply.setVisibility(0);
        this.mLianMaiCancel.setVisibility(8);
        this.hideMusicGif();
    }

    public void dismiss() {
        this.hideMusicGif();
    }

    private void hideMusicGif() {
        if (this.mLianMaiGif != null) {
            this.mLianMaiGif.setVisibility(4);
            if (this.mLianMaiGif.getDrawable() != null && this.mLianMaiGif.getDrawable() instanceof AnimationDrawable) {
                ((AnimationDrawable)this.mLianMaiGif.getDrawable()).stop();
            }
        }
    }

    private void showMusicGif() {
        if (this.mLianMaiGif != null) {
            this.mLianMaiGif.setVisibility(0);
            if (this.mLianMaiGif.getDrawable() != null && this.mLianMaiGif.getDrawable() instanceof AnimationDrawable) {
                ((AnimationDrawable)this.mLianMaiGif.getDrawable()).setOneShot(false);
                this.mLianMaiGif.getDrawable().setVisible(true, true);
                ((AnimationDrawable)this.mLianMaiGif.getDrawable()).start();
            }
        }
    }

    public void onLianMaiTick(long tick) {
        long totalSeconds = tick / 1000L;
        if (totalSeconds < 60L) {
            this.mTimeTextView.setText((CharSequence)("00:" + (totalSeconds < 10L ? "0" + totalSeconds : Long.valueOf(totalSeconds))));
        } else {
            long minutesSeconds = totalSeconds % 60L;
            long totalMinutes = totalSeconds / 60L;
            if (minutesSeconds == 0L) {
                this.mTimeTextView.setText((CharSequence)((totalMinutes < 10L ? "0" + totalMinutes : Long.valueOf(totalMinutes)) + ":00"));
            } else {
                this.mTimeTextView.setText((CharSequence)((totalMinutes < 10L ? "0" + totalMinutes : Long.valueOf(totalMinutes)) + ":" + (minutesSeconds < 10L ? "0" + minutesSeconds : Long.valueOf(minutesSeconds))));
            }
        }
    }

    class EventObject1
    implements EventCompat {
        private EventBinder mLainMainLoadingView$EventObject1SniperEventBinder;

        EventObject1() {
        }

        public void onEventBind() {
            if (this.mLainMainLoadingView$EventObject1SniperEventBinder == null) {
                this.mLainMainLoadingView$EventObject1SniperEventBinder = new LainMainLoadingView$EventObject1$$EventBinder();
            }
            this.mLainMainLoadingView$EventObject1SniperEventBinder.bindEvent((Object)this);
        }

        public void onEventUnBind() {
            if (this.mLainMainLoadingView$EventObject1SniperEventBinder != null) {
                this.mLainMainLoadingView$EventObject1SniperEventBinder.unBindEvent();
            }
        }

        @BusEvent
        public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
            long userId = busEventArgs.getUserId();
            UserInfo info = busEventArgs.getInfo();
            boolean isLocalData = busEventArgs.getIsLocalData();
            CoreError error = busEventArgs.getError();
            long anchorId = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
            ICoreManagerBase.removeClient((Object)LainMainLoadingView.this.object);
            if (info != null && userId == anchorId && anchorId != 0L) {
                ImageLoader.loadImage((String)info.iconUrl, (RecycleImageView)LainMainLoadingView.this.mAnchorLogo, (ImageConfig)ImageConfig.bigImageConfig(), (int)R.drawable.default_portrait);
            }
        }
    }
}

