/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.packages;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IGiftClient_onFreeGiftCountChange_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onFreeGiftGet_EventArgs;
import com.duowan.mobile.entlive.events.IGiftClient_onFreeGiftStatusUpdate_EventArgs;
import com.duowan.mobile.entlive.events.IPackageClient_onPageSelected_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.gift.packages.PackageAdapter;
import com.yy.mobile.ui.gift.packages.PackageFragment$$EventBinder;
import com.yy.mobile.ui.gift.widget.ScrollLayout;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import java.util.ArrayList;
import java.util.List;

public class PackageFragment
extends Component {
    public static final String TAG = "PackageFragment";
    private PackageAdapter mPackageAdapter;
    private View mRootView;
    private RelativeLayout packageParentLayout;
    private RelativeLayout packageEmptyView;
    private LinearLayout mIndicatorLayout;
    private List<ImageView> mIndicatorViews = new ArrayList<ImageView>();
    private ScrollLayout mScrollView;
    private boolean mIsLandscape = false;
    private TextView emptyTv;
    private TextView emptyTvLand;
    private EventBinder mPackageFragmentSniperEventBinder;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.mPackageFragmentSniperEventBinder == null) {
            this.mPackageFragmentSniperEventBinder = new PackageFragment$$EventBinder();
        }
        this.mPackageFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_gift_package_layout, container, false);
        this.initView(this.mRootView);
        return this.mRootView;
    }

    private void initView(View view) {
        this.mPackageAdapter = new PackageAdapter((Context)this.getActivity(), this.mIsLandscape);
        this.packageParentLayout = (RelativeLayout)view.findViewById(R.id.package_parent_layout);
        this.packageEmptyView = (RelativeLayout)view.findViewById(R.id.package_empty_view);
        this.emptyTv = (TextView)view.findViewById(R.id.empty_gift_bag_tv);
        this.emptyTvLand = (TextView)view.findViewById(R.id.empty_gift_bag_tv_land);
        this.mScrollView = (ScrollLayout)view.findViewById(R.id.package_scroll_layout);
        this.mScrollView.setAdapter(this.mPackageAdapter);
        this.mIndicatorLayout = (LinearLayout)view.findViewById(R.id.ll_indicators);
        this.initFreeGiftData();
    }

    public void updateIndicatorViews(int currentPage) {
        if (this.mPackageAdapter == null) {
            return;
        }
        this.mIndicatorLayout.removeAllViews();
        this.mIndicatorViews.clear();
        if (this.mPackageAdapter.getCount() < 2) {
            return;
        }
        int pading = (int)ResolutionUtils.convertDpToPixel((float)4.0f, (Context)this.getActivity());
        for (int i = 0; i < this.mPackageAdapter.getCount(); ++i) {
            if (this.getContext() == null) continue;
            ImageView indicatorView = new ImageView(this.getContext());
            LinearLayout.LayoutParams p = new LinearLayout.LayoutParams(-2, -2);
            indicatorView.setPadding(pading, 0, pading, 0);
            indicatorView.setLayoutParams((ViewGroup.LayoutParams)p);
            indicatorView.setScaleType(ImageView.ScaleType.CENTER);
            if (i == currentPage) {
                indicatorView.setImageResource(R.drawable.ic_gift_page_indicator_current);
            } else {
                indicatorView.setImageResource(R.drawable.ic_gift_page_indicator);
            }
            this.mIndicatorViews.add(indicatorView);
            this.mIndicatorLayout.addView((View)indicatorView);
        }
    }

    private void initFreeGiftData() {
        if (this.mPackageAdapter == null) {
            MLog.info((Object)TAG, (String)"packageAdapter is null", (Object[])new Object[0]);
            return;
        }
        List freeGiftItems = ((IGiftCore)CoreFactory.getCore(IGiftCore.class)).getGiftContainer().getFreeGift();
        MLog.info((Object)TAG, (String)("initFreeGiftData freeGiftItem size=" + freeGiftItems.size()), (Object[])new Object[0]);
        this.mPackageAdapter.setFullScreenMode(this.mIsLandscape);
        ArrayList<GiftConfigParser.FreeGiftConfigItem> copyItems = new ArrayList<GiftConfigParser.FreeGiftConfigItem>();
        if (freeGiftItems != null) {
            for (GiftConfigParser.FreeGiftConfigItem item2 : freeGiftItems) {
                if (item2.business == GiftConfigParser.FreeGiftConfigItem.Business.first_send) continue;
                copyItems.add(item2);
            }
        }
        this.mPackageAdapter.setFreePropsItemList(copyItems);
        if (copyItems != null && copyItems.size() > 0) {
            this.packageEmptyView.setVisibility(8);
            this.mScrollView.setVisibility(0);
            this.mScrollView.setToScreen(0);
        } else {
            this.packageEmptyView.setVisibility(0);
            this.mScrollView.setVisibility(8);
        }
        this.updateIndicatorViews(this.mScrollView.getCurScreen());
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onPageSelected(IPackageClient_onPageSelected_EventArgs busEventArgs) {
        int position = busEventArgs.mPosition;
        this.updateIndicatorViews(position);
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onFreeGiftGet(IGiftClient_onFreeGiftGet_EventArgs busEventArgs) {
        this.onFreeGiftGet();
    }

    public void onFreeGiftGet() {
        MLog.info((Object)TAG, (String)"huiping, onFreeGiftGet()", (Object[])new Object[0]);
        this.updateFreeGiftItems();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onFreeGiftStatusUpdate(IGiftClient_onFreeGiftStatusUpdate_EventArgs busEventArgs) {
        int availableInterval = busEventArgs.mAvailableInterval;
        if (!this.isHidden() || availableInterval == 0) {
            this.updateFreeGiftStatus(availableInterval);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onFreeGiftCountChange(IGiftClient_onFreeGiftCountChange_EventArgs busEventArgs) {
        int count = busEventArgs.mCount;
        MLog.info((Object)TAG, (String)("huiping, onFreeGiftCountChange count = " + count), (Object[])new Object[0]);
        if (this.mPackageAdapter != null) {
            this.mPackageAdapter.performOnGiftSelect();
        }
    }

    public void updateFreeGiftItems() {
        List freeGiftItems = ((IGiftCore)CoreFactory.getCore(IGiftCore.class)).getGiftContainer().getFreeGift();
        if (freeGiftItems != null) {
            ArrayList<GiftConfigParser.FreeGiftConfigItem> copyItems = new ArrayList<GiftConfigParser.FreeGiftConfigItem>();
            copyItems.addAll(freeGiftItems);
            this.updateFreeGiftItems(copyItems);
        }
    }

    private void updateFreeGiftItems(List<GiftConfigParser.FreeGiftConfigItem> data) {
        MLog.info((Object)TAG, (String)("huiping, updateFreeGiftItems: " + data.toString()), (Object[])new Object[0]);
        if (this.mPackageAdapter == null) {
            return;
        }
        this.initFreeGiftData();
    }

    public void updateFreeGiftStatus(int availableInterval) {
        if (this.mPackageAdapter == null) {
            return;
        }
        this.mPackageAdapter.updateFreePropsItemStatus(availableInterval);
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.packageParentLayout == null || this.emptyTvLand == null || this.emptyTv == null) {
            return;
        }
        FrameLayout.LayoutParams parentLp = (FrameLayout.LayoutParams)this.packageParentLayout.getLayoutParams();
        if (isLandscape) {
            parentLp.height = (int)ResolutionUtils.convertDpToPixel((float)90.0f, (Context)this.getContext());
            this.emptyTvLand.setVisibility(0);
            this.emptyTv.setVisibility(8);
        } else {
            parentLp.height = -1;
            this.emptyTv.setVisibility(0);
            this.emptyTvLand.setVisibility(8);
        }
        this.mIsLandscape = isLandscape;
        if (this.mPackageAdapter != null) {
            this.initFreeGiftData();
        }
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mPackageFragmentSniperEventBinder != null) {
            this.mPackageFragmentSniperEventBinder.unBindEvent();
        }
    }
}

