/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.guid;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.yy.mobile.ui.utils.DensityUtil;

public class CircleProgressView
extends View {
    int mProgress = 0;
    Paint mPaint;
    int w1;
    int w2;
    int wp;
    RectF rectF;

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint(1);
        this.w1 = DensityUtil.dip2px((Context)context, (float)4.0f);
        this.w2 = DensityUtil.dip2px((Context)context, (float)2.0f);
        this.wp = DensityUtil.dip2px((Context)context, (float)3.0f);
        this.rectF = new RectF();
    }

    public void setProgress(@IntRange(from=0L, to=100L) int progress) {
        if (progress < 0) {
            progress = 0;
        }
        if (progress > 100) {
            progress = 100;
        }
        this.mProgress = progress;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        int width = this.getWidth();
        int c = width / 2;
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-16777216);
        this.mPaint.setStrokeWidth((float)this.w1);
        canvas.drawCircle((float)c, (float)c, (float)(c - this.w1 / 2), this.mPaint);
        this.mPaint.setColor(-8960);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)c, (float)c, (float)(c - this.w1), this.mPaint);
        this.mPaint.setColor(-1728053248);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)c, (float)c, (float)(c - this.w1 - this.w2 / 2), this.mPaint);
        this.mPaint.setColor(-8960);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.wp);
        int left = (this.w1 + this.w2) / 2;
        this.rectF.set((float)left, (float)left, (float)(width - left), (float)(width - left));
        float sweepAngle = (float)this.mProgress / 100.0f * 360.0f;
        canvas.drawArc(this.rectF, -90.0f, sweepAngle, false, this.mPaint);
    }
}

