/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.memoryrecycle.views.YYTextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.GiftComponent;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.widget.AdvancedRadioGroup;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import com.yymobile.core.pay.IPayCore;
import com.yymobile.core.pay.MoneyBalance;
import com.yymobile.core.talentscout.ITalentScoutCore;
import com.yymobile.core.talentscout.TalentScoutInfo;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TalentScoutGiftComponent
extends GiftComponent {
    private static final String TAG = "TalentScoutGiftComponent";
    int currentPos = -1;
    private AdvancedRadioGroup mTalentScoutGiftTabLayout;
    private View mTalentScoutLayout;
    private TextView mTalentScoutRecharge;
    private TextView mTalentScoutYCurrency;
    private RadioButton mTalentScoutTabGift;
    private TextView mTalentScoutPersonChoose;
    private TextView mTalentScoutPersonChooseLand;
    private PopupWindow mPersonListPopupView;
    private PersonChooseAdpter mPersonListAdapter;
    AdvancedRadioGroup.OnCheckedChangeListener onTalentScoutCheckedChangeListener = new AdvancedRadioGroup.OnCheckedChangeListener(){

        public void onCheckedChanged(AdvancedRadioGroup group, int checkedId) {
            if (!TalentScoutGiftComponent.this.mIsFullScreen) {
                if (checkedId == R.id.talent_scout_tab_gift) {
                    TalentScoutGiftComponent.this.isTabGift = true;
                    TalentScoutGiftComponent.this.enablePersonChoose();
                    TalentScoutGiftComponent.this.onTalentScoutGiftBagTabChanged(false);
                } else if (checkedId == R.id.talent_scout_tab_bag) {
                    TalentScoutGiftComponent.this.isTabGift = false;
                    TalentScoutGiftComponent.this.disablePersonChoose();
                    TalentScoutGiftComponent.this.onTalentScoutGiftBagTabChanged(true);
                }
            } else if (checkedId == R.id.talent_scout_tab_gift) {
                TalentScoutGiftComponent.this.isTabGift = true;
                TalentScoutGiftComponent.this.enablePersonChoose();
                TalentScoutGiftComponent.this.onTalentScoutGiftBagTabChanged(false);
            } else if (checkedId == R.id.talent_scout_tab_bag) {
                TalentScoutGiftComponent.this.isTabGift = false;
                TalentScoutGiftComponent.this.disablePersonChoose();
                TalentScoutGiftComponent.this.onTalentScoutGiftBagTabChanged(true);
            }
        }
    };
    private LinearLayout mGiftRightControllLandLayout;
    private View mLandRightView;
    private View llAmountFull;
    private DecimalFormat df;
    private View mGiftDivLine;
    private View.OnClickListener personChooseClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            TalentScoutGiftComponent.this.showPopupPersonList(v);
        }
    };

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = super.onCreateView(inflater, container, savedInstanceState);
        if (((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            this.initTalentScoutView();
            this.initData();
        }
        MLog.info((Object)TAG, (String)"onCreateView", (Object[])new Object[0]);
        return rootView;
    }

    private void initData() {
        ArrayList<Integer> moneyTypes = new ArrayList<Integer>();
        moneyTypes.add(10);
        ((IPayCore)ICoreManagerBase.getCore(IPayCore.class)).queryMoneyBalance(LoginUtil.getUid(), moneyTypes);
        this.setCurrentPersonChooseName();
        this.df = new DecimalFormat("#,###.#");
    }

    private void setCurrentPersonChooseName() {
        if (this.mPersonListAdapter == null) {
            this.mPersonListAdapter = new PersonChooseAdpter();
            TalentScoutInfo info = ((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).getCurrentTalentScoutState();
            ArrayList<PersonInfo> infos = new ArrayList<PersonInfo>();
            infos.add(new PersonInfo(info.scoutName, true, info.scoutTopid, info.scoutSubid, info.scoutUid));
            infos.add(new PersonInfo(info.talentName, false, info.talentTopid, info.talentSubid, info.talentUid));
            this.mPersonListAdapter.setData(infos);
            this.mPersonListAdapter.selectPos(0);
        }
        this.mTalentScoutPersonChoose.setText((CharSequence)("\u9001 " + this.mPersonListAdapter.getCurrentSelectInfo().name));
        this.mTalentScoutPersonChooseLand.setText((CharSequence)("\u9001 " + this.mPersonListAdapter.getCurrentSelectInfo().name));
    }

    @Override
    public void onQueryMoneyBalance(int result, MoneyBalance moneyBalance) {
        if (!((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return;
        }
        double v = (double)moneyBalance.amount / 1000.0;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("money balance=" + v), (Object[])new Object[0]);
        }
        if (this.mTalentScoutYCurrency != null) {
            this.mTalentScoutYCurrency.setText((CharSequence)this.df.format(v));
        }
    }

    private void initTalentScoutView() {
        int w;
        this.giftTabLayout.setVisibility(8);
        this.mRechargeTv.setVisibility(8);
        this.tvBalance.setVisibility(8);
        this.giftTabLayoutLand.setVisibility(8);
        this.tvBalanceLand.setVisibility(8);
        this.mTvRechargeFull.setVisibility(8);
        this.mFullScreenSendView.setVisibility(8);
        if (this.mBottomView instanceof ViewGroup) {
            this.mTalentScoutPersonChoose = this.createChoosePersonButton(false, 0, 0);
            ((ViewGroup)this.mBottomView).addView((View)this.mTalentScoutPersonChoose);
        }
        View talentScoutSubBarView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.talent_scout_subbar_layout, null);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, DensityUtil.dip2px((Context)this.getContext(), (float)40.0f));
        lp.addRule(2, R.id.rl_gift_list);
        talentScoutSubBarView.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (this.mRootView instanceof ViewGroup) {
            this.mRootView.addView(talentScoutSubBarView);
        }
        if (this.mStarTaskRoot.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp2 = (RelativeLayout.LayoutParams)this.mStarTaskRoot.getLayoutParams();
            lp2.addRule(2, R.id.talent_scout_layout);
        }
        this.mGiftRightControllLandLayout = (LinearLayout)this.mRootView.findViewById(R.id.gift_right_controll_land_layout);
        this.mLandRightView = this.mRootView.findViewById(R.id.ll_amount_send_layout_full_screen);
        this.llAmountFull = this.mRootView.findViewById(R.id.ll_amount_full);
        this.mLandRightView.setBackgroundColor(this.getResources().getColor(R.color.color_white));
        this.mGiftRightControllLandLayout.getLayoutParams().width = w = DensityUtil.dip2px((Context)this.getContext(), (float)200.0f);
        int h = DensityUtil.dip2px((Context)this.getContext(), (float)34.0f);
        this.mTalentScoutPersonChooseLand = this.createChoosePersonButton(true, 0, h);
        this.mGiftRightControllLandLayout.addView((View)this.mTalentScoutPersonChooseLand, 0);
        this.mFullScreenAmountTv.getLayoutParams().width = w - DensityUtil.dip2px((Context)this.getContext(), (float)20.0f) - this.mRootView.findViewById((int)R.id.tv_send_gift_full_screen).getLayoutParams().width;
        this.mRootView.findViewById((int)R.id.tv_send_gift_full_screen).getLayoutParams().height = h;
        this.mFullScreenAmountTv.getLayoutParams().height = h;
        View touYin = new View(this.getContext());
        touYin.setBackgroundResource(R.drawable.windows_shadow);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(DensityUtil.dip2px((Context)this.getContext(), (float)2.0f), this.getResources().getDimensionPixelSize(R.dimen.gift_grid_item_height));
        layoutParams.addRule(0, R.id.ll_amount_send_layout_full_screen);
        touYin.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mGiftPageView instanceof ViewGroup) {
            ((ViewGroup)this.mGiftPageView).addView(touYin);
        }
        this.mTalentScoutLayout = talentScoutSubBarView.findViewById(R.id.talent_scout_layout);
        this.mTalentScoutGiftTabLayout = (AdvancedRadioGroup)talentScoutSubBarView.findViewById(R.id.talent_scout_gift_tab_layout);
        this.mTalentScoutTabGift = (RadioButton)talentScoutSubBarView.findViewById(R.id.talent_scout_tab_gift);
        this.mTalentScoutYCurrency = (TextView)talentScoutSubBarView.findViewById(R.id.talent_scout_y_currency);
        this.mTalentScoutRecharge = (TextView)talentScoutSubBarView.findViewById(R.id.talent_scout_recharge);
        this.mGiftDivLine = this.mRootView.findViewById(R.id.gift_div_line);
        this.mGiftDivLine.setBackgroundResource(R.color.color_white);
        this.mTalentScoutPersonChooseLand.setVisibility(8);
        this.mTalentScoutPersonChoose.setVisibility(0);
        this.mTalentScoutLayout.setVisibility(0);
        this.mTalentScoutYCurrency.setOnClickListener(this.moneyBalanceClick);
        this.mTalentScoutGiftTabLayout.setOnCheckedChangeListener(this.onTalentScoutCheckedChangeListener);
        this.mTalentScoutRecharge.setOnClickListener(this.mRechargeClick);
        this.mTalentScoutPersonChoose.setOnClickListener(this.personChooseClickListener);
        this.mTalentScoutPersonChooseLand.setOnClickListener(this.personChooseClickListener);
        if (!this.mIsFullScreen) {
            this.tabGift.setChecked(true);
            this.mTalentScoutTabGift.setChecked(true);
            this.isTabGift = true;
        } else {
            this.tabGiftLand.setChecked(true);
            this.isTabGift = true;
        }
    }

    private TextView createChoosePersonButton(boolean isLand, int w, int h) {
        YYTextView tv = new YYTextView(this.getContext());
        tv.setMaxLines(1);
        tv.setGravity(17);
        tv.setBackgroundResource(R.drawable.bg_choose_person_selector);
        tv.setTextSize(13.0f);
        tv.setTextColor(this.getResources().getColor(R.color.live_common_color_1));
        if (isLand) {
            LinearLayout.LayoutParams l = new LinearLayout.LayoutParams(-1, h);
            l.topMargin = DensityUtil.dip2px((Context)this.getContext(), (float)8.0f);
            l.leftMargin = l.rightMargin = DensityUtil.dip2px((Context)this.getContext(), (float)10.0f);
            tv.setLayoutParams((ViewGroup.LayoutParams)l);
        } else {
            RelativeLayout.LayoutParams rLayoutP = new RelativeLayout.LayoutParams(-1, -2);
            rLayoutP.leftMargin = DensityUtil.dip2px((Context)this.getContext(), (float)10.0f);
            rLayoutP.rightMargin = 2 * rLayoutP.leftMargin;
            rLayoutP.addRule(0, R.id.ll_amount);
            rLayoutP.addRule(15);
            tv.setLayoutParams((ViewGroup.LayoutParams)rLayoutP);
        }
        return tv;
    }

    private void disablePersonChoose() {
        this.currentPos = this.mPersonListAdapter.getCurrentSelectPos();
        this.mPersonListAdapter.selectPos(0);
        this.mTalentScoutPersonChoose.setEnabled(false);
        this.mTalentScoutPersonChooseLand.setEnabled(false);
        this.setCurrentPersonChooseName();
    }

    private void enablePersonChoose() {
        if (this.currentPos != -1) {
            this.mTalentScoutPersonChoose.setEnabled(true);
            this.mTalentScoutPersonChooseLand.setEnabled(true);
            this.mPersonListAdapter.selectPos(this.currentPos);
            this.setCurrentPersonChooseName();
            this.currentPos = -1;
        }
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return;
        }
        if (!hidden) {
            MLog.info((Object)TAG, (String)"onHiddenChanged", (Object[])new Object[0]);
            if (this.mTalentScoutPersonChoose == null) {
                this.initTalentScoutView();
                this.initData();
            }
            if (this.mIsFullScreen) {
                this.mTalentScoutPersonChooseLand.setVisibility(0);
                this.giftTabLayoutLand.setVisibility(8);
                this.tvBalanceLand.setVisibility(8);
                this.mTvRechargeFull.setVisibility(8);
            } else {
                this.mTalentScoutPersonChooseLand.setVisibility(8);
                this.giftTabLayout.setVisibility(8);
                this.mRechargeTv.setVisibility(8);
                this.tvBalance.setVisibility(8);
            }
            this.setCurrentPersonChooseName();
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (!((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return;
        }
        if (isLandscape) {
            this.mTalentScoutPersonChooseLand.setVisibility(0);
            this.giftTabLayoutLand.setVisibility(8);
            this.tvBalanceLand.setVisibility(8);
            this.mTvRechargeFull.setVisibility(8);
        } else {
            this.mTalentScoutPersonChooseLand.setVisibility(8);
            this.giftTabLayout.setVisibility(8);
            this.mRechargeTv.setVisibility(8);
            this.tvBalance.setVisibility(8);
        }
    }

    @Override
    protected boolean isCanSendArGift() {
        this.toast("\u62b1\u6b49,\u661f\u63a2\u8fde\u9ea6\u65f6\u65e0\u6cd5\u8d60\u9001AR\u793c\u7269\uff5e");
        return false;
    }

    private void onTalentScoutGiftBagTabChanged(boolean isCheck) {
        if (isCheck) {
            this.mGiftViewPager.setPagingEnabled(false);
            this.loadGiftBagTab();
            this.toggoleGfitBagTabTip(true);
            this.setAmountButtonStatus(this.mPackageSelectedGiftItem);
            ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).queryFreeGift();
        } else {
            this.mGiftViewPager.setPagingEnabled(true);
            this.hideGiftBagTab();
            this.toggoleGfitBagTabTip(false);
            this.setAmountButtonStatus(this.mGiftItemPagerAdapter.getSelectedItem());
        }
    }

    private void showPopupPersonList(View anchorView) {
        if (this.mPersonListAdapter == null) {
            this.mPersonListAdapter = new PersonChooseAdpter();
        }
        if (this.mPersonListPopupView == null) {
            ListView personListView = (ListView)this.getActivity().getLayoutInflater().inflate(R.layout.gift_link_amount_list, null);
            personListView.setAdapter((ListAdapter)this.mPersonListAdapter);
            personListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (TalentScoutGiftComponent.this.mPersonListPopupView != null && TalentScoutGiftComponent.this.mPersonListPopupView.isShowing()) {
                        TalentScoutGiftComponent.this.mPersonListPopupView.dismiss();
                    }
                    TalentScoutGiftComponent.this.mPersonListAdapter.selectPos(position);
                    TalentScoutGiftComponent.this.setCurrentPersonChooseName();
                }
            });
            this.mPersonListPopupView = new PopupWindow((Context)this.getActivity());
            this.mPersonListPopupView.setContentView((View)personListView);
            this.mPersonListPopupView.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.mPersonListPopupView.setOutsideTouchable(true);
            this.mPersonListPopupView.setFocusable(true);
            this.mPersonListPopupView.setWidth(this.getActivity().getResources().getDimensionPixelSize(R.dimen.channel_gift_amount_list_width));
            this.mPersonListPopupView.setHeight(-2);
            this.mPersonListPopupView.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                }
            });
        } else {
            this.mPersonListAdapter.notifyDataSetChanged();
        }
        int[] location = new int[2];
        anchorView.getLocationOnScreen(location);
        int x = location[0] + anchorView.getWidth() / 2 - this.mPersonListPopupView.getWidth() / 2;
        int y = this.mIsFullScreen ? this.mLandRightView.getHeight() : this.mBottomView.getHeight();
        this.mPersonListPopupView.showAtLocation(anchorView, 83, x, y);
    }

    @Override
    protected int[] createPopupWindownPos(View view, PopupWindow popupWindow) {
        if (view == null) {
            return null;
        }
        if (!((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return null;
        }
        if (this.mIsFullScreen && popupWindow != null && this.llAmountFull != null) {
            int[] location = new int[2];
            view.getLocationOnScreen(location);
            int[] popLocation = new int[]{location[0] + view.getWidth() / 2 - popupWindow.getWidth() / 2, this.llAmountFull.getHeight() + DensityUtil.dip2px((Context)this.getContext(), (float)2.0f)};
            return popLocation;
        }
        return null;
    }

    @Override
    protected long getSendToUid() {
        if (this.mPersonListAdapter != null && this.mPersonListAdapter.getCurrentSelectInfo() != null && ((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return this.mPersonListAdapter.getCurrentSelectInfo().uid;
        }
        return 0L;
    }

    @Override
    protected void onGiftSelectedNotify(GiftConfigItemBase giftItem) {
        if (!((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel()) {
            return;
        }
        if (giftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
            this.disablePersonChoose();
        } else {
            this.enablePersonChoose();
        }
    }

    @Override
    protected Map<String, String> getExtendInfo() {
        if (((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutAnchorChannel()) {
            HashMap<String, String> extendInfo = new HashMap<String, String>();
            extendInfo.put("client_show_style_tag", "1");
            return extendInfo;
        }
        if (this.mPersonListAdapter != null && this.mPersonListAdapter.getCurrentSelectInfo() != null && ((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).isTalentScoutChannel() && ((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).getCurrentTalentScoutState() != null) {
            HashMap<String, String> extendInfo = new HashMap<String, String>();
            extendInfo.put("client_show_style_tag", "1");
            if (this.getSendToUid() != ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId()) {
                extendInfo.put("prop_recipient_sign", ((ITalentScoutCore)ICoreManagerBase.getCore(ITalentScoutCore.class)).getCurrentTalentScoutState().signature);
                extendInfo.put("prop_recipient_topcid", String.valueOf(this.mPersonListAdapter.getCurrentSelectInfo().sid));
                extendInfo.put("prop_recipient_subcid", String.valueOf(this.mPersonListAdapter.getCurrentSelectInfo().ssid));
                extendInfo.put("7", "true");
            }
            return extendInfo;
        }
        return new HashMap<String, String>();
    }

    private static class PersonInfo {
        public String name;
        public boolean isSelected;
        public long sid;
        public long ssid;
        public long uid;

        private PersonInfo() {
        }

        private PersonInfo(String name, boolean isSelected) {
            this.name = name;
            this.isSelected = isSelected;
        }

        private PersonInfo(String name, boolean isSelected, long uid) {
            this.name = name;
            this.isSelected = isSelected;
            this.uid = uid;
        }

        private PersonInfo(String name, boolean isSelected, long ssid, long sid, long uid) {
            this.name = name;
            this.isSelected = isSelected;
            this.ssid = ssid;
            this.sid = sid;
            this.uid = uid;
        }
    }

    public class PersonChooseAdpter
    extends BaseAdapter {
        public List<PersonInfo> infoList = new ArrayList<PersonInfo>();
        private int mCurrentSelectPos;

        public int getCount() {
            return this.infoList.size();
        }

        public PersonInfo getItem(int position) {
            if (this.infoList.size() > position) {
                return this.infoList.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getCurrentSelectPos() {
            return this.mCurrentSelectPos;
        }

        public void selectPos(int currentSelectPos) {
            if (currentSelectPos != this.mCurrentSelectPos) {
                if (this.getItem(currentSelectPos) != null) {
                    this.getItem((int)currentSelectPos).isSelected = true;
                }
                if (this.getItem(this.mCurrentSelectPos) != null) {
                    this.getItem((int)this.mCurrentSelectPos).isSelected = false;
                }
                this.mCurrentSelectPos = currentSelectPos;
            }
        }

        public PersonInfo getCurrentSelectInfo() {
            return this.getItem(this.mCurrentSelectPos);
        }

        public void setData(List<PersonInfo> data) {
            this.infoList.clear();
            this.infoList.addAll(data);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView personName;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)TalentScoutGiftComponent.this.getContext()).inflate(R.layout.talent_scout_person_list_item, parent, false);
                personName = (TextView)convertView.findViewById(R.id.talent_person_name);
                convertView.setTag((Object)personName);
            } else {
                personName = (TextView)convertView.getTag();
            }
            PersonInfo info = this.infoList.get(position);
            personName.setText((CharSequence)info.name);
            if (info.isSelected) {
                convertView.setBackgroundResource(R.color.common_new_gold_color);
            } else {
                convertView.setBackgroundResource(R.color.common_color_11);
            }
            return convertView;
        }
    }
}

