/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.fullservicebroadcast;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;

public class AirplaneBCLinearLayout
extends LinearLayout {
    private static final String TAG = "AirplaneBCLinearLayout";
    private LinearLayout llAirplaneBc;
    private TextView tvAirplaneBcInfo;
    private TextView tvAirplaneBcSid;
    private AnimatorSet mHengFuAnimatorSet;
    private AnimatorSet mTxtAnimatorSet;
    private AnimatorSet mSidAnimatorSet;
    private AnimatorSet mTotalAnimatorSet;
    private Runnable showTvAirPlaneTask = new Runnable(){

        @Override
        public void run() {
            if (AirplaneBCLinearLayout.this.tvAirplaneBcInfo != null && AirplaneBCLinearLayout.this.llAirplaneBc != null) {
                AirplaneBCLinearLayout.this.tvAirplaneBcInfo.setTranslationX((float)AirplaneBCLinearLayout.this.llAirplaneBc.getMeasuredWidth());
                AirplaneBCLinearLayout.this.tvAirplaneBcInfo.setVisibility(0);
                AirplaneBCLinearLayout.this.tvAirplaneBcInfo.setAlpha(1.0f);
            }
        }
    };

    public AirplaneBCLinearLayout(Context context) {
        super(context);
        this.initViews();
    }

    private void initViews() {
        LinearLayout root = (LinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_airplane_bc, null);
        root.measure(0, 0);
        this.addView((View)root, new ViewGroup.LayoutParams(-1, -2));
        this.llAirplaneBc = (LinearLayout)this.findViewById(R.id.ll_airplane_bc);
        this.tvAirplaneBcInfo = (TextView)this.findViewById(R.id.tv_airplane_bc_info);
        this.tvAirplaneBcSid = (TextView)this.findViewById(R.id.tv_airplane_bc_sid);
        this.mHengFuAnimatorSet = new AnimatorSet();
        this.mTxtAnimatorSet = new AnimatorSet();
        this.mSidAnimatorSet = new AnimatorSet();
    }

    private void buildHengfuAnim() {
        ObjectAnimator translationRight = ObjectAnimator.ofFloat((Object)this.llAirplaneBc, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.convertDpToPixel((float)8.0f, (Context)this.getContext())});
        translationRight.setDuration(160L);
        ObjectAnimator translationLeft = ObjectAnimator.ofFloat((Object)this.llAirplaneBc, (String)"translationX", (float[])new float[]{ResolutionUtils.convertDpToPixel((float)8.0f, (Context)this.getContext()), (float)(-this.llAirplaneBc.getMeasuredWidth()) * 0.8f});
        translationLeft.setDuration(1480L);
        translationRight.setStartDelay(5000L);
        this.mHengFuAnimatorSet.play((Animator)translationLeft).after((Animator)translationRight);
        this.mHengFuAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (AirplaneBCLinearLayout.this.llAirplaneBc != null) {
                    AirplaneBCLinearLayout.this.llAirplaneBc.setVisibility(0);
                    AirplaneBCLinearLayout.this.llAirplaneBc.setTranslationX(0.0f);
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (AirplaneBCLinearLayout.this.llAirplaneBc != null) {
                    AirplaneBCLinearLayout.this.llAirplaneBc.setVisibility(4);
                }
                AirplaneBCLinearLayout.this.setVisibility(4);
            }
        });
    }

    private void buildTxtAnim() {
        this.llAirplaneBc.measure(0, 0);
        this.tvAirplaneBcInfo.measure(0, 0);
        ObjectAnimator translationIn = ObjectAnimator.ofFloat((Object)this.tvAirplaneBcInfo, (String)"translationX", (float[])new float[]{this.llAirplaneBc.getMeasuredWidth(), this.llAirplaneBc.getMeasuredWidth() / 2 - this.tvAirplaneBcInfo.getMeasuredWidth() / 2});
        translationIn.setDuration(1360L);
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.tvAirplaneBcInfo, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        fadeOut.setDuration(240L);
        fadeOut.setStartDelay(5120L);
        this.mTxtAnimatorSet.play((Animator)translationIn).with((Animator)fadeOut);
        this.mTxtAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (AirplaneBCLinearLayout.this.mTxtAnimatorSet != null) {
                    YYTaskExecutor.postToMainThread((Runnable)AirplaneBCLinearLayout.this.showTvAirPlaneTask, (long)AirplaneBCLinearLayout.this.mTxtAnimatorSet.getStartDelay());
                }
            }

            public void onAnimationEnd(Animator animation) {
                AirplaneBCLinearLayout.this.tvAirplaneBcInfo.setVisibility(4);
            }
        });
    }

    private void buildSidAnim() {
        ObjectAnimator fadeIn = ObjectAnimator.ofFloat((Object)this.tvAirplaneBcSid, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeIn.setDuration(160L);
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.tvAirplaneBcSid, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        fadeOut.setDuration(280L);
        fadeOut.setStartDelay(5000L);
        this.mSidAnimatorSet.play((Animator)fadeIn).with((Animator)fadeOut);
        this.mSidAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                AirplaneBCLinearLayout.this.tvAirplaneBcSid.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AirplaneBCLinearLayout.this.tvAirplaneBcSid.setAlpha(0.0f);
                        AirplaneBCLinearLayout.this.tvAirplaneBcSid.setVisibility(0);
                    }
                }, AirplaneBCLinearLayout.this.mSidAnimatorSet.getStartDelay());
            }

            public void onAnimationEnd(Animator animation) {
                AirplaneBCLinearLayout.this.tvAirplaneBcSid.setVisibility(4);
            }
        });
    }

    public void playTotalAnim() {
        if (this.mHengFuAnimatorSet != null) {
            this.mHengFuAnimatorSet.removeAllListeners();
            this.mHengFuAnimatorSet.end();
        }
        if (this.mTxtAnimatorSet != null) {
            this.mTxtAnimatorSet.removeAllListeners();
            this.mTxtAnimatorSet.end();
        }
        if (this.mSidAnimatorSet != null) {
            this.mSidAnimatorSet.removeAllListeners();
            this.mSidAnimatorSet.end();
        }
        if (this.mTotalAnimatorSet != null && this.mTotalAnimatorSet.isRunning()) {
            this.mTotalAnimatorSet.removeAllListeners();
            this.mTotalAnimatorSet.end();
        }
        this.setVisibility(0);
        this.buildHengfuAnim();
        this.buildTxtAnim();
        this.buildSidAnim();
        this.mTxtAnimatorSet.setStartDelay(640L);
        this.mTotalAnimatorSet = new AnimatorSet();
        this.mTotalAnimatorSet.play((Animator)this.mHengFuAnimatorSet).with((Animator)this.mTxtAnimatorSet).with((Animator)this.mSidAnimatorSet);
        this.mTotalAnimatorSet.start();
    }

    public void setTxtInfo(SpannableString ss) {
        this.tvAirplaneBcInfo.setText((CharSequence)ss);
    }

    public void setSid(long sid) {
        this.tvAirplaneBcSid.setText((CharSequence)("\u9891\u9053: " + sid));
    }

    public void setHengFuBg(int resId) {
        this.llAirplaneBc.setBackgroundResource(resId);
    }

    public void setSidBg(int resId) {
        this.tvAirplaneBcSid.setBackgroundResource(resId);
    }

    public void onDestroy() {
        if (this.mTotalAnimatorSet != null && this.mTotalAnimatorSet.isRunning()) {
            this.mTotalAnimatorSet.end();
        }
        this.setVisibility(8);
        YYTaskExecutor.removeTask((Runnable)this.showTvAirPlaneTask);
    }
}

