/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_setDanMuAlpha_EventArgs;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_setDanMuLines_EventArgs;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_showSurfaceDanmuStatus_EventArgs;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_switchShowDanmuStatus_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.giftdanmu.DanMuPosition;
import com.yy.live.module.giftdanmu.LiveDanMuUtil;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.ChannelAirTicketParser;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicgunview.BaseDanMuComponent$$EventBinder;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.danmucanvas.utils.BitMapPool;
import com.yy.mobile.ui.basicgunview.danmucanvas.view.DanmuViewCanvas;
import com.yy.mobile.ui.basicgunview.danmuopengl.DanmakuSurfaceView;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanMuItemStub;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.TexturePool;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.ui.touch.uicore.ITouchCore;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basicgunview.DanmuConfigValue;
import com.yymobile.core.basicgunview.IDanmuConfigCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.live.LiveCore.JoinChannelIntent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseDanMuComponent
extends Component {
    private static final String TAG = "BaseDanMuComponent";
    public static final String AIR_TICKET_REG = "((((?i)yy)://pd-)((\\[([^\\].]+)\\])|(\\w+))(/\\[([^\\]]+)\\])?)";
    protected ViewGroup rootView;
    protected View mViewBg;
    protected IDanmukuView tanmuView;
    protected float totalWidth;
    protected IDanmuConfigCore danmuConfigCore;
    protected boolean isSurfaceView = false;
    protected Rect danMuViewLayoutMargin;
    protected RelativeLayout.LayoutParams danMuViewLayoutParams;
    protected int sid = 0;
    protected int subSid = 0;
    protected IDanmuClickListener defluatDanmuClickListener = new IDanmuClickListener(){

        public void setOnClickListener(DanMuItemStub stub) {
            String content = stub.content;
            if (content == null) {
                return;
            }
            try {
                GunSid ss;
                if ((ChannelTicketFilter.isChannelTicketMessage((CharSequence)content) || YGroupTicketFilter.isYGroupTicketMessage((CharSequence)content)) && (ss = BaseDanMuComponent.this.parsePlaneTicket(content)) != null) {
                    ChannelInfo info = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
                    long topid = info.topSid;
                    long subSid = info.subSid;
                    if (topid != (long)ss.sid || subSid != ss.subSid) {
                        BaseDanMuComponent.this.getLinkDialogManager().showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u786e\u5b9a\u9000\u51fa\u5f53\u524d\u76f4\u64ad\u95f4?", (CharSequence)"\u786e\u8ba4", (CharSequence)"\u53d6\u6d88", true, true, new OkCancelDialogListener(){

                            public void onCancel() {
                            }

                            public void onOk() {
                                JoinChannelIntent.instance((long)ss.sid, (long)ss.subSid).src("90001").build().joinChannel((Context)BaseDanMuComponent.this.getActivity());
                            }
                        }));
                    }
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)BaseDanMuComponent.TAG, (Throwable)throwable);
            }
        }
    };
    private boolean mLandscape;
    private int switchShowDanmuCount = 0;
    private Runnable danmuEnabledRunnable = new Runnable(){

        @Override
        public void run() {
            if (BaseDanMuComponent.this.tanmuView != null) {
                MLog.info((Object)BaseDanMuComponent.TAG, (String)"showDanMuView", (Object[])new Object[0]);
                if (BaseDanMuComponent.this.isDanmuEnabled()) {
                    BaseDanMuComponent.this.tanmuView.setVisibility(0);
                }
            } else {
                MLog.error((Object)BaseDanMuComponent.TAG, (String)"showDanMuView failed, tanmuView is null", (Object[])new Object[0]);
            }
        }
    };
    private EventBinder mBaseDanMuComponentSniperEventBinder;

    protected abstract void doBgShow(boolean var1);

    protected abstract void onLandscape();

    protected abstract void onPortrait();

    protected abstract boolean doSuperJoinChannelSuccess();

    protected abstract void initJoinChannelSuccess();

    protected abstract boolean isReplayDanmuConfig();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"onCreate", (Object[])new Object[0]);
        ICoreManagerBase.addClient((Object)((Object)this));
        this.danmuConfigCore = (IDanmuConfigCore)ICoreManagerBase.getCore(IDanmuConfigCore.class);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup view, Bundle savedInstanceState) {
        this.rootView = (ViewGroup)inflater.inflate(R.layout.fragment_basic_danmu, view, false);
        this.mViewBg = this.rootView.findViewById(R.id.public_dan_mu_view);
        MLog.info((Object)TAG, (String)"onCreateView", (Object[])new Object[0]);
        TexturePool.uninit();
        this.setLandscape(ActivityUtilKt.isLandScape((Activity)this.getActivity()));
        this.initDanmuView();
        this.totalWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.initDanmuParameter();
        this.initView();
        this.onCreateShowView();
        return this.rootView;
    }

    protected boolean shouldDanmuShow() {
        return this.isLandscape();
    }

    protected boolean isLandscape() {
        return this.mLandscape;
    }

    private void setLandscape(boolean landscape) {
        this.mLandscape = landscape;
    }

    private void onCreateShowView() {
        if (this.shouldDanmuShow()) {
            this.showSelf();
            this.setDanmuViewLayoutForShowView();
            if (this.tanmuView != null) {
                this.tanmuView.setOpenView();
            }
        } else {
            this.hideSelf();
            if (this.tanmuView != null) {
                this.tanmuView.setCloseView();
            }
        }
    }

    protected void initDanmuView() {
        DanmuConfigValue danmuConfigValue = this.danmuConfigCore.judgeDanmuFlg(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid, this.isReplayDanmuConfig());
        switch (danmuConfigValue) {
            case Canvas: {
                this.tanmuView = new DanmuViewCanvas(this.getContext());
                MLog.info((Object)TAG, (String)"DanmuViewCanvas", (Object[])new Object[0]);
                this.isSurfaceView = false;
                break;
            }
            case OpenGLSurfaceView: {
                this.tanmuView = new DanmakuSurfaceView(this.getContext());
                MLog.info((Object)TAG, (String)"DanmakuSurfaceView", (Object[])new Object[0]);
                this.isSurfaceView = true;
                break;
            }
            default: {
                this.tanmuView = new DanmakuSurfaceView(this.getContext());
                MLog.info((Object)TAG, (String)"DanmakuSurfaceView", (Object[])new Object[0]);
                this.isSurfaceView = true;
            }
        }
        this.tanmuView.setDanMuAlpha(100);
    }

    protected void initDanmuParameter() {
        if (this.tanmuView != null) {
            this.tanmuView.setScreenWidth(this.totalWidth);
            this.tanmuView.setLineSpace(4);
            this.tanmuView.setSpeed(60.0f);
            this.tanmuView.setDrawTime(4000);
            this.tanmuView.setOnClickListener(this.defluatDanmuClickListener);
            this.tanmuView.setLines(3);
            this.setDanmuViewLayoutForShowView();
        }
    }

    protected void setDanmuViewLayoutForShowView() {
        RelativeLayout.LayoutParams lp = this.getDanMuViewLayoutParams();
        DanMuPosition danMuPosition = LiveDanMuUtil.getDanMuPosition();
        MLog.info((Object)TAG, (String)"setDanmuViewLayoutForShowView: %s", (Object[])new Object[]{danMuPosition});
        Context context = this.getContext();
        float marginBottom = danMuPosition == DanMuPosition.BOTTOM ? (this.tanmuView.getLines() > 2 ? 45.0f : 75.0f) : 0.0f;
        int marginTop = danMuPosition == DanMuPosition.BOTTOM ? 0 : DensityUtil.dip2px((Context)context, (float)-16.0f);
        this.setDanMuViewLayoutMargin(0, marginTop, (int)ResolutionUtils.convertDpToPixel((float)48.0f, (Context)this.getContext()), (int)ResolutionUtils.convertDpToPixel((float)marginBottom, (Context)this.getContext()));
        if (this.danMuViewLayoutMargin != null) {
            lp.setMargins(this.danMuViewLayoutMargin.left, this.danMuViewLayoutMargin.top, this.danMuViewLayoutMargin.right, this.danMuViewLayoutMargin.bottom);
        }
        if (danMuPosition == DanMuPosition.BOTTOM) {
            lp.addRule(10, 0);
            lp.addRule(12);
        } else if (danMuPosition == DanMuPosition.TOP) {
            lp.addRule(12, 0);
            lp.addRule(10);
        }
        if (this.tanmuView != null) {
            this.tanmuView.showView(this.rootView, lp);
        }
    }

    protected RelativeLayout.LayoutParams getDanMuViewLayoutParams() {
        if (this.danMuViewLayoutParams == null) {
            this.danMuViewLayoutParams = new RelativeLayout.LayoutParams(-1, (int)ResolutionUtils.convertDpToPixel((float)90.0f, (Context)this.getContext()));
        }
        return this.danMuViewLayoutParams;
    }

    protected void setDanMuViewLayoutMargin(int left, int top, int right, int bottom) {
        if (this.danMuViewLayoutMargin == null) {
            this.danMuViewLayoutMargin = new Rect();
        }
        this.danMuViewLayoutMargin.set(left, top, right, bottom);
    }

    public void onOrientationChanged(boolean isLandscape) {
        MLog.info((Object)TAG, (String)("onOrientationChanged  isLandscape = " + isLandscape), (Object[])new Object[0]);
        this.setLandscape(isLandscape);
        this.doBgShow(isLandscape);
        this.switchShowDanmuCount = 0;
        if (isLandscape) {
            this.onLandscape();
        } else {
            this.onPortrait();
        }
        if (this.shouldDanmuShow()) {
            this.totalWidth = this.getResources().getDisplayMetrics().widthPixels;
            this.showSelf();
            if (this.tanmuView != null) {
                this.tanmuView.setScreenWidth(this.totalWidth);
                this.setDanmuViewLayoutForShowView();
                if (this.tanmuView.onDanmuSwitch()) {
                    this.tanmuView.setCloseView();
                }
                this.tanmuView.setOpenView();
            }
        } else {
            if (this.tanmuView != null) {
                this.tanmuView.hideView(this.rootView);
                if (this.tanmuView.onDanmuSwitch()) {
                    this.tanmuView.setCloseView();
                }
            }
            this.hideSelf();
        }
    }

    public void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"onResume", (Object[])new Object[0]);
        this.doOnResume();
    }

    protected void doOnResume() {
        if (this.shouldDanmuShow() && this.tanmuView != null && !this.tanmuView.onDanmuSwitch()) {
            TexturePool.uninit();
            this.tanmuView.onResume();
            this.tanmuView.setOpenView();
        }
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"onPause", (Object[])new Object[0]);
        this.doOnPause();
    }

    protected void doOnPause() {
        if (this.shouldDanmuShow() && this.tanmuView != null && this.tanmuView.onDanmuSwitch()) {
            this.tanmuView.setCloseView();
            this.tanmuView.onPause();
        }
    }

    public void onStop() {
        super.onStop();
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
    }

    public void onDestroyView() {
        super.onDestroyView();
        MLog.info((Object)TAG, (String)"onDestroyView", (Object[])new Object[0]);
        this.onOrientationChanged(false);
        if (this.tanmuView != null) {
            this.tanmuView.setCloseView();
        }
        Object var2_1 = null;
        if (this.mBaseDanMuComponentSniperEventBinder != null) {
            this.mBaseDanMuComponentSniperEventBinder.unBindEvent();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        ICoreManagerBase.removeClient((Object)((Object)this));
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.danmuEnabledRunnable);
        }
        if (this.tanmuView != null) {
            if (!this.isSurfaceView) {
                BitMapPool.getInstance().recycle();
            }
            this.tanmuView.onDestory();
            this.tanmuView = null;
        }
    }

    public GunSid parsePlaneTicket(String msg) {
        GunSid gun = new GunSid();
        Pattern airTicketPattern = Pattern.compile(AIR_TICKET_REG);
        String numberReg = "[0-9]+";
        Pattern numberPattern = Pattern.compile(numberReg);
        try {
            if (ChannelAirTicketParser.isChannelTicketMessage((CharSequence)msg)) {
                String parseCompleteFormatMsg = String.valueOf(ChannelAirTicketParser.parseCompleteFormatMsg((CharSequence)msg));
                Matcher matcher = airTicketPattern.matcher(parseCompleteFormatMsg);
                while (matcher.find()) {
                    String channelMsg = parseCompleteFormatMsg.substring(matcher.start(), matcher.end());
                    Matcher m = numberPattern.matcher(channelMsg);
                    try {
                        if (m.find()) {
                            gun.sid = this.sid = Integer.parseInt(channelMsg.substring(m.start(), m.end()));
                        }
                        if (!m.find()) continue;
                        this.subSid = Integer.parseInt(channelMsg.substring(m.start(), m.end()));
                        gun.subSid = this.subSid;
                    }
                    catch (NumberFormatException e) {
                        MLog.error((Object)"jay_zs", (String)"parse Channel sid or subSid error :%s", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("throwable = " + throwable), (Object[])new Object[0]);
        }
        return gun;
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        if (this.doSuperJoinChannelSuccess() && channelInfo != null) {
            this.onDanmuJoinChannelSuccessConfig(channelInfo.topSid);
        }
        this.initJoinChannelSuccess();
    }

    protected void onDanmuJoinChannelSuccessConfig(long topSid) {
        if (this.shouldDanmuShow()) {
            if (this.tanmuView != null) {
                if (!(this.tanmuView instanceof SurfaceView) && this.danmuConfigCore.judgeDanmuFlg(topSid, this.isReplayDanmuConfig()) == DanmuConfigValue.OpenGLSurfaceView) {
                    this.initDanmuView();
                }
            } else {
                this.initDanmuView();
            }
            this.initDanmuParameter();
            this.setDanmuViewLayoutForShowView();
            if (this.tanmuView.onDanmuSwitch()) {
                this.tanmuView.setCloseView();
            }
            this.tanmuView.setOpenView();
        }
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        if (this.tanmuView != null) {
            this.tanmuView.setCloseView();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void switchShowDanmuStatus(IDanmuViewBasicClient_switchShowDanmuStatus_EventArgs busEventArgs) {
        boolean status = busEventArgs.mStatus;
        this.switchShowDanmuStatus(status);
        this.doBgShow(LiveDanMuUtil.getInstance().isDanmuEnabled());
    }

    public void switchShowDanmuStatus(boolean status) {
        MLog.info((Object)TAG, (String)("switchShowDanmuCount = " + this.switchShowDanmuCount + "  shouldDanmuShow = " + this.shouldDanmuShow() + " status = " + status + "  ICoreManagerBase.getCore(ITouchCore.class).getClearScreenSate() = " + ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()), (Object[])new Object[0]);
        if (this.shouldDanmuShow() && !((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()) {
            if (status) {
                this.switchShowDanmuCount = this.switchShowDanmuCount - 1 < 0 ? 0 : --this.switchShowDanmuCount;
                Handler handler = this.getHandler();
                if (this.switchShowDanmuCount == 0) {
                    if (handler != null) {
                        MLog.info((Object)TAG, (String)"show danmu with delay", (Object[])new Object[0]);
                        handler.removeCallbacks(this.danmuEnabledRunnable);
                        handler.postDelayed(this.danmuEnabledRunnable, 250L);
                    } else {
                        MLog.error((Object)TAG, (String)"show danmu failed, handler is null", (Object[])new Object[0]);
                    }
                }
            } else {
                ++this.switchShowDanmuCount;
                if (this.getHandler() != null) {
                    this.getHandler().removeCallbacks(this.danmuEnabledRunnable);
                }
                if (this.tanmuView != null) {
                    MLog.info((Object)TAG, (String)"hide danmu", (Object[])new Object[0]);
                    this.tanmuView.setVisibility(4);
                }
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void showSurfaceDanmuStatus(IDanmuViewBasicClient_showSurfaceDanmuStatus_EventArgs busEventArgs) {
        boolean open = busEventArgs.mOpen;
        if (this.tanmuView != null && this.tanmuView instanceof SurfaceView && this.isDanmuEnabled()) {
            if (open) {
                this.tanmuView.setVisibility(0);
            } else {
                this.tanmuView.setVisibility(4);
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void setDanMuLines(IDanmuViewBasicClient_setDanMuLines_EventArgs busEventArgs) {
        int lines = busEventArgs.mLines;
        Rect margin = busEventArgs.mMargin;
        boolean changeHeight = busEventArgs.mChangeHeight;
        MLog.info((Object)TAG, (String)("setDanMuLines: " + lines + ", " + margin + " changeHeight = " + changeHeight), (Object[])new Object[0]);
        this.setDanMuLine(lines, margin, changeHeight);
    }

    public void setDanMuLine(int lines, Rect margin, boolean changeHeight) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[setDanMuLine] lines " + lines + " margin = " + margin), (Object[])new Object[0]);
        }
        if (this.tanmuView != null) {
            if (lines != this.tanmuView.getLines()) {
                this.tanmuView.setLines(lines);
            }
            if (changeHeight) {
                this.getDanMuViewLayoutParams().height = DimensUtils.dip2pixel((Context)this.getContext(), (float)(30 * this.tanmuView.getLines()));
            }
            if (margin != null) {
                this.danMuViewLayoutMargin = margin;
            }
            this.setDanmuViewLayoutForShowView();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void setDanMuAlpha(IDanmuViewBasicClient_setDanMuAlpha_EventArgs busEventArgs) {
        int alpha = busEventArgs.mAlpha;
        this.setDanMuAlpha(alpha);
    }

    public void setDanMuAlpha(int alpha) {
        MLog.info((Object)TAG, (String)"setDanMuAlpha: %d", (Object[])new Object[]{alpha});
        if (this.tanmuView != null) {
            this.tanmuView.setDanMuAlpha(alpha);
        }
    }

    protected void initView() {
        LiveDanMuUtil.getInstance().setSurfaceView(this.isSurfaceView);
        LiveDanMuUtil.getInstance().setDanmuView(this.tanmuView);
        if (this.shouldDanmuShow()) {
            LiveDanMuUtil.getInstance().open(true);
        } else {
            LiveDanMuUtil.getInstance().open(false);
        }
    }

    public boolean isDanmuEnabled() {
        return LiveDanMuUtil.getInstance().isDanmuEnabled();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mBaseDanMuComponentSniperEventBinder == null) {
            this.mBaseDanMuComponentSniperEventBinder = new BaseDanMuComponent$$EventBinder();
        }
        this.mBaseDanMuComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    private static class GunSid {
        int sid = 0;
        long subSid = 0L;

        private GunSid() {
        }
    }
}

