/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.util.log.MLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StreamLineAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "StreamLineAdapter";
    private Map<Integer, List<AudienceVideoQuality>> mData;
    private Integer[] mKeyArray;
    private OnItemClickListener mListener;
    private int mCurrentLineNum;
    private AudienceVideoQuality mCurrentVideoQuality;

    public void setData(Map<Integer, List<AudienceVideoQuality>> data) {
        this.mData = data;
        StreamLineAdapter.sort(this.mData);
        this.mKeyArray = this.mData.keySet().toArray(new Integer[0]);
        Arrays.sort((Object[])this.mKeyArray);
    }

    public void setOnItemClickListener(OnItemClickListener listener2) {
        this.mListener = listener2;
    }

    public void setCurrentStream(int lineNum, AudienceVideoQuality quality) {
        this.mCurrentLineNum = lineNum;
        this.mCurrentVideoQuality = quality;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_streamline_info, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        final Integer lineKey = this.mKeyArray[position];
        holder.lineNum.setText((CharSequence)("\u7ebf\u8def" + lineKey));
        this.reset(holder);
        List<AudienceVideoQuality> qualities = this.mData.get(lineKey);
        MLog.debug((Object)TAG, (String)"onBindViewHolder, position:%d, qualitiesList:%s", (Object[])new Object[]{position, qualities});
        for (int qidx = 0; qidx < qualities.size(); ++qidx) {
            final AudienceVideoQuality quality = qualities.get(qidx);
            holder.btnArray[qidx].setVisibility(0);
            holder.btnArray[qidx].setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StreamLineAdapter.this.mListener != null && (StreamLineAdapter.this.mCurrentLineNum != lineKey || StreamLineAdapter.this.mCurrentVideoQuality != quality)) {
                        StreamLineAdapter.this.mListener.onClick(lineKey, quality);
                    }
                }
            });
            holder.btnArray[qidx].setText((CharSequence)quality.getName());
            MLog.debug((Object)TAG, (String)"qidx:%d, quality:%s", (Object[])new Object[]{qidx, quality});
            if (lineKey == this.mCurrentLineNum && this.mCurrentVideoQuality == quality) {
                holder.btnArray[qidx].setBackgroundResource(R.drawable.stream_quality_item_bg_selected);
                continue;
            }
            holder.btnArray[qidx].setBackgroundResource(R.drawable.stream_quality_item_bg_normal);
        }
    }

    public int getItemCount() {
        if (this.mData == null) {
            return 0;
        }
        return this.mKeyArray.length;
    }

    private void reset(ViewHolder holder) {
        for (TextView view : holder.btnArray) {
            view.setBackgroundResource(R.drawable.stream_quality_item_bg_normal);
            view.setText((CharSequence)"----");
            view.setVisibility(4);
        }
    }

    private static void sort(Map<Integer, List<AudienceVideoQuality>> data) {
        for (Integer integer2 : data.keySet()) {
            List<AudienceVideoQuality> videoQualities = data.get(integer2);
            Collections.sort(videoQualities, Collections.reverseOrder());
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView lineNum;
        TextView[] btnArray = new TextView[4];

        public ViewHolder(View itemView) {
            super(itemView);
            this.lineNum = (TextView)itemView.findViewById(R.id.line_num);
            this.btnArray[0] = (TextView)itemView.findViewById(R.id.btn0);
            this.btnArray[1] = (TextView)itemView.findViewById(R.id.btn1);
            this.btnArray[2] = (TextView)itemView.findViewById(R.id.btn2);
            this.btnArray[3] = (TextView)itemView.findViewById(R.id.btn3);
        }
    }

    public static interface OnItemClickListener {
        public void onClick(int var1, AudienceVideoQuality var2);
    }
}

