/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.audience;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IMicAudienceClient_addAudienceListView_EventArgs;
import com.duowan.mobile.entlive.events.IMicAudienceClient_onOnlineAudienceSuccessedNotify_EventArgs;
import com.duowan.mobile.entlive.events.IMicAudienceClient_onPreLeaveChannel_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.memoryrecycle.views.YYLinearLayout;
import com.yy.mobile.perf.PerfSDK;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onRequestLiveShare_EventArgs;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onSwipeSwitchTipNotify_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateisColse_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateisOpen_EventArgs;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IMicClient_notifyAnchorImMediateOPlayer_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceVideoQualityManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videoquality.IAudienceVideoQualityChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.statistic.StatisticService;
import com.yy.mobile.ui.audience.OnlineAudienceComponent$$EventBinder;
import com.yy.mobile.ui.audience.uicore.IMicAudienceCore;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.leavechannel.LeaveChannelHelper;
import com.yy.mobile.ui.mic.MicOnlineViewPagerComponent;
import com.yy.mobile.ui.widget.TipsPopupWindow;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.channelofficialInfo.IChannelOfficialInfoCore;
import com.yymobile.core.channelofficialInfo.OfficialInfo;
import com.yymobile.core.lianmai.ILianMaiCore;
import com.yymobile.core.lianmai.ILianMaiCoreEXT;
import com.yymobile.core.mic.uicore.IMicAndOnlineBehavior;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.statistic.LiveRoomOnlineViewerLoadSampling;
import java.util.List;
import java.util.Map;

public class OnlineAudienceComponent
extends Component
implements View.OnClickListener,
IAudienceVideoQualityChangeListener {
    private static final String TAG = "OnlineAudienceComponent";
    public static final String SHOW_MIC_DOT = "enableShowMicDot";
    private LeaveChannelHelper mLeaveChannelHelper;
    private View mRootView = null;
    private ViewGroup mAudienceListView = null;
    private ImageView mMicImg;
    private ImageView mMicDotImg;
    private TextView mGameCodeRateLineTxt;
    private View mExitViewPortrait = null;
    private boolean enableShowMicDot = true;
    private YYLinearLayout mGameTempFunctionView;
    private View.OnClickListener mOnlineMicOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51017", "0011");
            if (ICoreManagerBase.getCore(IMicAudienceCore.class) != null) {
                OnlineAudienceComponent.this.showMicAudienceListFragment(OnlineAudienceComponent.this.getRoot(), OnlineAudienceComponent.this.getFragmentManager());
            }
        }
    };
    private View.OnClickListener mExitOnClickListener = this.getExitOnClickListener();
    private TipsPopupWindow tipsPopupWindow;
    private Runnable hideTipsPopWindowRunnable = new Runnable(){

        @Override
        public void run() {
            OnlineAudienceComponent.this.hideTipsPopWindow();
        }
    };
    private EventBinder mOnlineAudienceComponentSniperEventBinder;

    public View.OnClickListener getExitOnClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                MLog.info((Object)OnlineAudienceComponent.TAG, (String)"click exit live room button", (Object[])new Object[0]);
                OnlineAudienceComponent.this.onPreLeaveChannel(false);
            }
        };
    }

    public static OnlineAudienceComponent newInstance() {
        Bundle bundle = new Bundle();
        OnlineAudienceComponent component = new OnlineAudienceComponent();
        component.setArguments(bundle);
        return component;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.enableShowMicDot = this.getArguments().getBoolean(SHOW_MIC_DOT, true);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ((LiveRoomOnlineViewerLoadSampling)StatisticService.instance().get(LiveRoomOnlineViewerLoadSampling.class)).begin();
        PerfSDK.instance().start(50021, "liveroom_online_viewer_load_timecost");
        this.mRootView = inflater.inflate(R.layout.fragment_live_online_audience, container, false);
        this.mGameTempFunctionView = (YYLinearLayout)this.mRootView.findViewById(R.id.game_temp_function);
        this.mAudienceListView = (ViewGroup)this.mRootView.findViewById(R.id.audience_list_layout);
        this.mMicImg = (ImageView)this.mRootView.findViewById(R.id.audience_icon_more);
        this.mMicDotImg = (ImageView)this.mRootView.findViewById(R.id.audience_mic_onlice_dot);
        this.mExitViewPortrait = this.mRootView.findViewById(R.id.btn_exit_portrait);
        this.mExitViewPortrait.setOnClickListener(this.mExitOnClickListener);
        this.mMicImg.setOnClickListener(this.mOnlineMicOnClickListener);
        if (this.enableShowMicDot) {
            if (ICoreManagerBase.getChannelLinkCore().isOpenMic()) {
                if (this.isLogined() && this.mMicDotImg != null) {
                    this.mMicDotImg.setVisibility(0);
                }
            } else if (this.isLogined() && this.mMicDotImg != null) {
                this.mMicDotImg.setVisibility(8);
            }
        }
        this.mGameCodeRateLineTxt = (TextView)this.mRootView.findViewById(R.id.game_coderate_view);
        this.mRootView.findViewById(R.id.btn_game_share_land).setOnClickListener((View.OnClickListener)this);
        this.mGameCodeRateLineTxt.setOnClickListener((View.OnClickListener)this);
        AudienceVideoQualityManager.getInstance().addVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        AudienceVideoQuality quality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        this.resetCodeGameTplCodeRate(quality);
        this.mRootView.findViewById(R.id.game_replay_view).setOnClickListener((View.OnClickListener)this);
        return this.mRootView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        if (this.mOnlineAudienceComponentSniperEventBinder == null) {
            this.mOnlineAudienceComponentSniperEventBinder = new OnlineAudienceComponent$$EventBinder();
        }
        this.mOnlineAudienceComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.mLeaveChannelHelper = new LeaveChannelHelper();
        this.mLeaveChannelHelper.onInit();
    }

    public void onStart() {
        super.onStart();
        this.showProgramInfoComponent();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (ActivityUtilKt.getConfigurationsOrientation((Activity)this.getActivity()) == 2) {
            if (ICoreManagerBase.getChannelLinkCore().isGameTeplate()) {
                this.mExitViewPortrait.setVisibility(8);
                this.mGameTempFunctionView.setVisibility(0);
            }
        } else if (ActivityUtilKt.getConfigurationsOrientation((Activity)this.getActivity()) == 1 && ICoreManagerBase.getChannelLinkCore().isGameTeplate()) {
            this.mExitViewPortrait.setVisibility(0);
            this.mGameTempFunctionView.setVisibility(8);
        }
    }

    private void showProgramInfoComponent() {
        if (ICoreManagerBase.getChannelLinkCore() != null && ICoreManagerBase.getChannelLinkCore().getChannelState() == ChannelState.In_Channel && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo() != null && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid > 0L) {
            View view;
            OfficialInfo chanelinfo = ((IChannelOfficialInfoCore)ICoreManagerBase.getCore(IChannelOfficialInfoCore.class)).getOfficialProgramInfo(ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid);
            if (chanelinfo != null && !((ILianMaiCoreEXT)ICoreManagerBase.getCore(ILianMaiCore.class)).getIsLocalAcceptLianMaiInvite()) {
                View view2;
                if (this.mRootView != null && (view2 = (View)this.mRootView.getParent()) != null) {
                    RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, DimenConverter.dip2px((Context)this.getActivity(), (float)38.0f));
                    layoutParams.setMargins(DimenConverter.dip2px((Context)this.getActivity(), (float)0.0f), DimenConverter.dip2px((Context)this.getActivity(), (float)12.0f), 0, 0);
                    layoutParams.addRule(1, R.id.basic_live_official_program_component);
                    view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            } else if (this.mRootView != null && (view = (View)this.mRootView.getParent()) != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, DimenConverter.dip2px((Context)this.getActivity(), (float)38.0f));
                layoutParams.setMargins(0, 0, 0, 0);
                layoutParams.addRule(1, R.id.basic_live_program_component);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    public void showMicAudienceListFragment(IComponentRoot root, FragmentManager fragmentManager) {
        if (root != null && root.getComponentBehavior(IMicAndOnlineBehavior.class) != null) {
            MicOnlineViewPagerComponent component = MicOnlineViewPagerComponent.newInstance();
            component.setTemplate(root);
            if (component != null && !component.isAdded()) {
                ((IMicAudienceCore)ICoreManagerBase.getCore(IMicAudienceCore.class)).showMicAudienceListFragment();
                try {
                    component.show(fragmentManager, ((Object)((Object)component)).getClass().getSimpleName());
                }
                catch (IllegalStateException e) {
                    MLog.error((Object)TAG, (String)"showMicAudienceListFragment IllegalStateException ", (Throwable)e, (Object[])new Object[0]);
                }
                catch (Throwable e) {
                    MLog.error((Object)TAG, (String)"showMicAudienceListFragment Exception ", (Throwable)e, (Object[])new Object[0]);
                }
                ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic_Channel(LoginUtil.getUid(), "51001", "0019");
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onPreLeaveChannel(IMicAudienceClient_onPreLeaveChannel_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)("onPreLeaveChannel called with: busEventArgs = [" + busEventArgs + "]"), (Object[])new Object[0]);
        boolean param = busEventArgs.mParam;
        this.onPreLeaveChannel(param);
    }

    public void onPreLeaveChannel(boolean param) {
        if (!CommonPref.instance().getBoolean("shared_pref_name_swipe_tip", false) && ActivityUtilKt.isPortrait((Activity)this.getActivity())) {
            RxBus.getDefault().post((Object)new IBasicFunctionClient_onSwipeSwitchTipNotify_EventArgs());
            return;
        }
        this.mLeaveChannelHelper.onLeaveChannel(this.getActivity());
    }

    private void onLeaveChannel() {
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).setLiveRoomBrightnessCache(-1);
        ICoreManagerBase.getChannelLinkCore().leaveChannel();
        if (this.checkActivityValid()) {
            this.getActivity().finish();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (this.mRootView != null) {
            this.onOrientationChanged(ActivityUtilKt.getConfigurationsOrientation((Activity)this.getActivity()) == 2);
            if (ICoreManagerBase.getCore(IMicAudienceCore.class) != null) {
                ((IMicAudienceCore)ICoreManagerBase.getCore(IMicAudienceCore.class)).setOnlineAudienceCreateSuccessed(true);
            }
            PluginBus.INSTANCE.get().post((Object)new IMicAudienceClient_onOnlineAudienceSuccessedNotify_EventArgs());
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.mExitViewPortrait.setVisibility(0);
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mAudienceListView != null) {
            this.mAudienceListView.removeAllViews();
            this.mAudienceListView = null;
        }
        if (this.mExitViewPortrait != null) {
            this.mExitViewPortrait.setOnClickListener(null);
        }
        this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
        this.hideTipsPopWindow();
        this.tipsPopupWindow = null;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (null != this.mLeaveChannelHelper) {
            this.mLeaveChannelHelper.onUnInit();
        }
        AudienceVideoQualityManager.getInstance().removeVideoQualityChangeListener((IAudienceVideoQualityChangeListener)this);
        Object var2_1 = null;
        if (this.mOnlineAudienceComponentSniperEventBinder != null) {
            this.mOnlineAudienceComponentSniperEventBinder.unBindEvent();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void addAudienceListView(IMicAudienceClient_addAudienceListView_EventArgs busEventArgs) {
        View view = busEventArgs.mView;
        ((LiveRoomOnlineViewerLoadSampling)StatisticService.instance().get(LiveRoomOnlineViewerLoadSampling.class)).end();
        PerfSDK.instance().end(50021, "liveroom_online_viewer_load_timecost");
        if (view != null && this.mAudienceListView != null) {
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            this.mAudienceListView.removeAllViews();
            this.mAudienceListView.addView(view);
            this.mAudienceListView.setVisibility(0);
            this.mAudienceListView.setClipChildren(false);
            MLog.info((Object)"NobleSeatController", (String)"addAudienceListView success !", (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void channelMicStateisOpen(IChannelMicStateClient_channelMicStateisOpen_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getInfo();
        if (this.enableShowMicDot && this.isLogined() && this.mMicDotImg != null && info.channelMode != ChannelInfo.ChannelMode.Free_Mode && info.channelMode != ChannelInfo.ChannelMode.ADMIN_Mode) {
            this.mMicDotImg.setVisibility(0);
        }
    }

    @BusEvent
    public void channelMicStateisColse(IChannelMicStateClient_channelMicStateisColse_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getChannelInfo();
        if (this.enableShowMicDot && this.isLogined() && this.mMicDotImg != null && info.channelMode != ChannelInfo.ChannelMode.Free_Mode && info.channelMode != ChannelInfo.ChannelMode.ADMIN_Mode) {
            this.mMicDotImg.setVisibility(8);
        }
    }

    @BusEvent
    public void updateCurrentChannelInfo(IChannelLinkClient_updateCurrentChannelInfo_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getChannelInfo();
        if (this.enableShowMicDot && info != null && (info.channelMode == ChannelInfo.ChannelMode.Free_Mode || info.channelMode == ChannelInfo.ChannelMode.ADMIN_Mode) && this.mMicDotImg != null) {
            this.mMicDotImg.setVisibility(8);
        }
        this.showProgramInfoComponent();
    }

    @BusEvent
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        if (chatInputSwitch) {
            this.hideSelf();
        } else {
            this.showSelf();
        }
    }

    @BusEvent
    public void notifyAnchorImMediateOPlayer(IMicClient_notifyAnchorImMediateOPlayer_EventArgs busEventArgs) {
        String msg = busEventArgs.getMsg();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("notifyAnchorImMediateOPlayer msg =" + msg), (Object[])new Object[0]);
        }
        if (!TextUtils.isEmpty((CharSequence)msg) && this.checkActivityValid() && this.isResumed()) {
            this.showTipsPopWindow(msg);
        }
    }

    private void showTipsPopWindow(String tips) {
        if (this.mMicImg == null || !this.checkActivityValid()) {
            return;
        }
        if (this.tipsPopupWindow != null && this.tipsPopupWindow.isShowing()) {
            this.tipsPopupWindow.dismiss();
            this.tipsPopupWindow = null;
        }
        if (this.getActivity() == null) {
            return;
        }
        this.getHandler().removeCallbacks(this.hideTipsPopWindowRunnable);
        this.tipsPopupWindow = new TipsPopupWindow((Context)this.getActivity(), tips);
        this.tipsPopupWindow.setText(tips);
        this.tipsPopupWindow.showAsDropDown((View)this.mMicImg);
        this.getHandler().postDelayed(this.hideTipsPopWindowRunnable, 3000L);
    }

    private void hideTipsPopWindow() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.tipsPopupWindow != null) {
            if (this.tipsPopupWindow.isShowing()) {
                this.tipsPopupWindow.dismiss();
            }
            this.tipsPopupWindow = null;
        }
    }

    public void setExitOnClickListener(View.OnClickListener exitOnClickListener) {
        if (this.mExitViewPortrait != null) {
            this.mExitViewPortrait.setOnClickListener(exitOnClickListener);
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.btn_game_share_land) {
            RxBus.getDefault().post((Object)new IBasicFunctionClient_onRequestLiveShare_EventArgs());
        } else if (i == R.id.game_coderate_view || i == R.id.game_replay_view) {
            // empty if block
        }
    }

    private void resetCodeGameTplCodeRate(AudienceVideoQuality videoQuality) {
        if (this.mGameCodeRateLineTxt == null) {
            return;
        }
        if (videoQuality == null) {
            MLog.warn((Object)TAG, (String)"resetCodeGameTplCodeRate: videoquality is null, do nothing", (Object[])new Object[0]);
            this.mGameCodeRateLineTxt.setText((CharSequence)"");
            return;
        }
        this.mGameCodeRateLineTxt.setText((CharSequence)videoQuality.getName());
    }

    public void onUpdateAvaliableVideoQualities(List<AudienceVideoQuality> videoQualities) {
        MLog.info((Object)TAG, (String)"[onUpdateAvaliableVideoQualities]", (Object[])new Object[0]);
        AudienceVideoQuality quality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        this.resetCodeGameTplCodeRate(quality);
    }

    public void onUpdateStreamLineInfo(Map<Integer, List<AudienceVideoQuality>> lineQuality) {
        MLog.info((Object)TAG, (String)("[onUpdateStreamLineInfo] lineQuality=" + lineQuality), (Object[])new Object[0]);
        AudienceVideoQuality quality = AudienceVideoQualityManager.getInstance().getSelectedVideoQuality();
        this.resetCodeGameTplCodeRate(quality);
    }

    public void onUpdateCurStreamLine(Integer curLine, AudienceVideoQuality curVideoQuality) {
        MLog.info((Object)TAG, (String)("[onUpdateStreamLineInfo] curLine=" + curLine + ", curVideoQuality=" + curVideoQuality), (Object[])new Object[0]);
        this.resetCodeGameTplCodeRate(curVideoQuality);
    }
}

