/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.weekstar;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IWeekStarClient_onMobStarActRsp_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.basic.ELBasicModule;
import com.yy.live.basic.module.management.ELModuleContext;
import com.yy.live.module.weekstar.WeekStarModule$$EventBinder;
import com.yy.live.module.weekstar.WeekStartCXJSlideActionEvent;
import com.yy.live.module.weekstar.message.WeekStarChuanYunJianMessage;
import com.yy.live.publicapi.PublicApiManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IBasicFunctionClient_onSlideFunctionComponentStateChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_applyTreasureDiaglog_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_showPublicChatMessage_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicfunction.ActionInfo;
import com.yy.mobile.ui.basicfunction.data.ActionCallBack;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.truelove.TreasureNewMainEntrance;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.weekstar.core.IWeekStarCore;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yy.mobile.ylink.bridge.coreapi.LoginApi;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.noble.EntIdentity;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.weekstartcard.IWeekStarCardCore;
import com.yymobile.core.weekstartcard.WeekStarCardEventArgs;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class WeekStarModule
extends ELBasicModule
implements EventCompat {
    private static final String TAG = "WeekStarModule";
    private static final String WEEKSTARCARD_URL = "https://web.yy.com/weekCard/index.html";
    private static final String actiontag = "chuanyunjian";
    private static final String TRULELOVE_TAG = "truelove_tag";
    private ActionInfo mChuanYunActionInfo;
    private ActionInfo mWeekStarActionInfo;
    private View chuanYunJianView;
    private View mWeekStartCardSlideView;
    private DialogLinkManager dialogLinkManager;
    private Dialog mDialog;
    private AlertDialog.Builder mBuilder;
    private int mHasWeekCardGift = 2;
    private boolean mIsSlideFunctionComponentShown;
    private Runnable mActionRunnable;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private EventBinder mWeekStarModuleSniperEventBinder;

    @Override
    public void init(ELModuleContext moduleContext, String extend) {
        super.init(moduleContext, extend);
        if (((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).getChannelState() == ChannelState.In_Channel) {
            this.initChuanYunJianEntrance();
            this.initWeekStartCardEntrance();
        }
        this.mCompositeDisposable.add(RxBus.getDefault().register(WeekStartCXJSlideActionEvent.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<WeekStartCXJSlideActionEvent>(){

            public void accept(@NonNull WeekStartCXJSlideActionEvent weekStartCXJSlideActionEvent) throws Exception {
                WeekStarModule.this.doChuanYunJianClick();
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"WeekStartCXJSlideActionEvent error")));
        MLog.debug((Object)TAG, (String)"onEntertaimentTemplateInit finished", (Object[])new Object[0]);
    }

    @Override
    public void onOrientationChanges(boolean isLandscape) {
    }

    @Override
    public void onDispose() {
        super.onDispose();
        this.mChuanYunActionInfo = null;
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).removeActionByTag(actiontag);
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).removeActionByTag("week_card_entry");
        if (this.mDialog != null && this.isDialogShowing()) {
            this.dismissDialog();
        }
        this.mCompositeDisposable.clear();
        this.resetWeekStarCard();
        MLog.debug((Object)TAG, (String)"onDispose", (Object[])new Object[0]);
    }

    private void resetWeekStarCard() {
        this.mHasWeekCardGift = 2;
        this.mIsSlideFunctionComponentShown = false;
        this.mWeekStartCardSlideView = null;
        this.mActionRunnable = null;
        this.mWeekStarActionInfo = null;
    }

    @BusEvent
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        MLog.debug((Object)TAG, (String)"onJoinChannelSuccess", (Object[])new Object[0]);
        this.initChuanYunJianEntrance();
        this.initWeekStartCardEntrance();
        ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).queryWeekCardGift();
    }

    @BusEvent(sync=true)
    public void onSlideFunctionComponentStateChanged(IBasicFunctionClient_onSlideFunctionComponentStateChanged_EventArgs busEventArgs) {
        boolean isShow = busEventArgs.getIsShow();
        MLog.debug((Object)TAG, (String)("onSlideFunctionComponentStateChanged isShow :" + isShow), (Object[])new Object[0]);
        this.mIsSlideFunctionComponentShown = isShow;
        this.hideMoreRedDot();
    }

    protected void initChuanYunJianEntrance() {
        if (this.mChuanYunActionInfo == null) {
            this.mChuanYunActionInfo = new ActionInfo();
            this.mChuanYunActionInfo.position = 1;
            this.mChuanYunActionInfo.index = 4;
            this.mChuanYunActionInfo.actionTag = actiontag;
            this.chuanYunJianView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_chuanyunjian_slide_menu_biz_item, null);
            this.chuanYunJianView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    WeekStarModule.this.doChuanYunJianClick();
                }
            });
            this.mChuanYunActionInfo.mActionViewCallBack = new ActionCallBack(){

                public View onSetView() {
                    return WeekStarModule.this.chuanYunJianView;
                }
            };
        }
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).setAction(this.mChuanYunActionInfo);
    }

    protected void doChuanYunJianClick() {
        if (CoreApiManager.getInstance().getApi(LoginApi.class) != null && ((LoginApi)CoreApiManager.getInstance().getApi(LoginApi.class)).isLogined()) {
            long uid = LoginUtil.getUid();
            long anchorid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
            long topCid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid;
            long subCid = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid;
            if (anchorid == 0L) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u4e3b\u64ad\u5f53\u524d\u4e0d\u5728\u9ea6\uff0c\u8bf7\u5728\u4e3b\u64ad\u4e0a\u9ea6\u540e\u5f00\u542f", (int)1).show();
                return;
            }
            ((IWeekStarCore)ICoreManagerBase.getCore(IWeekStarCore.class)).queryPMobStartActReq(uid, anchorid, topCid, subCid);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51001", "0061");
        } else if (CoreApiManager.getInstance().getApi(LoginApi.class) != null) {
            ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.mContext);
        }
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).hideSlideFunctionsComponent();
    }

    protected void initWeekStartCardEntrance() {
        if (null != this.mWeekStarActionInfo) {
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).setAction(this.mWeekStarActionInfo);
            return;
        }
        this.mWeekStarActionInfo = new ActionInfo();
        this.mWeekStartCardSlideView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_weekstar_card_slide_menu_biz_item, null);
        this.mCompositeDisposable.add(RxBus.getDefault().register(WeekStarCardEventArgs.class).observeOn(AndroidSchedulers.mainThread()).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(@NonNull Disposable disposable2) throws Exception {
                WeekStarModule.this.mActionRunnable = null;
            }
        }).subscribe((Consumer)new Consumer<WeekStarCardEventArgs>(){

            public void accept(@NonNull WeekStarCardEventArgs weekStarCardEventArgs) throws Exception {
                MLog.debug((Object)WeekStarModule.TAG, (String)("weekStarCardEventArgs :" + weekStarCardEventArgs.hasWeekCardGift()), (Object[])new Object[0]);
                final View redPointView = WeekStarModule.this.mWeekStartCardSlideView.findViewById(R.id.red_point);
                redPointView.setVisibility(8);
                WeekStarModule.this.mHasWeekCardGift = weekStarCardEventArgs.hasWeekCardGift();
                if (WeekStarModule.this.mHasWeekCardGift == 2) {
                    final boolean isFirstShwonRedPoint = ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).isFirstShownWeekCardRedPoint();
                    redPointView.setVisibility(isFirstShwonRedPoint ? 0 : 8);
                    boolean isFirstShownMoreRedPoint = ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).isFirstShownWeekCardMoreRedPoint();
                    if (isFirstShownMoreRedPoint) {
                        WeekStarModule.this.showMoreRedDot();
                    } else {
                        WeekStarModule.this.hideMoreRedDot();
                    }
                    WeekStarModule.this.mActionRunnable = new Runnable(){

                        @Override
                        public void run() {
                            WeekStarModule.this.hideMoreRedDot();
                            redPointView.setVisibility(8);
                            if (isFirstShwonRedPoint) {
                                ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).ensureFirstShownWeekCardRedPoint();
                            }
                        }
                    };
                } else {
                    WeekStarModule.this.mActionRunnable = new Runnable(){

                        @Override
                        public void run() {
                            WeekStarModule.this.hideMoreRedDot();
                            redPointView.setVisibility(8);
                        }
                    };
                    redPointView.setVisibility(WeekStarModule.this.mHasWeekCardGift == 1 ? 0 : 8);
                    if (WeekStarModule.this.mHasWeekCardGift == 1) {
                        WeekStarModule.this.showMoreRedDot();
                    } else {
                        WeekStarModule.this.hideMoreRedDot();
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"WeekStarCardEventArgs error")));
        this.mWeekStarActionInfo.position = 1;
        this.mWeekStarActionInfo.index = 8;
        this.mWeekStarActionInfo.actionTag = "week_card_entry";
        this.mWeekStarActionInfo.mActionViewCallBack = new ActionCallBack(){

            public View onSetView() {
                MLog.debug((Object)WeekStarModule.TAG, (String)"onSetView", (Object[])new Object[0]);
                if (null != WeekStarModule.this.mWeekStartCardSlideView) {
                    WeekStarModule.this.mWeekStartCardSlideView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (null != WeekStarModule.this.mActionRunnable) {
                                WeekStarModule.this.mActionRunnable.run();
                            }
                            if (CoreApiManager.getInstance().getApi(LoginApi.class) != null && ((LoginApi)CoreApiManager.getInstance().getApi(LoginApi.class)).isLogined()) {
                                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)WeekStarModule.this.mContext, WeekStarModule.WEEKSTARCARD_URL);
                            } else if (CoreApiManager.getInstance().getApi(LoginApi.class) != null) {
                                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)WeekStarModule.this.mContext);
                            }
                            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).hideSlideFunctionsComponent();
                        }
                    });
                }
                return WeekStarModule.this.mWeekStartCardSlideView;
            }
        };
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).setAction(this.mWeekStarActionInfo);
        ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).queryWeekCardGift();
    }

    private void showMoreRedDot() {
        if (!this.mIsSlideFunctionComponentShown) {
            ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).addSlideMenuRedDot("WEEKSTARCARD_REDDOT");
        }
    }

    private void hideMoreRedDot() {
        ((IWeekStarCardCore)CoreFactory.getCore(IWeekStarCardCore.class)).ensureFirstShownWeekCardMoreRedPoint();
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).removeSlideMenuRedDot("WEEKSTARCARD_REDDOT");
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive")
    public void onMobStarActRsp(IWeekStarClient_onMobStarActRsp_EventArgs busEventArgs) {
        int result = busEventArgs.mResult;
        MLog.debug((Object)TAG, (String)("[onMobStarActRsp] result =" + result), (Object[])new Object[0]);
        if (result == 1) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u60a8\u5df2\u7ecf\u5f00\u542f\u4e86\u7a7f\u4e91\u7bad\u6d3b\u52a8\uff0c\u8bf7\u52ff\u91cd\u590d\u5f00\u542f\uff01", (int)1).show();
        } else if (result == 2) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u5f00\u542f\u7a7f\u4e91\u7bad\u6d3b\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (int)1).show();
        }
    }

    @BusEvent
    public void applyTreasureDiaglog(IWebViewClient_applyTreasureDiaglog_EventArgs busEventArgs) {
        this.applyTreasureDiaglog();
    }

    public void applyTreasureDiaglog() {
        this.showOkDisDialog("\u52a0\u5165\u4e3b\u64ad\u73cd\u7231\u56e2\u540e\u624d\u53ef\u4ee5\u53c2\u4e0e\u672c\u6d3b\u52a8\uff0c\u662f\u5426\u73b0\u5728\u5f00\u901a\uff1f", "\u5f00\u901a", false, false, new DialogLinkManager.OkExitDialogListener(){

            public void onExit() {
            }

            public void onOk() {
                WeekStarModule.this.showDifferentTreasureCard();
            }

            public void onCancel() {
            }

            public void onMessageClick() {
            }
        });
    }

    private void showDifferentTreasureCard() {
        if (this.mComponent == null || !this.checkActivityValid()) {
            return;
        }
        FragmentManager fragmentManager = this.mComponent.getChildFragmentManager();
        TreasureNewMainEntrance treasureNewMainEntrance = (TreasureNewMainEntrance)fragmentManager.findFragmentByTag(TRULELOVE_TAG);
        if (treasureNewMainEntrance == null) {
            treasureNewMainEntrance = new TreasureNewMainEntrance();
            String url = EntIdentity.appendTreasureUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.ture_love_new_web, (long)PublicApiManager.getToUid(), (long)ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid, (long)ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("[showDifferentTreasureCard] url::" + url), (Object[])new Object[0]);
            }
            Bundle bundle = new Bundle();
            bundle.putString("url", url);
            treasureNewMainEntrance.setArguments(bundle);
        }
        if (!treasureNewMainEntrance.isAdded()) {
            treasureNewMainEntrance.show(fragmentManager, TRULELOVE_TAG);
        }
    }

    private void showOkDisDialog(CharSequence message, CharSequence okLabel, boolean outsideCancelable, boolean backCancelable, final DialogLinkManager.OkExitDialogListener listener2) {
        if (!this.checkActivityValid()) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"showOkDisDialog ActivityInvalid....", (Object[])new Object[0]);
            }
            return;
        }
        if (this.mBuilder == null) {
            this.mBuilder = new AlertDialog.Builder(this.getContext());
        }
        if (this.mDialog == null) {
            this.mDialog = this.mBuilder.create();
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog.setCancelable(backCancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.common_apply_dialog);
        TextView messageTv = (TextView)window.findViewById(R.id.message_content_apply_common);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            messageTv.setText(message);
        }
        messageTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener2 != null) {
                    listener2.onMessageClick();
                }
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok_apply_common);
        if (!TextUtils.isEmpty((CharSequence)okLabel)) {
            ok.setText(okLabel);
        }
        if (okLabel.length() > 4) {
            if (this.mContext != null) {
                if (this.mContext.getResources().getDisplayMetrics().widthPixels <= 480) {
                    ok.setTextSize(2, 14.0f);
                } else {
                    ok.setTextSize(2, 16.0f);
                }
            } else {
                ok.setTextSize(2, 16.0f);
            }
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener2 != null) {
                    WeekStarModule.this.mDialog.dismiss();
                    listener2.onOk();
                }
            }
        });
        window.findViewById(R.id.exit_dismiss_apply_common).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener2 != null) {
                    WeekStarModule.this.mDialog.dismiss();
                    listener2.onExit();
                }
            }
        });
    }

    private boolean isDialogShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    private void dismissDialog() {
        if (this.mContext != null && this.mDialog != null && this.mDialog.getWindow() != null) {
            this.mDialog.dismiss();
        }
    }

    @BusEvent
    public void showPublicChatMessage(IWebViewClient_showPublicChatMessage_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        String nick = busEventArgs.getNick();
        String content = busEventArgs.getContent();
        this.weekStarMessage(uid, nick, content);
    }

    private void weekStarMessage(long uid, String nick, String content) {
        WeekStarChuanYunJianMessage message = new WeekStarChuanYunJianMessage();
        message.channelMessageType = ChannelMessage.ChannelMsgType.NOTICE_MESSAGE_TYPE;
        message.uid = uid;
        message.text = nick + content;
        SpannableStringBuilder spannable = new SpannableStringBuilder((CharSequence)message.text);
        spannable.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffda81")), 0, message.text.length(), 33);
        message.spannable = spannable;
        ICoreManagerBase.getChannelLinkCore().appendChannelMsg((ChannelMessage)message);
    }

    @Override
    public void onModuleGone() {
        super.onModuleGone();
        if (this.chuanYunJianView != null) {
            this.chuanYunJianView.setVisibility(8);
        }
        if (this.mWeekStartCardSlideView != null) {
            this.mWeekStartCardSlideView.setVisibility(8);
        }
    }

    @Override
    public void onModuleVisible() {
        super.onModuleVisible();
        if (this.chuanYunJianView != null) {
            this.chuanYunJianView.setVisibility(0);
        }
        if (this.mWeekStartCardSlideView != null) {
            this.mWeekStartCardSlideView.setVisibility(0);
        }
    }

    @Override
    public void onModuleInvisible() {
        super.onModuleInvisible();
        if (this.chuanYunJianView != null) {
            this.chuanYunJianView.setVisibility(4);
        }
        if (this.mWeekStartCardSlideView != null) {
            this.mWeekStartCardSlideView.setVisibility(4);
        }
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mWeekStarModuleSniperEventBinder == null) {
            this.mWeekStarModuleSniperEventBinder = new WeekStarModule$$EventBinder();
        }
        this.mWeekStarModuleSniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mWeekStarModuleSniperEventBinder != null) {
            this.mWeekStarModuleSniperEventBinder.unBindEvent();
        }
    }
}

