/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.demoanchor;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.support.v4.app.ActivityCompat;
import android.view.View;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PermissionUtils {
    private static Set<String> requestedPermissions = new HashSet<String>();
    private static Set<String> rationaledPermissions = new HashSet<String>();

    public static void askForPermissions(final Activity activity, RationaleDialog dialog, final String[] permissions) {
        String[] missingPermissions = PermissionUtils.checkMissingPermissions((Context)activity, permissions);
        ArrayList<String> freshOnes = new ArrayList<String>();
        ArrayList<String> rationaleOnes = new ArrayList<String>();
        for (String p : missingPermissions) {
            if (!requestedPermissions.contains(p)) {
                freshOnes.add(p);
            }
            if (rationaledPermissions.contains(p) || !ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)p)) continue;
            rationaleOnes.add(p);
        }
        if (dialog != null && rationaleOnes.size() > 0) {
            String rationaleNames = "";
            for (String p : rationaleOnes) {
                rationaleNames = rationaleNames + PermissionUtils.getPermissionLabel(p, activity.getPackageManager()) + "\n";
            }
            rationaledPermissions.addAll(rationaleOnes);
            dialog.show("\u9700\u8981\u4e0b\u8ff0\u6743\u9650", rationaleNames, "\u786e\u5b9a", new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionUtils.askForPermissions(activity, null, permissions);
                }
            });
        } else if (freshOnes.size() > 0) {
            requestedPermissions.addAll(freshOnes);
            ActivityCompat.requestPermissions((Activity)activity, (String[])freshOnes.toArray(new String[0]), (int)0);
        }
    }

    public static String[] checkMissingPermissions(Context context, String[] neededPermissions) {
        ArrayList<String> missingPermissions = new ArrayList<String>();
        for (String permission : neededPermissions) {
            if (PermissionUtils.hasPermission(context, permission)) continue;
            missingPermissions.add(permission);
        }
        return missingPermissions.toArray(new String[0]);
    }

    public static boolean hasPermission(Context context, String permission) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    private static String getPermissionLabel(String permission, PackageManager packageManager) {
        try {
            PermissionInfo permissionInfo = packageManager.getPermissionInfo(permission, 0);
            return permissionInfo.loadLabel(packageManager).toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static interface RationaleDialog {
        public void show(String var1, String var2, String var3, View.OnClickListener var4);
    }
}

