/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.demoanchor;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import com.yy.mobile.YYHandler;
import com.yy.mobile.YYHandlerMgr;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.log.YLKLog;
import com.yyproto.base.ISessWatcher;
import com.yyproto.outlet.IProtoMgr;
import com.yyproto.outlet.ISession;
import com.yyproto.outlet.SessEvent;

public class LiveSessionManager {
    private static final String TAG = "LiveSessionManager";
    private Runnable timeoutTask;
    private final YYHandlerMgr handlerMgr = YYHandlerMgr.instance();
    private YYHandler sessionMessageMonitor;
    private YYHandler onKickMonitor;
    private final ISession session = IProtoMgr.instance().getSess();
    private final Callback callback;
    private long topCid;
    private long subCid;
    private int flowId = 1;
    private final Handler timeoutHandler = new Handler(Looper.getMainLooper());
    private static final String[] sessionFailures = new String[]{"\u9891\u9053\u5185\u7528\u6237\u88ab\u8e22\u51fa\u9891\u9053\u4e86(0)", "\u6b64\u7528\u6237\u88ab\u7981\u6b62\u8fdb\u5165\u6b64\u9891\u9053(1)", "\u6b64\u7528\u6237\u6240\u5c5eIP\u88ab\u7981\u6b62\u8fdb\u5165\u6b64\u9891\u9053(2)", "\u6b64\u7528\u6237\u6240\u5c5e\u8bbe\u5907\u88ab\u7981\u6b62\u8fdb\u5165\u6b64\u9891\u9053(3)", "\u672a\u77e5(4)", "\u7981\u6b62\u975e\u6b22\u805a\u516c\u53f8\u7528\u6237\u8fdb\u5165\u516c\u53f8\u9891\u9053(5)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25\uff0c \u76ee\u6807\u9891\u9053\u9700\u8981\u5bc6\u7801(6)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25\uff0c \u591a\u7aef\u540c\u65f6\u5728\u9891\u9053\u4e92\u8e22(7)", "\u672a\u77e5(8)", "\u672a\u77e5(9)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u9891\u9053\u4eba\u6570\u8fbe\u5230\u4e0a\u9650(10)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u8fdb\u9891\u9053\u62e5\u585e, \u540c\u65f6\u8fdb\u9891\u9053\u4eba\u6570\u592a\u591a(11)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u9891\u9053\u4e0d\u5b58\u5728(12)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u88ab\u51bb\u7ed3(13)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u88ab\u9501\u4e86(14)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u77ed\u53f7\u88ab\u56de\u6536(15)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u88ab\u9501\u4e86(16)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u5b50\u9891\u9053\u4eba\u6570\u6ee1\u4e86(17)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u5b50\u9891\u9053\u6743\u9650\u4e0d\u6ee1\u8db3(18)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u4e0d\u5141\u8bb8\u6e38\u5ba2\u8fdb\u5165(19)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u6743\u9650\u8981\u6c42VIP\u7528\u6237(20)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u6536\u8d39\uff0c \u7528\u6237\u4e0d\u6ee1\u8db3\u8981\u6c42(21)", "\u9891\u9053\u4e1a\u52a1\u5931\u8d25, \u76ee\u6807\u9891\u9053\u8981\u6c42\u7279\u5b9a\u7684app\u624d\u80fd\u8fdb\u5165\uff0c \u7528\u6237\u4e0d\u6ee1\u8db3\u6761\u4ef6(22)", "AppToken\u9a8c\u8bc1\u5931\u8d25(23)", "\u672a\u77e5\uff0824\uff09", "\u672a\u77e5\uff0825\uff09", "\u65b0\u4e34\u65f6\u9891\u905330.8-30.9\u4ebf\uff0c\u53ea\u5bb9\u8bb8OW\u8fdb\u5165(26)"};
    private YLKLive.State state = YLKLive.State.Idle;

    public LiveSessionManager(Callback callback2) {
        this.callback = callback2;
    }

    public void joinChannel(long topCid, long subCid, byte[] kickContext) {
        this.topCid = topCid;
        this.subCid = subCid;
        SparseArray props = null;
        if (kickContext != null) {
            props = new SparseArray();
            props.put(1, (Object)kickContext);
            props.put(2, (Object)"1".getBytes());
        }
        this.state = YLKLive.State.Pending;
        this.session.join(topCid, subCid, props, "app_join".getBytes());
        this.addSessionMessagesMonitorIfNeeded();
        ++this.flowId;
        final int thisFlowId = this.flowId;
        this.timeoutTask = new Runnable(){

            @Override
            public void run() {
                if (LiveSessionManager.this.state == YLKLive.State.Pending && LiveSessionManager.this.flowId == thisFlowId) {
                    LiveSessionManager.this.handleJoiningTimeout();
                }
            }
        };
        this.timeoutHandler.postDelayed(this.timeoutTask, 10000L);
    }

    public void leave() {
        this.removeOnKickMonitor();
        this.removeSessionMessagesMonitor();
        this.session.leave();
        this.state = YLKLive.State.Idle;
    }

    private void handleJoiningTimeout() {
        this.callback.onJoinChannelFailure(13, "\u76f4\u64ad\u95f4\u5904\u7406\u8d85\u65f6");
    }

    private void addSessionMessagesMonitorIfNeeded() {
        if (this.sessionMessageMonitor != null) {
            Log.e((String)"sessMgr", (String)"session watch error");
            return;
        }
        this.sessionMessageMonitor = new YYHandler(Looper.getMainLooper()){

            @YYHandler.MessageHandler(message=20017)
            public void onChannelAlreadyJoinedByOtherClient(SessEvent.ETSessMultiKick et) {
                LiveSessionManager.this.state = YLKLive.State.Idle;
                LiveSessionManager.this.joinChannel(LiveSessionManager.this.topCid, LiveSessionManager.this.subCid, et.mKickContext);
            }

            @YYHandler.MessageHandler(message=20001)
            public void onJoin(SessEvent.ETSessJoinRes et) {
                if (et.mSuccess && et.mErrId == 200) {
                    LiveSessionManager.this.timeoutHandler.removeCallbacks(LiveSessionManager.this.timeoutTask);
                    LiveSessionManager.this.setupOnKickMonitor();
                    LiveSessionManager.this.callback.onJoinChannelSuccess(et.mRootSid, et.mSubSid);
                    LiveSessionManager.this.state = YLKLive.State.Joined;
                    YLKLog.i((String)LiveSessionManager.TAG, (String)"addSessionMessagesMonitorIfNeeded onJoin mSuccess:");
                } else {
                    String reason = "\u672a\u77e5\u9519\u8bef(" + et.mErrId + ")";
                    if (et.mErrId < sessionFailures.length) {
                        reason = sessionFailures[et.mErrId];
                    }
                    LiveSessionManager.this.leave();
                    LiveSessionManager.this.callback.onJoinChannelFailure(1, reason);
                    LiveSessionManager.this.state = YLKLive.State.Idle;
                    YLKLog.i((String)LiveSessionManager.TAG, (String)"addSessionMessagesMonitorIfNeeded onJoin Failures:");
                }
            }
        };
        YLKLog.i((String)TAG, (String)("addSessionMessagesMonitorIfNeeded handlerMgr:" + this.handlerMgr.hashCode()));
        YLKLog.i((String)TAG, (String)("addSessionMessagesMonitorIfNeeded sessionMessageMonitor:" + this.sessionMessageMonitor.hashCode()));
        this.handlerMgr.add(this.sessionMessageMonitor);
        this.session.watch((ISessWatcher)this.handlerMgr);
    }

    private void removeSessionMessagesMonitor() {
        this.session.revoke((ISessWatcher)this.handlerMgr);
        this.handlerMgr.remove(this.sessionMessageMonitor);
        this.sessionMessageMonitor = null;
    }

    private void setupOnKickMonitor() {
        this.onKickMonitor = new YYHandler(Looper.getMainLooper()){

            @YYHandler.MessageHandler(message=20018)
            public void onNotifyBeingKickedOutFromChannel(SessEvent.ETSessMultiKickNtf et) {
                String reason = new String(et.mReason);
                YLKLog.w((String)LiveSessionManager.TAG, (String)("YLKLive#join onNotifyBeingKickedOutFromChannel --  topSid: " + et.getTopSid() + " toCh: " + et.mSid + " reason: " + reason));
                LiveSessionManager.this.leave();
                LiveSessionManager.this.callback.onKickOutFromChannel(12, "uid: " + et.mUid + "\nfromCid: " + et.mSid + "\ntoCid: " + et.mToCh + "\nreason: " + reason + "\n\u901a\u8fc7\u5176\u4ed6\u5ba2\u6237\u7aef\u8fdb\u5165\u9891\u9053");
            }
        };
        this.handlerMgr.add(this.onKickMonitor);
    }

    private void removeOnKickMonitor() {
        this.handlerMgr.remove(this.onKickMonitor);
        this.onKickMonitor = null;
    }

    public static interface Callback {
        public void onJoinChannelSuccess(long var1, long var3);

        public void onJoinChannelFailure(int var1, String var2);

        public void onKickOutFromChannel(int var1, String var2);
    }
}

