/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.preview;

import android.app.Activity;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.gyf.immersionbar.ImmersionBar;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.ANCHORHEYTAP;
import com.unionyy.mobile.spdt.annotation.ANCHORVIVO;
import com.yy.mobile.pluginstartlive.CameraViewModule;
import com.yy.mobile.pluginstartlive.R;
import com.yy.mobile.pluginstartlive.lianmai.core.ILianmaiCore;
import com.yy.mobile.pluginstartlive.lianmai.core.LianmaiVideoLayoutData;
import com.yy.mobile.pluginstartlive.preview.IVideoPreviewController;
import com.yy.mobile.pluginstartlive.preview.VideoPreviewLayout;
import com.yy.mobile.pluginstartlive.startlivecore.CoreUtilKt;
import com.yy.mobile.ui.basicfunction.ScreenSizeUtils;
import com.yy.mobile.ui.utils.ActivityCheckerUtils;
import com.yy.mobile.ui.utils.NavigationBarUtils;
import com.yy.mobile.util.log.MLog;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/yy/mobile/pluginstartlive/preview/VideoPreviewController;", "Lcom/yy/mobile/pluginstartlive/preview/IVideoPreviewController;", "videoPreviewLayout", "Lcom/yy/mobile/pluginstartlive/preview/VideoPreviewLayout;", "activity", "Landroid/support/v4/app/FragmentActivity;", "(Lcom/yy/mobile/pluginstartlive/preview/VideoPreviewLayout;Landroid/support/v4/app/FragmentActivity;)V", "getActivity", "()Landroid/support/v4/app/FragmentActivity;", "mStartPreviewOnResume", "", "getVideoPreviewLayout", "()Lcom/yy/mobile/pluginstartlive/preview/VideoPreviewLayout;", "changePreviewToNormalState", "", "changePreviewToPKState", "isCameraFront", "onCreate", "onDestroy", "onPause", "onResume", "onStop", "Companion", "pluginstartlive_release"})
public final class VideoPreviewController
implements IVideoPreviewController {
    private boolean mStartPreviewOnResume;
    @NotNull
    private final VideoPreviewLayout videoPreviewLayout;
    @NotNull
    private final FragmentActivity activity;
    @NotNull
    public static final String TAG = "VideoPreviewController";
    public static final Companion Companion = new Companion(null);

    @Override
    public void onCreate() {
    }

    @Override
    public void onResume() {
        MLog.info((Object)TAG, (String)("onResume, mStartPreviewOnResume:" + this.mStartPreviewOnResume), (Object[])new Object[0]);
        if (!this.videoPreviewLayout.isReleased() && this.mStartPreviewOnResume) {
            MLog.info((Object)TAG, (String)"onResume: startPreview", (Object[])new Object[0]);
            this.videoPreviewLayout.getCameraPreview().startPreview(true, this.isCameraFront());
        }
    }

    @Override
    public void onPause() {
        MLog.info((Object)TAG, (String)"onPause", (Object[])new Object[0]);
        this.mStartPreviewOnResume = false;
    }

    @Override
    public void onStop() {
        MLog.info((Object)TAG, (String)"onStop", (Object[])new Object[0]);
        this.mStartPreviewOnResume = true;
        if (!this.videoPreviewLayout.isReleased()) {
            MLog.info((Object)TAG, (String)"onStop: stopPreview", (Object[])new Object[0]);
            this.videoPreviewLayout.getCameraPreview().stopPreview();
        }
    }

    @Override
    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        if (!this.videoPreviewLayout.isReleased()) {
            MLog.info((Object)TAG, (String)"onDestroy: release videoPreviewLayout", (Object[])new Object[0]);
            this.videoPreviewLayout.release();
        }
    }

    @Override
    public void changePreviewToPKState() {
        FrameLayout.LayoutParams curLayoutParam;
        if (!ActivityCheckerUtils.isActivityValid((Activity)((Activity)this.activity)) || this.videoPreviewLayout.isReleased()) {
            MLog.error((Object)TAG, (String)"changePreviewToPKState: activity invalid or layout released", (Object[])new Object[0]);
            return;
        }
        boolean hasVirtualKey = NavigationBarUtils.checkDeviceHasNavigationBar((Context)((Context)this.activity));
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager windowManager = this.activity.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"activity.windowManager");
        windowManager.getDefaultDisplay().getMetrics(metrics);
        int width = metrics.widthPixels;
        MLog.info((Object)TAG, (String)"changeTransChannelLianMaiLayout : getDefaultDisplay hasVirtualKey=%s, width=%s", (Object[])new Object[]{hasVirtualKey, width});
        if (hasVirtualKey) {
            width = ScreenSizeUtils.getWindowHeightIncludeBars((Activity)((Activity)this.activity));
        }
        ILianmaiCore lianmaiCore = CoreUtilKt.getCore(ILianmaiCore.class);
        Object object = lianmaiCore;
        int videoHeight = (int)((float)width / (object != null && (object = object.getLianmaiScale((Activity)this.activity)) != null ? ((LianmaiVideoLayoutData)object).getScale() : 1.3333334f));
        int videoWidth = width / 2;
        ViewGroup.LayoutParams layoutParams = this.videoPreviewLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        FrameLayout.LayoutParams layoutParams2 = curLayoutParam = (FrameLayout.LayoutParams)layoutParams;
        VideoPreviewLayout videoPreviewLayout = this.videoPreviewLayout;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout.LayoutParams $this$apply = layoutParams2;
        boolean bl3 = false;
        $this$apply.height = videoHeight;
        $this$apply.width = videoWidth;
        Object object2 = lianmaiCore;
        int n = object2 != null && (object2 = object2.getLianmaiScale((Activity)this.activity)) != null ? ((LianmaiVideoLayoutData)object2).getMarginTop() : ($this$apply.topMargin = (int)this.activity.getResources().getDimension(R.dimen.lianmai_video_margin_top));
        if (Spdt.currentFlavor() instanceof ANCHORVIVO || Spdt.currentFlavor() instanceof ANCHORHEYTAP) {
            $this$apply.topMargin += ImmersionBar.getStatusBarHeight((Activity)((Activity)this.activity));
        }
        $this$apply.gravity = 51;
        FrameLayout.LayoutParams layoutParams3 = layoutParams2;
        videoPreviewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
    }

    @Override
    public void changePreviewToNormalState() {
        FrameLayout.LayoutParams curLayoutParam;
        if (!ActivityCheckerUtils.isActivityValid((Activity)((Activity)this.activity)) || this.videoPreviewLayout.isReleased()) {
            MLog.error((Object)TAG, (String)"changePreviewToNormalState: activity invalid or layout released", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"changePreviewToNormalState", (Object[])new Object[0]);
        int videoHeight = -1;
        int videoMarginTop = 0;
        int videoWidth = -1;
        ViewGroup.LayoutParams layoutParams = this.videoPreviewLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        FrameLayout.LayoutParams layoutParams2 = curLayoutParam = (FrameLayout.LayoutParams)layoutParams;
        VideoPreviewLayout videoPreviewLayout = this.videoPreviewLayout;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout.LayoutParams $this$apply = layoutParams2;
        boolean bl3 = false;
        $this$apply.height = videoHeight;
        $this$apply.width = videoWidth;
        $this$apply.topMargin = videoMarginTop;
        FrameLayout.LayoutParams layoutParams3 = layoutParams2;
        videoPreviewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
    }

    private final boolean isCameraFront() {
        Boolean bl = (Boolean)((CameraViewModule)ViewModelProviders.of((FragmentActivity)this.activity).get(CameraViewModule.class)).getCameraFront().getValue();
        return bl != null ? bl : true;
    }

    @NotNull
    public final VideoPreviewLayout getVideoPreviewLayout() {
        return this.videoPreviewLayout;
    }

    @NotNull
    public final FragmentActivity getActivity() {
        return this.activity;
    }

    public VideoPreviewController(@NotNull VideoPreviewLayout videoPreviewLayout, @NotNull FragmentActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)videoPreviewLayout, (String)"videoPreviewLayout");
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.videoPreviewLayout = videoPreviewLayout;
        this.activity = activity;
        this.mStartPreviewOnResume = true;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/mobile/pluginstartlive/preview/VideoPreviewController$Companion;", "", "()V", "TAG", "", "pluginstartlive_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

