/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.startlivecore.yyimpl;

import android.os.Build;
import android.os.SystemClock;
import android.util.SparseArray;
import com.google.gson.Gson;
import com.yy.mobile.pluginstartlive.demoanchor.StaticInfo;
import com.yy.mobile.pluginstartlive.demoanchor.SystemLocation;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.services.Service;
import com.yy.yylivekit.services.core.MarshalContainer;
import com.yy.yylivekit.services.core.Pack;
import com.yy.yylivekit.services.core.Uint32;
import com.yy.yylivekit.services.core.UnmarshalContainer;
import com.yy.yylivekit.services.core.Unpack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpPrepareLive
implements Service.Operation {
    private String title = "";
    private final Channel channel;
    private final SystemLocation.LocationInfo location;
    private final int videoLevel;
    private final Completion completion;

    public OpPrepareLive(int videoLevel, Channel channel, SystemLocation.LocationInfo location, Completion completion) {
        this.videoLevel = videoLevel;
        this.channel = channel;
        this.location = location;
        this.completion = completion;
    }

    public int serviceType() {
        return StaticInfo.INSTANCE.getAppid();
    }

    public int serviceNumber() {
        return 9000;
    }

    public int jobNumber() {
        return 1;
    }

    public Channel channel() {
        return this.channel;
    }

    public Service.Operation.PackType type() {
        return Service.Operation.PackType.Normal;
    }

    public void packRequest(Pack pack) {
        pack.push(this.title).push(this.location.address);
        MarshalContainer.marshalMapStringString((Pack)pack, this.requestFields());
    }

    private Map<String, String> requestFields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        this.prepareOSInfoFields(fields);
        this.prepareTimestampField(fields);
        this.prepareChannelFields(fields);
        this.prepareAccountChannelsField(fields);
        this.prepareAnchorExtras(fields);
        this.prepareLocationFields(fields);
        fields.put("mobileLiveReplay", "true");
        fields.put("ow", "1");
        fields.put("videoQuality", this.videoQualityString());
        fields.put("continue_flag", "0");
        fields.put("enable_location", "0");
        return fields;
    }

    private String videoQualityString() {
        return String.valueOf(this.videoLevel);
    }

    private void prepareOSInfoFields(Map<String, String> fields) {
        fields.put("imei", "");
        fields.put("mac", "");
        fields.put("osVersionExpired", "0");
    }

    private String ispString() {
        HashMap<String, String> ispMapping = new HashMap<String, String>(){
            {
                this.put("CMCC", "1");
                this.put("UNICOM", "2");
                this.put("CTL", "3");
            }
        };
        String mockISPString = "UNICOM";
        String isp = (String)ispMapping.get(mockISPString);
        return isp != null ? isp : "4";
    }

    private String networkTypeString() {
        boolean mockNetworkType = true;
        if (mockNetworkType) {
            return "2";
        }
        return "1";
    }

    private void prepareLocationFields(Map<String, String> fields) {
        fields.put("country", this.location.country);
        fields.put("province", this.location.province);
        fields.put("city", this.location.city);
        fields.put("department", this.location.district);
        if (this.location.errorCode == 666) {
            fields.put("longitude", String.valueOf(this.location.longitude));
            fields.put("latitude", String.valueOf(this.location.latitude));
        } else {
            fields.put("longitude", "");
            fields.put("latitude", "");
        }
        fields.put("LBSErrorCode", String.valueOf(this.location.errorCode));
        fields.put("LBSErrorMsg", String.valueOf(this.location.errorMsg));
    }

    private void prepareAnchorExtras(Map<String, String> fields) {
        HashMap<String, String> anchorExtra = new HashMap<String, String>(){
            {
                this.put("os", "android");
                this.put("manufacturer", Build.MANUFACTURER);
                this.put("model", Build.MODEL);
                this.put("osVersion", Build.VERSION.RELEASE);
                this.put("yyVersion", "7.23.1.9-vva-SNAPSHOT");
                this.put("ispType", OpPrepareLive.this.ispString());
                this.put("netType", OpPrepareLive.this.networkTypeString());
                this.put("channelId", "Internal_Demo");
                this.put("imei", "");
            }
        };
        fields.put("anchorExtra", new Gson().toJson((Object)anchorExtra));
    }

    private void prepareAccountChannelsField(Map<String, String> fields) {
        fields.put("loginType", "0");
    }

    private void prepareTimestampField(Map<String, String> fields) {
        fields.put("timestamp", String.valueOf(SystemClock.elapsedRealtime()));
    }

    private void prepareChannelFields(Map<String, String> fields) {
        if (this.channel != null) {
            fields.put("binding_ch", String.valueOf(this.channel.top));
        }
    }

    public void processResponse(int responseNumber, Unpack unpack) {
        int NormalResponse = 2;
        int ChannelResponse = 13;
        if (responseNumber == 2) {
            this.processPreparingResponse(unpack);
        } else {
            this.processChannelResponse(unpack);
        }
    }

    private void processPreparingResponse(Unpack unpack) {
        int code = unpack.popUint32().intValue();
        long cid = unpack.popUint32().longValue();
        HashMap fields = new HashMap();
        UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, fields);
        boolean Success = false;
        if (code != 0) {
            SparseArray<Object[]> failureMap = new SparseArray<Object[]>(){
                {
                    this.put(1, new Object[]{Failure.Unknown, "\u53d1\u751f\u4e86\u672a\u77e5\u9519\u8bef"});
                    this.put(2, new Object[]{Failure.PhoneNumberNotBounded, "\u8bf7\u5148\u7ed1\u5b9a\u624b\u673a\u53f7"});
                    this.put(3, new Object[]{Failure.LiveForbidden, "\u7981\u6b62\u5f00\u64ad"});
                    this.put(4, new Object[]{Failure.CouldNotAcquireLiveChannel, "\u5f00\u64ad\u9891\u9053\u5904\u7406\u5931\u8d25"});
                    this.put(5, new Object[]{Failure.VideoForbidden, "\u89c6\u9891\u5f00\u64ad\u88ab\u7981\u6b62"});
                    this.put(6, new Object[]{Failure.TitleForbidden, "\u6807\u9898\u5305\u542b\u8fdd\u89c4\u5185\u5bb9"});
                    this.put(7, new Object[]{Failure.AuditRequired, "\u5b9e\u540d\u8ba4\u8bc1\u540e\u624d\u53ef\u4ee5\u5f00\u64ad"});
                    this.put(8, new Object[]{Failure.Auditing, "\u5b9e\u540d\u8ba4\u8bc1\u5ba1\u6838\u4e2d"});
                    this.put(200, new Object[]{Failure.Unknown, "\u53d1\u751f\u4e86\u672a\u77e5\u9519\u8bef"});
                }
            };
            Object[] failureItem = (Object[])failureMap.get(code);
            if (failureItem == null) {
                failureItem = (Object[])failureMap.get(1);
            }
            Failure failure = (Failure)((Object)failureItem[0]);
            String message = (String)fields.get("message_anchor");
            if (message == null || message.isEmpty()) {
                message = (String)failureItem[1];
            }
            this.completion.didFailedPreparing(failure, message);
        } else {
            this.completion.didSucceedPreparing(new Channel(cid, cid));
        }
    }

    private void processChannelResponse(Unpack pack) {
        HashMap channels = new HashMap();
        UnmarshalContainer.unmarshalMapUint32String((Unpack)pack, channels);
        UnmarshalContainer.unmarshalMapStringString((Unpack)pack, new HashMap());
        ArrayList<Long> channelIDs = new ArrayList<Long>();
        for (Uint32 channelID : channels.keySet()) {
            channelIDs.add(channelID.longValue());
        }
        this.completion.onPendingChannelSelection(channelIDs);
    }

    private OpPrepareLive setTitle(String title) {
        this.title = title;
        return this;
    }

    public static interface Completion {
        public void didSucceedPreparing(Channel var1);

        public void onPendingChannelSelection(List<Long> var1);

        public void didFailedPreparing(Failure var1, String var2);
    }

    public static enum Failure {
        PhoneNumberNotBounded,
        CouldNotAcquireLiveChannel,
        LiveForbidden,
        VideoForbidden,
        TitleForbidden,
        AuditRequired,
        Auditing,
        Unknown;

    }
}

