/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.preview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.mobile.pluginstartlive.media.camera.CameraPreview;
import com.yy.mobile.pluginstartlive.media.camera.ICameraPreview;
import com.yy.mobile.pluginstartlive.media.camera.IVideoPreview;
import com.yy.mobile.pluginstartlive.media.liveparam.LiveParamManager;
import com.yy.mobile.pluginstartlive.media.publisher.IVideoPublisher;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublisher;
import com.yy.mobile.util.log.MLog;

public class VideoPreviewLayout
extends FrameLayout
implements IVideoPreview {
    private static final String TAG = "VideoPreviewLayout";
    private IVideoPublisher mVideoPublisher;
    private ICameraPreview mCameraPreview;
    private boolean mIsReleased;

    public VideoPreviewLayout(@NonNull Context context) {
        this(context, null);
    }

    public VideoPreviewLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoPreviewLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mIsReleased = false;
        this.mCameraPreview = new CameraPreview((ViewGroup)this);
        this.mVideoPublisher = new VideoPublisher(this.mCameraPreview);
        LiveParamManager.INSTANCE.init(this.mVideoPublisher);
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"release", (Object[])new Object[0]);
        this.mVideoPublisher.release();
        ((CameraPreview)this.mCameraPreview).release();
        LiveParamManager.INSTANCE.unInit();
        this.mVideoPublisher = null;
        this.mCameraPreview = null;
        this.mIsReleased = true;
    }

    @Override
    public boolean isReleased() {
        return this.mIsReleased || this.mVideoPublisher == null || this.mCameraPreview == null;
    }

    @Override
    public ICameraPreview getCameraPreview() {
        return this.mCameraPreview;
    }

    @Override
    public void setVisibility(boolean visible, boolean goneIfNotVisible) {
        if (visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(goneIfNotVisible ? 8 : 4);
        }
    }

    public void setMicNo(int micNo) {
        if (this.mVideoPublisher != null) {
            this.mVideoPublisher.setMicNo(micNo);
        }
    }
}

