/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.pluginstartlive.component.test;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mediaframework.base.VideoEncoderType;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.pluginstartlive.R;
import com.yy.mobile.pluginstartlive.component.test.MobileLiveVideoControlFlowComponent$$EventBinder;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublishHolder;
import com.yy.mobile.pluginstartlive.media.publisher.VideoPublisher;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishResultListener;
import com.yy.mobile.pluginstartlive.media.publisher.listener.PublishVideoParamsEventListener;
import com.yy.mobile.ui.screencapture.CaptureConstant;
import com.yy.mobile.ui.screencapture.ui.AbsFloatingView;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.yylivekit.anchor.VideoParams;
import com.yymobile.core.channel.ChannelInfo;
import java.lang.ref.SoftReference;
import java.util.Locale;

public class MobileLiveVideoControlFlowComponent
extends AbsFloatingView
implements EventCompat,
PublishVideoParamsEventListener,
PublishResultListener {
    private static final String TAG = "MobileLiveVideoControlFlowComponent";
    private static SoftReference<MobileLiveVideoControlFlowComponent> instance;
    private static final byte[] lock;
    private ViewGroup mRootView;
    private TextView mTvPublishState;
    private TextView mTvChannelInfo;
    private TextView mTvWidthHeightSrv;
    private TextView mTvWidthHeightCur;
    private TextView mTvBitRateSrv;
    private TextView mTvBitRateCur;
    private TextView mTvFrameRateSrv;
    private TextView mTvFrameRateCur;
    private TextView mTvEncodeTypeSrv;
    private TextView mTvEncodeTypeCur;
    private TextView mDynamicBitRate;
    private TextView mEncodeParams;
    private TextView mTvNetWork;
    private Handler mHandler;
    private Looper mMainLooper = Looper.getMainLooper();
    private EventBinder mMobileLiveVideoControlFlowComponentSniperEventBinder;

    public void onEventBind() {
        if (this.mMobileLiveVideoControlFlowComponentSniperEventBinder == null) {
            this.mMobileLiveVideoControlFlowComponentSniperEventBinder = new MobileLiveVideoControlFlowComponent$$EventBinder();
        }
        this.mMobileLiveVideoControlFlowComponentSniperEventBinder.bindEvent((Object)this);
        MLog.info((Object)TAG, (String)"onEventBind", (Object[])new Object[0]);
    }

    public void onEventUnBind() {
        if (this.mMobileLiveVideoControlFlowComponentSniperEventBinder != null) {
            this.mMobileLiveVideoControlFlowComponentSniperEventBinder.unBindEvent();
        }
        MLog.info((Object)TAG, (String)"onEventUnBind", (Object[])new Object[0]);
    }

    public MobileLiveVideoControlFlowComponent(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MobileLiveVideoControlFlowComponent getInstance() {
        if (instance != null && instance.get() != null) return instance.get();
        byte[] byArray = lock;
        synchronized (lock) {
            if (instance != null && instance.get() != null) return instance.get();
            MobileLiveVideoControlFlowComponent mobileLiveVideoControlFlowComponent = new MobileLiveVideoControlFlowComponent(BasicConfig.getInstance().getAppContext());
            instance = new SoftReference<MobileLiveVideoControlFlowComponent>(mobileLiveVideoControlFlowComponent);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance.get();
        }
    }

    public View inflate(Context context) {
        MLog.info((Object)TAG, (String)"inflate", (Object[])new Object[0]);
        this.mRootView = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.fragment_mobile_live_video_control_new, null);
        this.mTvPublishState = (TextView)this.mRootView.findViewById(R.id.publish_state);
        this.mTvChannelInfo = (TextView)this.mRootView.findViewById(R.id.channel_info);
        this.setHideClickListener();
        this.initViews();
        return this.mRootView;
    }

    public void attach() {
        MLog.info((Object)TAG, (String)"attach: ", (Object[])new Object[0]);
        super.attach();
    }

    public void detach() {
        MLog.info((Object)TAG, (String)"detach: ", (Object[])new Object[0]);
        super.detach();
    }

    public void removeFromStage() {
        MLog.info((Object)TAG, (String)"removeFromStage ~~~", (Object[])new Object[0]);
        this.onEventUnBind();
        this.resetUI();
        this.removePublishListener();
        this.detach();
    }

    @TargetApi(value=11)
    public void addToStage() {
        MLog.info((Object)TAG, (String)"addToStage ~~~", (Object[])new Object[0]);
        try {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.addToStageInit();
            } else {
                this.getHandler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MobileLiveVideoControlFlowComponent.this.addToStageInit();
                    }
                }, 2000L);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("addToStage error = " + throwable), (Object[])new Object[0]);
        }
    }

    private void addToStageInit() {
        MLog.info((Object)TAG, (String)"addToStageInit: ", (Object[])new Object[0]);
        if (MobileLiveVideoControlFlowComponent.shouldShow()) {
            MLog.info((Object)TAG, (String)"addToStageInit: shouldShow is true", (Object[])new Object[0]);
            this.onEventBind();
            this.addPublishListener();
            this.attach();
        }
    }

    public static boolean shouldShow() {
        return BasicConfig.getInstance().isDebuggable() && CommonPref.instance().getBoolean("PREF_ENABLE_MOBILE_LIVE_VIDEO_CONTROL", false);
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private void addPublishListener() {
        VideoPublisher videoPublisher = VideoPublishHolder.INSTANCE.getVideoPublisher();
        if (videoPublisher != null) {
            MLog.info((Object)TAG, (String)"addPublishListener", (Object[])new Object[0]);
            videoPublisher.addPublishVideoParamsEventListener(this);
            videoPublisher.addPublishResultListener(this);
        }
    }

    private void removePublishListener() {
        VideoPublisher videoPublisher = VideoPublishHolder.INSTANCE.getVideoPublisher();
        if (videoPublisher != null) {
            MLog.info((Object)TAG, (String)"removePublishListener", (Object[])new Object[0]);
            videoPublisher.removePublishVideoParamsEventListener(this);
            videoPublisher.removePublishResultListener(this);
        }
    }

    private void initViews() {
        this.mTvWidthHeightSrv = (TextView)this.mRootView.findViewById(R.id.tv_width_height_srv);
        this.mTvWidthHeightCur = (TextView)this.mRootView.findViewById(R.id.tv_width_height_cur);
        this.mTvBitRateSrv = (TextView)this.mRootView.findViewById(R.id.tv_bitrate_srv);
        this.mTvBitRateCur = (TextView)this.mRootView.findViewById(R.id.tv_bitrate_cur);
        this.mTvFrameRateSrv = (TextView)this.mRootView.findViewById(R.id.tv_frame_rate_srv);
        this.mTvFrameRateCur = (TextView)this.mRootView.findViewById(R.id.tv_frame_rate_cur);
        this.mTvEncodeTypeSrv = (TextView)this.mRootView.findViewById(R.id.tv_encode_type_srv);
        this.mTvEncodeTypeCur = (TextView)this.mRootView.findViewById(R.id.tv_encode_type_cur);
        this.mTvNetWork = (TextView)this.mRootView.findViewById(R.id.tv_net_work);
        this.mDynamicBitRate = (TextView)this.mRootView.findViewById(R.id.tv_dynamic_bit_rate);
        this.mEncodeParams = (TextView)this.mRootView.findViewById(R.id.tv_encode_param);
    }

    private void setHideClickListener() {
        final View scrollView = this.mRootView.findViewById(R.id.scroll_view);
        View hideText = this.mRootView.findViewById(R.id.hide_text);
        this.setDragTriggerView(hideText);
        scrollView.setVisibility(8);
        hideText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                scrollView.setVisibility(scrollView.getVisibility() == 0 ? 8 : 0);
            }
        });
    }

    private void setWidthHeightSrv(int width, int height) {
        MLog.info((Object)TAG, (String)("setWidthHeightSrv() called with: width = [" + width + "], height = [" + height + "]"), (Object[])new Object[0]);
        String text = String.format(Locale.getDefault(), "width*height:%d*%d", width, height);
        this.setTextViewString(this.mTvWidthHeightSrv, text);
    }

    private void setBitRateSrv(int bitrate) {
        MLog.info((Object)TAG, (String)("setBitRateSrv() called with: bitrate = [" + bitrate + "]"), (Object[])new Object[0]);
        String text = String.format(Locale.getDefault(), "bitrate:%dK", bitrate);
        this.setTextViewString(this.mTvBitRateSrv, text);
    }

    private void setFrameRateSrv(int frameRate) {
        String text = String.format(Locale.getDefault(), "frameRate:%d", frameRate);
        this.setTextViewString(this.mTvFrameRateSrv, text);
    }

    private void setEncodeTypeSrv(VideoEncoderType encodeType) {
        String text = String.format(Locale.getDefault(), "encodeType:%s", encodeType);
        this.setTextViewString(this.mTvEncodeTypeSrv, text);
    }

    private void setWidthHeightCur(int width, int height) {
        String text = String.format(Locale.getDefault(), "width*height:%d*%d", width, height);
        this.setTextViewString(this.mTvWidthHeightCur, text);
    }

    private void setBitRateCur(int bitrate) {
        String text = String.format(Locale.getDefault(), "bitrate:%dK", bitrate);
        this.setTextViewString(this.mTvBitRateCur, text);
    }

    private void setFrameRateCur(int frameRate) {
        String text = String.format(Locale.getDefault(), "frameRate:%d", frameRate);
        this.setTextViewString(this.mTvFrameRateCur, text);
    }

    private void setEncodeTypeCur(VideoEncoderType encodeType) {
        String text = String.format(Locale.getDefault(), "encodeType:%s", encodeType);
        this.setTextViewString(this.mTvEncodeTypeCur, text);
    }

    private void setEncodeTypeCur(String encodeTypeStr) {
        String text = String.format(Locale.getDefault(), "encodeType:%s", encodeTypeStr);
        this.setTextViewString(this.mTvEncodeTypeCur, text);
    }

    private void setSuggestBitRate(int bitRate) {
        String text = String.format(Locale.getDefault(), "suggest bitrate:%dK", bitRate);
        this.setTextViewString(this.mDynamicBitRate, text);
    }

    private void setEncodeParams(String params) {
        String text = String.format(Locale.getDefault(), "encode params:%s", params);
        this.setTextViewString(this.mEncodeParams, text);
    }

    private void setTextViewString(final TextView textView, final String string2) {
        MLog.debug((Object)TAG, (String)"setTextViewString: textView:%s, string:%s", (Object[])new Object[]{textView, string2});
        if (this.mMainLooper == Looper.myLooper()) {
            textView.setText((CharSequence)string2);
        } else {
            this.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    textView.setText((CharSequence)string2);
                }
            });
        }
    }

    private String fromEncodeParams(String params) {
        if (FP.empty((CharSequence)params)) {
            MLog.info((Object)TAG, (String)"fromEncodeParams: empty params:%s", (Object[])new Object[]{params});
            return null;
        }
        int keyIndex = params.indexOf("mEncodeType");
        MLog.info((Object)TAG, (String)"fromEncodeParams: keyIndex position:%d", (Object[])new Object[]{keyIndex});
        if (keyIndex == -1) {
            return null;
        }
        int start2 = params.indexOf(":", keyIndex);
        int end = params.indexOf(" ", keyIndex);
        String encodeType = params.substring(start2 + 1, end);
        MLog.info((Object)TAG, (String)"fromEncodeParams: encodeType:%s", (Object[])new Object[]{encodeType});
        return encodeType;
    }

    private void resetUI() {
        String str = "loading";
        if (this.mTvWidthHeightSrv == null) {
            return;
        }
        this.mTvWidthHeightSrv.setText((CharSequence)str);
        this.mTvWidthHeightCur.setText((CharSequence)str);
        this.mTvBitRateSrv.setText((CharSequence)str);
        this.mTvBitRateCur.setText((CharSequence)str);
        this.mTvFrameRateSrv.setText((CharSequence)str);
        this.mTvFrameRateCur.setText((CharSequence)str);
        this.mTvEncodeTypeSrv.setText((CharSequence)str);
        this.mTvEncodeTypeCur.setText((CharSequence)str);
        this.mDynamicBitRate.setText((CharSequence)str);
        this.mEncodeParams.setText((CharSequence)str);
        this.mTvNetWork.setText((CharSequence)str);
        this.mTvPublishState.setText((CharSequence)"");
    }

    @Override
    public void onVideoEncodeType(VideoEncoderType encodeType) {
        MLog.info((Object)TAG, (String)("onVideoEncodeType() called with: encodeType = [" + encodeType + "]"), (Object[])new Object[0]);
        this.setEncodeTypeCur(encodeType);
    }

    @Override
    public void onVideoEncodeResolution(int width, int height) {
        MLog.info((Object)TAG, (String)("onVideoEncodeResolution() called with: width = [" + width + "], height = [" + height + "]"), (Object[])new Object[0]);
        this.setWidthHeightCur(width, height);
    }

    @Override
    public void onSwitchQuality(VideoParams videoParams) {
        MLog.info((Object)TAG, (String)"onSwitchQuality: videoParams:%s", (Object[])new Object[]{videoParams});
        if (this.mRootView != null) {
            this.setWidthHeightSrv(videoParams.width, videoParams.height);
            this.setBitRateSrv(videoParams.codeRate / 1000);
            this.setFrameRateSrv(videoParams.frameRate);
            this.setEncodeTypeSrv(videoParams.encodeType);
        }
    }

    @Override
    public void onVideoEncodeFirstFrame() {
        MLog.info((Object)TAG, (String)"onEncodeFirstFrame", (Object[])new Object[0]);
    }

    @Override
    public void onVideoUploadInfoEvent(int packetLossRate, int rtt) {
        MLog.info((Object)TAG, (String)("onVideoUploadInfoEvent() called with: packetLossRate = [" + packetLossRate + "], rtt = [" + rtt + "]"), (Object[])new Object[0]);
        String text = String.format(Locale.getDefault(), "\u4e22\u5305\u7387:%d, rtt:%d", packetLossRate, rtt);
        this.mTvNetWork.setText((CharSequence)text);
    }

    @Override
    public void onVideoUploadRateEvent(int bitrate, int frameRate) {
        MLog.info((Object)TAG, (String)("onVideoUploadRateEvent() called with: bitrate = [" + bitrate + "], frameRate = [" + frameRate + "]"), (Object[])new Object[0]);
        this.setBitRateCur(bitrate / 1000);
        this.setFrameRateCur(frameRate);
    }

    @Override
    public void onSuggestDynamicBitrateEvent(int bitrate) {
        MLog.info((Object)TAG, (String)("onSuggestDynamicBitrateEvent() called with: bitrate = [" + bitrate + "]"), (Object[])new Object[0]);
        this.setSuggestBitRate(bitrate / 1000);
    }

    @Override
    public void onVideoEncodeData(byte[] bytes, int i, long l, long l1, int i1, VideoEncoderType videoEncodeType) {
    }

    @Override
    public void onEncodeEncParam(String s) {
        MLog.info((Object)TAG, (String)"onEncodeEncParam: params:%s", (Object[])new Object[]{s});
        this.setEncodeParams(s);
        this.setEncodeTypeCur(this.fromEncodeParams(s));
    }

    public WindowManager.LayoutParams configParams() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.type = Build.VERSION.SDK_INT >= 26 ? 2038 : (Build.VERSION.SDK_INT > 24 ? 2002 : 2005);
        params.format = 1;
        params.flags = 40;
        params.gravity = 51;
        params.x = 0;
        int max = Math.max(CaptureConstant.SCREEN_WIDTH, CaptureConstant.SCREEN_HEIGHT);
        params.y = max / 2 - CaptureConstant.FLOAT_BAR_HEIGHT / 2;
        params.height = -2;
        params.width = -1;
        return params;
    }

    @Override
    public void onPublishSuccess() {
        MLog.info((Object)TAG, (String)"onPublishSuccess() called", (Object[])new Object[0]);
        this.mTvPublishState.setText((CharSequence)"publish state\uff1asuccess!");
    }

    @BusEvent(mainThread=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        String str = String.format(Locale.getDefault(), "uid=%d, sid=%d, ssid=%d, aid:%d", LoginUtil.getUid(), channelInfo.topSid, channelInfo.subSid, channelInfo.topASid);
        this.setTextViewString(this.mTvChannelInfo, str);
    }

    @Override
    public void onPublishFail(int streamType, int code, String message) {
        String streamTypeStr;
        MLog.info((Object)TAG, (String)("onPublishFail() called with: streamType = [" + streamType + "], code = [" + code + "], message = [" + message + "]"), (Object[])new Object[0]);
        switch (streamType) {
            case -1: {
                streamTypeStr = "Unknown";
                break;
            }
            case 1: {
                streamTypeStr = "Audio";
                break;
            }
            case 2: {
                streamTypeStr = "Video";
                break;
            }
            case 3: {
                streamTypeStr = "Group";
                break;
            }
            case 5: {
                streamTypeStr = "BcAudio";
                break;
            }
            default: {
                streamTypeStr = "Empty";
            }
        }
        String text = String.format("publish state\uff1afail! streamType:%s, code:%d, message:%s", streamTypeStr, code, message);
        this.mTvPublishState.setText((CharSequence)text);
    }

    static {
        lock = new byte[0];
    }
}

