package com.yy.mobile.vivo

import android.Manifest
import android.annotation.SuppressLint
import android.app.Application
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.view.View
import com.duowan.mobile.aar.R
import com.gyf.immersionbar.ImmersionBar
import com.unionyy.mobile.magnet.core.state.CrossProcessLoginState
import com.unionyy.mobile.magnet.core.state.InterruptState
import com.unionyy.mobile.magnet.core.state.LoginState
import com.unionyy.mobile.magnet.core.state.LogoutState
import com.unionyy.mobile.magnet.southpole.Magnet
import com.unionyy.mobile.meipai.api.MP2YYFeedbackAction
import com.unionyy.mobile.vivo.api.VV2YYAuthAction
import com.unionyy.mobile.vivo.api.VV2YYChannelAction
import com.unionyy.mobile.vivo.personalcard.VivoPersonalCardComponent
import com.unionyy.mobile.vivo.utils.ClipboardUtil
import com.unionyy.opensdk.BuildConfig
import com.yy.mobile.baseapi.AuthCallback
import com.yy.mobile.baseapi.Union2YYSettingAction
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.config.BasicConfig
import com.yy.mobile.permission.AndroidPermission
import com.yy.mobile.ui.widget.toast.Toast
import com.yy.mobile.util.log.MLog
import com.yy.mobile.util.pref.CommonPref
import com.yy.mobile.ylink.bridge.CoreApiManager
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi
import com.yymobile.core.ICoreManagerBase
import kotlinx.android.synthetic.main.vivo_activity_demo.btnLogin
import kotlinx.android.synthetic.main.vivo_activity_demo.cb_show_user_id
import kotlinx.android.synthetic.main.vivo_activity_demo.currentStateText
import kotlinx.android.synthetic.main.vivo_activity_demo.et_access_token
import kotlinx.android.synthetic.main.vivo_activity_demo.et_channel_sid
import kotlinx.android.synthetic.main.vivo_activity_demo.feedBack
import kotlinx.android.synthetic.main.vivo_activity_demo.h5Test
import kotlinx.android.synthetic.main.vivo_activity_demo.tv_app_version

class DemoActivity : FragmentActivity() {

    companion object {
        private const val TAG = "DemoActivity"
    }

    @SuppressLint("CheckResult")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.vivo_activity_demo)

        ImmersionBar.with(this).init()
        et_channel_sid.autoSaveLastModifyRecord()

        val permissions = listOf(
            Manifest.permission.READ_PHONE_STATE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.INTERNET
        )
        ICoreManagerBase.getCore(AndroidPermission::class.java)
            ?.checkPermission(this, permissions)

        btnLogin.setOnClickListener {
            if (LoginUtil.isLogined()) {
                Toast.makeText(this, "已登录!", Toast.LENGTH_SHORT).show()
            }
            startActivity(Intent(this, PasswordLoginActivity::class.java))
        }

        feedBack.setOnClickListener {
            VVYYSDK.obtainAction(MP2YYFeedbackAction::class.java)?.gotoFeedbackPage(this)
        }

        h5Test.setOnClickListener {
            CoreApiManager.getInstance().getApi(NavigationUtilApi::class.java)!!.toJSSupportedWebView(
                this,
                "http://webtest.yy.com/app_doc/index.html"
            )
        }

        refreshState()
        tv_app_version.text = "YY版本号：${BuildConfig.YYSDK_VER}"

        cb_show_user_id.apply {
            setOnCheckedChangeListener { _, isChecked ->
                CommonPref.instance().putBoolean(VivoPersonalCardComponent.VIVO_SHOW_USER_ID, isChecked)
            }
            try {
                val checkedPref = CommonPref.instance()
                    .getBoolean(VivoPersonalCardComponent.VIVO_SHOW_USER_ID, false)
                MLog.info(TAG, "checkedPref = $checkedPref")
                isChecked = checkedPref
            } catch (e: NullPointerException) {
                MLog.error(TAG, "please init yy sdk first.")
            }
        }

        currentStateText.setOnLongClickListener {
            ClipboardUtil.newPlainText("CurrentStateText", currentStateText.text.toString())
            true
        }
    }

    fun gotoChannel(v: View) {
        val sid = et_channel_sid.text.toString().toLongOrNull() ?: 1493896955
        val ssid = 0L
        BasicConfig.getInstance().appContext?.let {
            if (it is Application) {
                VVYYSDK.obtainAction(VV2YYChannelAction::class.java, it, this)?.run {
                    instance(sid, ssid)
                        .joinChannel(this@DemoActivity)
                }
            }
        }
    }

    fun gotoSetting(v: View) {
        VVYYSDK.obtainAction(Union2YYSettingAction::class.java)?.gotoSettingActivity(this)
    }

    fun login(v: View) {
        VVYYSDK.obtainAction(VV2YYAuthAction::class.java)
            ?.bindLogin(et_access_token.text.toString(), object : AuthCallback {
                override fun onSuccess(yyUid: Long, ticket: String, isNewUser: Boolean) {
                    Toast.makeText(
                        this@DemoActivity, "登录成功: $yyUid", Toast.LENGTH_SHORT
                    ).show()
                }

                override fun onFail(reason: String?) {
                    Toast.makeText(
                        this@DemoActivity, "登录失败 $reason", Toast.LENGTH_SHORT
                    ).show()
                }
            })
    }

    @SuppressLint("SetTextI18n")
    private fun refreshState() {
        val state = Magnet.getCurrentState()
        when (state) {
            is LoginState ->
                currentStateText.text = "登录中-当前uid:${state.currentUid}, 第三方openId:${state.thirdPartyInfo?.openId}"
            is InterruptState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}, 错误:${state.error?.message}"
            is LogoutState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}"
            is CrossProcessLoginState ->
                currentStateText.text = "跨进程登录中-当前uid:${state.currentUid}"
        }
    }
}