/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.feature;

import com.duowan.mobile.main.feature.Feature;
import com.duowan.mobile.main.feature.FeatureHouse;
import com.duowan.mobile.main.feature.FeatureStorage;
import com.duowan.mobile.main.feature.FeatureSyringeService;
import com.duowan.mobile.main.feature.FeaturesFactory;
import com.duowan.mobile.main.feature.wrapper.FeatureWrapper;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FeaturesImpl {
    private final FeatureStorage mStorage;
    private final FeaturesFactory mFactory;
    private FeatureSyringeService mSyringeService;
    private final ConcurrentHashMap<Class<? extends Feature>, FeatureWrapper> mFeatures = new ConcurrentHashMap();

    public FeaturesImpl(FeatureStorage storage, FeaturesFactory factory) {
        this.mStorage = storage;
        this.mFactory = factory;
        this.mSyringeService = new FeatureSyringeService();
        this.mSyringeService.init();
    }

    public <T extends Feature> T of(Class<T> clz) {
        return this.wrapper(clz).instance();
    }

    public <T extends Feature> FeatureWrapper<T, ?> wrapper(Class<T> clz) {
        FeatureWrapper<T, ?> featureWrapper = this.mFeatures.get(clz);
        if (featureWrapper == null) {
            featureWrapper = this.create(clz);
            if (featureWrapper == null) {
                throw new RuntimeException("Feature is not used properly, type:" + clz.getSimpleName());
            }
            this.mFeatures.put(clz, featureWrapper);
        }
        return featureWrapper;
    }

    public FeatureWrapper wrapper(String key) {
        return this.wrapper(this.mFactory.map(key));
    }

    public Set<Class<? extends Feature>> featureClasses() {
        return this.mFactory.featureClasses();
    }

    private <T extends Feature> FeatureWrapper<T, ?> create(Class<T> clz) {
        return this.mFactory.create(clz, this.mStorage);
    }

    public void addFeatureMap(String moudleName) {
        this.mSyringeService.inject(moudleName, FeatureHouse.mFeatureClzs, FeatureHouse.mFeatureWrappers);
    }
}

