/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.main.feature.wrapper;

import com.duowan.mobile.main.feature.Feature;
import com.duowan.mobile.main.feature.FeatureStorage;
import com.duowan.mobile.main.feature.wrapper.AbstractFeatureWrapper;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MixedFeatureWrapper<T extends Feature, TYPE>
extends AbstractFeatureWrapper<T, TYPE> {
    private final int mValueCount;
    private final T[] mInstance;
    private final Class[] mImplClasses;
    protected final Map<TYPE, Integer> mIndexMap;

    public MixedFeatureWrapper(FeatureStorage storage, String storageKey, TYPE dfValue, Class<T> clz, int valueCount, String alias, String group) {
        super(storage, storageKey, dfValue, alias, group);
        this.mValueCount = valueCount;
        this.mInstance = (Feature[])Array.newInstance(clz, this.mValueCount);
        this.mImplClasses = (Class[])Array.newInstance(Class.class, this.mValueCount);
        this.mIndexMap = new HashMap<TYPE, Integer>();
        this.initializeIndex();
    }

    @Override
    public final T instance() {
        if (this.mIndexMap.isEmpty()) {
            return null;
        }
        Object value = this.storageValue();
        Integer index = this.mIndexMap.get(value);
        return this.instanceOfIndex(index);
    }

    private T instanceOfIndex(int index) {
        if (this.mInstance[index] == null) {
            this.mInstance[index] = this.createInstance(index);
        }
        return this.mInstance[index];
    }

    private T createInstance(int index) {
        Class clz = this.mImplClasses[index];
        try {
            return (T)((Feature)clz.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected final void mapIndex(TYPE value, int index, Class<? extends T> implClass) {
        this.mIndexMap.put(value, index);
        this.mImplClasses[index] = implClass;
    }

    @Override
    public void store(TYPE value) {
        Object oldValue = this.storageValue();
        if (value.equals(oldValue)) {
            return;
        }
        Set<TYPE> ketSet = this.mIndexMap.keySet();
        if (ketSet.isEmpty()) {
            this.storeValue(value);
        } else {
            for (TYPE v : this.mIndexMap.keySet()) {
                if (!v.equals(value)) continue;
                this.storeValue(value);
            }
        }
    }

    @Override
    public void storeInstance(T instance) {
        int index;
        for (index = 0; index < this.mValueCount && this.mInstance[index] != instance; ++index) {
        }
        if (index >= this.mValueCount) {
            return;
        }
        for (Map.Entry<TYPE, Integer> entry : this.mIndexMap.entrySet()) {
            if (entry.getValue() != index) continue;
            this.store(entry.getKey());
            break;
        }
    }

    @Override
    public T next() {
        Object value = this.storageValue();
        int index = this.mIndexMap.get(value);
        int nextIndex = (index + this.mValueCount + 1) % this.mValueCount;
        return this.instanceOfIndex(nextIndex);
    }

    protected abstract void initializeIndex();

    protected abstract void storeValue(TYPE var1);
}

