/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.heytap.barrage.basic;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.unionyy.mobile.heytap.R;
import com.yy.mobile.util.log.MLog;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J \u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/unionyy/mobile/heytap/barrage/basic/OppoLevelUtil;", "", "()V", "levelNumberList", "", "getLevelNumberList", "()[I", "levelbgList", "getLevelbgList", "getDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "level", "", "getLevelBackgroundIcon", "getLevelDrawable", "(I)Ljava/lang/Integer;", "getUpgradeLevelBitmap", "Landroid/graphics/Bitmap;", "color", "heytap_release"})
public final class OppoLevelUtil {
    @NotNull
    private static final int[] levelNumberList;
    @NotNull
    private static final int[] levelbgList;
    public static final OppoLevelUtil INSTANCE;

    @NotNull
    public final int[] getLevelNumberList() {
        return levelNumberList;
    }

    @NotNull
    public final int[] getLevelbgList() {
        return levelbgList;
    }

    @Nullable
    public final Drawable getDrawable(@NotNull Context context, int level) {
        int vLevel;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (level >= 100) {
            MLog.info((Object)"getDrawable", (String)("level = " + level), (Object[])new Object[0]);
            n = 99;
        } else {
            n = vLevel = level;
        }
        if (vLevel <= 0 || vLevel > 99) {
            return null;
        }
        return new Drawable(context, vLevel){
            @NotNull
            private final Paint paint;
            @NotNull
            private RectF numberRectF1;
            @NotNull
            private RectF numberRectF2;
            private int width;
            private int height;
            final /* synthetic */ Context $context;
            final /* synthetic */ int $vLevel;

            @NotNull
            public final Paint getPaint() {
                return this.paint;
            }

            @NotNull
            public final RectF getNumberRectF1() {
                return this.numberRectF1;
            }

            public final void setNumberRectF1(@NotNull RectF rectF) {
                Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
                this.numberRectF1 = rectF;
            }

            @NotNull
            public final RectF getNumberRectF2() {
                return this.numberRectF2;
            }

            public final void setNumberRectF2(@NotNull RectF rectF) {
                Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
                this.numberRectF2 = rectF;
            }

            public final int getWidth() {
                return this.width;
            }

            public final void setWidth(int n) {
                this.width = n;
            }

            public final int getHeight() {
                return this.height;
            }

            public final void setHeight(int n) {
                this.height = n;
            }

            public int getIntrinsicWidth() {
                return this.width;
            }

            public int getIntrinsicHeight() {
                return this.height;
            }

            public void draw(@Nullable Canvas canvas) {
                block3: {
                    Bitmap bg = BitmapFactory.decodeStream((InputStream)this.$context.getResources().openRawResource(OppoLevelUtil.INSTANCE.getLevelbgList()[this.$vLevel / 10]));
                    Rect rect = new Rect(0, 0, this.width, this.height);
                    Canvas canvas2 = canvas;
                    if (canvas2 != null) {
                        canvas2.drawBitmap(bg, null, rect, this.paint);
                    }
                    if (this.$vLevel >= 10) {
                        Bitmap numberX = BitmapFactory.decodeStream((InputStream)this.$context.getResources().openRawResource(OppoLevelUtil.INSTANCE.getLevelNumberList()[this.$vLevel / 10]));
                        Canvas canvas3 = canvas;
                        if (canvas3 != null) {
                            canvas3.drawBitmap(numberX, null, this.numberRectF1, this.paint);
                        }
                    }
                    Bitmap numberI = BitmapFactory.decodeStream((InputStream)this.$context.getResources().openRawResource(OppoLevelUtil.INSTANCE.getLevelNumberList()[this.$vLevel % 10]));
                    Canvas canvas4 = canvas;
                    if (canvas4 == null) break block3;
                    canvas4.drawBitmap(numberI, null, this.numberRectF2, this.paint);
                }
            }

            public void setBounds(int left, int top, int right, int bottom) {
                super.setBounds(left, top, right, bottom);
                this.width = right - left;
                this.height = bottom - top;
                this.numberRectF1.left *= (float)this.width / (float)318;
                this.numberRectF1.right *= (float)this.width / (float)318;
                this.numberRectF1.top *= (float)this.height / (float)132;
                this.numberRectF1.bottom *= (float)this.height / (float)132;
                this.numberRectF2.left *= (float)this.width / (float)318;
                this.numberRectF2.right *= (float)this.width / (float)318;
                this.numberRectF2.top *= (float)this.height / (float)132;
                this.numberRectF2.bottom *= (float)this.height / (float)132;
            }

            public void setAlpha(int alpha) {
                this.paint.setAlpha(alpha);
            }

            public int getOpacity() {
                return -2;
            }

            public void setColorFilter(@Nullable ColorFilter colorFilter) {
            }
            {
                this.$context = $captured_local_variable$0;
                this.$vLevel = $captured_local_variable$1;
                this.paint = new Paint();
                this.numberRectF1 = new RectF(173.0f, 26.25f, 207.5f, 105.75f);
                this.numberRectF2 = new RectF(222.5f, 26.25f, 258.0f, 105.75f);
                this.width = 318;
                this.height = 132;
                this.paint.setAntiAlias(true);
                this.paint.setFilterBitmap(true);
            }
        };
    }

    @Nullable
    public final Integer getLevelDrawable(int level) {
        Integer n;
        switch (level) {
            case 0: {
                n = R.drawable.vivo_level_0;
                break;
            }
            case 1: {
                n = R.drawable.vivo_level_1;
                break;
            }
            case 2: {
                n = R.drawable.vivo_level_2;
                break;
            }
            case 3: {
                n = R.drawable.vivo_level_3;
                break;
            }
            case 4: {
                n = R.drawable.vivo_level_4;
                break;
            }
            case 5: {
                n = R.drawable.vivo_level_5;
                break;
            }
            case 6: {
                n = R.drawable.vivo_level_6;
                break;
            }
            case 7: {
                n = R.drawable.vivo_level_7;
                break;
            }
            case 8: {
                n = R.drawable.vivo_level_8;
                break;
            }
            case 9: {
                n = R.drawable.vivo_level_9;
                break;
            }
            default: {
                n = null;
            }
        }
        Integer res = n;
        return res;
    }

    @Nullable
    public final Bitmap getUpgradeLevelBitmap(@NotNull Context context, int level, int color) {
        Bitmap bg;
        int it;
        boolean bl;
        boolean bl2;
        Integer n;
        int leftNumber;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (level <= 0 || level > 99) {
            return null;
        }
        Paint paint = new Paint();
        boolean bl3 = false;
        List numberDrawableList = list = (List)new ArrayList();
        if (level >= 10) {
            leftNumber = level / 10;
            Integer n2 = this.getLevelDrawable(leftNumber);
            if (n2 != null) {
                n = n2;
                bl2 = false;
                bl = false;
                it = ((Number)n).intValue();
                boolean bl4 = false;
                numberDrawableList.add(it);
            }
        }
        leftNumber = level % 10;
        Integer n3 = this.getLevelDrawable(leftNumber);
        if (n3 != null) {
            n = n3;
            bl2 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl5 = false;
            numberDrawableList.add(it);
        }
        Bitmap bitmap = bg = BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(((Number)numberDrawableList.get(0)).intValue()));
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"bg");
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bg.getHeight();
        Bitmap imageBitmap = Bitmap.createBitmap((int)(bitmapWidth * 2), (int)bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(imageBitmap);
        if (numberDrawableList.size() == 2) {
            Rect oneRect = new Rect();
            oneRect.set(0, 0, bitmapWidth, bitmapHeight);
            canvas.drawBitmap(BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(((Number)numberDrawableList.get(0)).intValue())), null, oneRect, paint);
            Rect rightRect = new Rect();
            rightRect.set(bitmapWidth, 0, bitmapWidth * 2, bitmapHeight);
            canvas.drawBitmap(BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(((Number)numberDrawableList.get(1)).intValue())), null, rightRect, paint);
        } else {
            Rect destRect = new Rect();
            destRect.set(bitmapWidth / 2, 0, bitmapWidth * 3 / 2, bitmapHeight);
            canvas.drawBitmap(BitmapFactory.decodeStream((InputStream)context.getResources().openRawResource(((Number)numberDrawableList.get(0)).intValue())), null, destRect, paint);
        }
        return imageBitmap;
    }

    public final int getLevelBackgroundIcon(int level) {
        return level >= 40 ? R.drawable.op_bg_level_40 : (level >= 30 ? R.drawable.op_bg_level_30 : (level >= 20 ? R.drawable.op_bg_level_30 : (level >= 10 ? R.drawable.op_bg_level_20 : R.drawable.op_bg_leve_l0)));
    }

    private OppoLevelUtil() {
    }

    static {
        OppoLevelUtil oppoLevelUtil;
        INSTANCE = oppoLevelUtil = new OppoLevelUtil();
        levelNumberList = new int[10];
        levelbgList = new int[10];
    }
}

