/*
 * Decompiled with CFR 0.152.
 */
package com.yy.android.small.plugin;

import android.text.TextUtils;
import java.io.File;
import java.util.HashMap;

public class Plugin {
    private String mId;
    int mLaunchMode;
    private String[] mActions;
    private String mActionString;
    private String mVersion;
    private String mPackageName;
    private int mComType;
    private File mApkFile;
    private String mBuildVersion;
    private String mBuildDate;
    private HashMap<String, String> mDependedInfo = new HashMap();

    public Plugin(String id, int launchMode, String action, String version, String packageName, int comType) {
        this.mId = id;
        this.mLaunchMode = launchMode;
        if (action != null) {
            this.mActionString = action;
            this.mActions = action.split(",");
        }
        this.mVersion = version;
        this.mPackageName = packageName;
        this.mComType = comType;
    }

    void setBuildVersion(String buildVersion) {
        this.mBuildVersion = buildVersion;
    }

    String buildVersion() {
        return this.mBuildVersion;
    }

    void setDependedInfo(HashMap<String, String> dependedInfo) {
        this.mDependedInfo = dependedInfo;
    }

    HashMap<String, String> dependedInfo() {
        return this.mDependedInfo;
    }

    public boolean matchLaunchMode(int launchMode) {
        return this.mLaunchMode == launchMode;
    }

    public boolean matchAction(String action) {
        if (!TextUtils.isEmpty((CharSequence)action)) {
            if (this.mActions != null && this.mActions.length != 0) {
                String ac = action.trim();
                for (String s : this.mActions) {
                    if (!ac.equals(s.trim())) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return this.mActions == null || this.mActions.length == 0;
    }

    public String[] getAction() {
        return this.mActions;
    }

    public String getActionString() {
        return this.mActionString;
    }

    public String id() {
        return this.mId;
    }

    public String version() {
        return this.mVersion;
    }

    public String packageName() {
        return this.mPackageName;
    }

    public File apkFile() {
        return this.mApkFile;
    }

    void setBuildDate(String buildDate) {
        this.mBuildDate = buildDate;
    }

    public String buildDate() {
        return this.mBuildDate;
    }

    public String getLibraryPath() {
        return this.mApkFile != null ? new File(this.mApkFile.getParentFile(), "lib").getPath() : null;
    }

    public boolean matchComType(int comType) {
        return this.mComType == comType;
    }
}

