/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.revenue.argift;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Looper;
import android.support.annotation.GuardedBy;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.unionyy.mobile.yyanchor.revenue.argift.ARQueueManager;
import com.unionyy.mobile.yyanchor.revenue.argift.ArEntity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.GiftStickerItem;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ARGiftManager {
    private static final String TAG = "ARQueueManager";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String NOMEDIA = ".nomedia";
    private static final File StickerPath = new File(BasicConfig.getInstance().getRootDir() + File.separator + "giftstickers");
    private final Set<GiftStickerItem> mGiftStickerItems = new LinkedHashSet<GiftStickerItem>();
    private final ARQueueManager mQueueManager;
    @GuardedBy(value="waitForPlay")
    private final List<GiftStickerItem> waitForPlay = new LinkedList<GiftStickerItem>();
    private final SharedPreferences mARGiftManagerPreferences;

    public ARGiftManager(ARQueueManager queueManager) {
        this.mQueueManager = queueManager;
        this.mARGiftManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)"ARGiftManagerPreferences", (int)0);
    }

    protected File getOrMkdirStickerPath() {
        if (!StickerPath.exists()) {
            StickerPath.mkdirs();
        }
        return StickerPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void downloadAndDecompressIfNeed(final @NonNull GiftStickerItem item, final @Nullable Runnable onFinish) {
        GiftStickerItem giftStickerItem = item;
        synchronized (giftStickerItem) {
            if (item.giftStickerStatus == GiftStickerItem.GiftStickerStatus.UNDOWNLOAD) {
                MLog.info((Object)TAG, (String)("download item = " + item), (Object[])new Object[0]);
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.DOWNLOADING;
                this.downloadStickerFile(item, new ResponseListener<String>(){

                    public void onResponse(String response) {
                        ARGiftManager.this.decompress(item);
                        if (onFinish != null) {
                            onFinish.run();
                        }
                    }
                }, new ResponseErrorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onErrorResponse(RequestError error) {
                        GiftStickerItem giftStickerItem = item;
                        synchronized (giftStickerItem) {
                            MLog.error((Object)ARGiftManager.TAG, (String)("download fail item = " + item), (Object[])new Object[0]);
                            item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.UNDOWNLOAD;
                            if (onFinish != null) {
                                onFinish.run();
                            }
                        }
                    }
                }, null);
            } else {
                MLog.info((Object)TAG, (String)("no need to download item = " + item), (Object[])new Object[0]);
                if (onFinish != null) {
                    onFinish.run();
                }
            }
        }
    }

    @MainThread
    public void initData() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    ARGiftManager.this.initData();
                }
            });
            return;
        }
        this.checkPathAndNoMedia();
        boolean arItemChanged = false;
        List arGiftConfigItems = GiftConfigParser.getInstance().getVrPropsList();
        for (GiftConfigParser.VRGiftConfigItem arItem : arGiftConfigItems) {
            if (StringUtils.isEmpty((String)arItem.lv1Src).booleanValue() || StringUtils.isEmpty((String)arItem.lv2Src).booleanValue() || StringUtils.isEmpty((String)arItem.lv3Src).booleanValue()) continue;
            List items = GiftStickerItem.fromArGiftConfigItem((GiftConfigParser.VRGiftConfigItem)arItem);
            arItemChanged = this.mGiftStickerItems.addAll(items) || arItemChanged;
        }
        if (arItemChanged) {
            for (final GiftStickerItem item : this.mGiftStickerItems) {
                Schedulers.io().scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        ARGiftManager.this.updateItemStatus(item);
                        ARGiftManager.this.downloadAndDecompressIfNeed(item, ARGiftManager.this.prepareToPlayOrRetryIfFail(item));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void openFaceStickerWithInfo(final int type, final int grade) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    ARGiftManager.this.openFaceStickerWithInfo(type, grade);
                }
            });
            return;
        }
        final GiftStickerItem item = this.getGiftStickerItemByid(type, grade);
        if (item == null) {
            MLog.error((Object)TAG, (String)("No GiftStickerItem found for type = " + type + " grade = " + grade), (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)("openFaceStickerWithInfo item = " + item), (Object[])new Object[0]);
        List<GiftStickerItem> list = this.waitForPlay;
        synchronized (list) {
            this.waitForPlay.add(item);
        }
        Schedulers.io().scheduleDirect(new Runnable(){

            @Override
            public void run() {
                ARGiftManager.this.updateItemStatus(item);
                ARGiftManager.this.downloadAndDecompressIfNeed(item, ARGiftManager.this.prepareToPlayOrRetryIfFail(item));
            }
        });
    }

    private Runnable prepareToPlayOrRetryIfFail(final GiftStickerItem item) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GiftStickerItem.GiftStickerStatus status;
                GiftStickerItem giftStickerItem = item;
                synchronized (giftStickerItem) {
                    status = item.giftStickerStatus;
                }
                MLog.info((Object)ARGiftManager.TAG, (String)("prepareToPlayAndRetryIfFail status = " + status), (Object[])new Object[0]);
                if (status == GiftStickerItem.GiftStickerStatus.READY) {
                    int howManyItemWaiting = 0;
                    if (ARGiftManager.this.waitForPlay.size() > 0) {
                        List list = ARGiftManager.this.waitForPlay;
                        synchronized (list) {
                            Iterator itr = ARGiftManager.this.waitForPlay.iterator();
                            while (itr.hasNext()) {
                                if (!((GiftStickerItem)itr.next()).equals((Object)item)) continue;
                                itr.remove();
                                ++howManyItemWaiting;
                            }
                        }
                    }
                    while (howManyItemWaiting-- > 0) {
                        ARGiftManager.this.showArGift(item);
                    }
                } else if (status != GiftStickerItem.GiftStickerStatus.DOWNLOADING) {
                    ARGiftManager.this.updateItemStatus(item);
                    ARGiftManager.this.downloadAndDecompressIfNeed(item, this);
                }
            }
        };
    }

    @MainThread
    public void onDispose() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            AndroidSchedulers.mainThread().scheduleDirect(new Runnable(){

                @Override
                public void run() {
                    ARGiftManager.this.onDispose();
                }
            });
            return;
        }
        this.mGiftStickerItems.clear();
        this.mQueueManager.destroy();
        this.waitForPlay.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void updateItemStatus(GiftStickerItem item) {
        GiftStickerItem giftStickerItem = item;
        synchronized (giftStickerItem) {
            String fileEffect;
            MLog.info((Object)TAG, (String)("updateItemStatus " + item), (Object[])new Object[0]);
            if (item.giftStickerStatus == GiftStickerItem.GiftStickerStatus.DECOMPRESSING || item.giftStickerStatus == GiftStickerItem.GiftStickerStatus.DOWNLOADING) {
                return;
            }
            boolean fileBroken = false;
            File stickerFileDir = new File(this.getOrMkdirStickerPath(), item.id);
            File[] resourceFiles = stickerFileDir.listFiles();
            if (!stickerFileDir.exists()) {
                MLog.info((Object)TAG, (String)("stickerFileDir is not exists. " + item), (Object[])new Object[0]);
                fileBroken = true;
            }
            if (resourceFiles == null) {
                MLog.info((Object)TAG, (String)("resourceFiles is not exists. " + item), (Object[])new Object[0]);
                fileBroken = true;
            }
            if (TextUtils.isEmpty((CharSequence)(fileEffect = this.getAREffectName(item)))) {
                MLog.info((Object)TAG, (String)("can not get file \".oeffect\" path. " + item), (Object[])new Object[0]);
                fileBroken = true;
            } else {
                File effectFile = new File(stickerFileDir, fileEffect);
                if (!effectFile.exists()) {
                    MLog.info((Object)TAG, (String)("file \".oeffect\" not found. " + item), (Object[])new Object[0]);
                    fileBroken = true;
                }
            }
            String verifyMd5 = this.getPreferenceResourceMd5(item);
            String cacheMd5 = this.cacheMd5(item);
            if (TextUtils.isEmpty((CharSequence)verifyMd5) || !verifyMd5.equals(cacheMd5)) {
                MLog.info((Object)TAG, (String)("Md5 verify failed. id = " + item.id + " verifyMd5 = " + verifyMd5 + " cacheMd5 = " + cacheMd5), (Object[])new Object[0]);
                fileBroken = true;
            }
            if (fileBroken) {
                FileUtil.delete((File)stickerFileDir);
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.UNDOWNLOAD;
            } else {
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.READY;
            }
        }
    }

    private void checkPathAndNoMedia() {
        File file = new File(this.getOrMkdirStickerPath(), NOMEDIA);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)("Face checkPathAndNoMedia error  " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void downloadStickerFile(@NonNull GiftStickerItem item, @NonNull ResponseListener<String> responseListener, @Nullable ResponseErrorListener errorListener, @Nullable ProgressListener progressListener) {
        File file = new File(this.getOrMkdirStickerPath(), item.filePath);
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        ResponseErrorListener emptyError = new ResponseErrorListener(){

            public void onErrorResponse(RequestError error) {
            }
        };
        ProgressListener emptyProgress = new ProgressListener(){

            public void onProgress(ProgressInfo info) {
            }
        };
        ResponseErrorListener error = errorListener != null ? errorListener : emptyError;
        ProgressListener progress = progressListener != null ? progressListener : emptyProgress;
        RequestManager.instance().submitDownloadRequest(item.url, file.getAbsolutePath(), responseListener, error, progress, false, false);
    }

    @MainThread
    private GiftStickerItem getGiftStickerItemByid(int type, int grade) {
        for (GiftStickerItem info : this.mGiftStickerItems) {
            if (info.type != type || grade != info.grade) continue;
            return info;
        }
        return null;
    }

    private void showArGift(GiftStickerItem info) {
        File itemDir = new File(this.getOrMkdirStickerPath(), info.id);
        Object[] files = itemDir.listFiles(new AREffectFilter());
        String effectName = this.getAREffectName(info);
        if (FP.empty((Object[])files) || FP.empty((CharSequence)effectName)) {
            return;
        }
        File effectFile = new File(itemDir, effectName);
        ArEntity entity = new ArEntity(effectFile, itemDir, info.grade);
        MLog.info((Object)TAG, (String)("show ar now: " + info), (Object[])new Object[0]);
        this.mQueueManager.add(entity);
    }

    private String getAREffectName(GiftStickerItem item) {
        File itemDir = new File(this.getOrMkdirStickerPath(), item.id);
        Object[] files = itemDir.listFiles(new AREffectFilter());
        if (FP.empty((Object[])files)) {
            return null;
        }
        return ((File)files[0]).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void decompress(GiftStickerItem item) {
        GiftStickerItem giftStickerItem = item;
        synchronized (giftStickerItem) {
            MLog.info((Object)TAG, (String)("decompressStickResource item = " + item), (Object[])new Object[0]);
            String zipPath = new File(this.getOrMkdirStickerPath(), item.id).getAbsolutePath();
            File zipFile = new File(this.getOrMkdirStickerPath(), item.filePath);
            if (item.giftStickerStatus == GiftStickerItem.GiftStickerStatus.DECOMPRESSING) {
                MLog.info((Object)TAG, (String)("already compressing: " + item), (Object[])new Object[0]);
                return;
            }
            if (item.giftStickerStatus == GiftStickerItem.GiftStickerStatus.READY) {
                MLog.info((Object)TAG, (String)("No need to decompress again: " + item), (Object[])new Object[0]);
                return;
            }
            if (!zipFile.exists()) {
                MLog.info((Object)TAG, (String)("method decompressStickResource ops. zip file not exists. " + item), (Object[])new Object[0]);
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.UNDOWNLOAD;
                return;
            }
            try {
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.DECOMPRESSING;
                FileUtil.unzip((File)zipFile, (String)zipPath, (String)"");
                String md5 = this.cacheMd5(item);
                this.setPreferenceResourceMd5(item, md5);
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.READY;
                MLog.info((Object)TAG, (String)("decompressStickResource done item = " + item + " md5 = " + md5), (Object[])new Object[0]);
            }
            catch (IOException e) {
                item.giftStickerStatus = GiftStickerItem.GiftStickerStatus.UNDOWNLOAD;
                MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
            }
            finally {
                zipFile.delete();
            }
        }
    }

    protected String cacheMd5(GiftStickerItem item) {
        try {
            Object[] resourceFiles = new File(this.getOrMkdirStickerPath(), item.id).listFiles();
            if (FP.empty((Object[])resourceFiles)) {
                return "";
            }
            return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    private String getPreferenceResourceMd5(GiftStickerItem item) {
        return this.mARGiftManagerPreferences.getString(this.getPreferenceResourceMd5Key(item), "");
    }

    private void setPreferenceResourceMd5(GiftStickerItem item, String md5) {
        this.mARGiftManagerPreferences.edit().putString(this.getPreferenceResourceMd5Key(item), md5).apply();
    }

    private String getPreferenceResourceMd5Key(GiftStickerItem item) {
        return PREFERENCE_KEY_RES_MD5_PRE_FIX + item.id;
    }

    static class AREffectFilter
    implements FileFilter {
        AREffectFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".ofeffect");
        }
    }
}

