package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftListUtil;

import org.json.JSONObject;

import java.util.List;

/**
 * Created by lhf on 2018/7/12.
 * <p>
 * YY.Inc
 */
public class GetPropsByAppIdResponse implements IBaseJsonResponse {

    private static final String TAG = "GetPropsByAppIdResponse";

    private String seq;
    private long uid;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明
    private String urlPrefix; //为了压缩返回内容，礼物图片及礼物特效图片会通过替换固定url前缀减少返回。如真实图片url=urlPrefix+staticIcon
    private int specialList; //礼物是否存在特定配置，针对当前频道、子频道、收礼人、送礼物人
    private String md5Version; //礼物列表的json串md5值
    private int usedChannel; //渠道id
    private int liveCategoryId; //直播品类，海外营收用
    private String compressData; //base64字符串，propsList转json串后，用gzip压缩
    private List<GiftInfo> propsList;
    private String expand; //扩展信息

    public GetPropsByAppIdResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            uid = response.optLong("uid", 0);
            result = response.optInt("result", -1);
            message = response.optString("message", "");
            urlPrefix = response.optString("urlPrefix", "");
            specialList = response.optInt("specialList", 0);
            md5Version = response.optString("md5Version", "");
            usedChannel = response.optInt("usedChannel", 0);
            liveCategoryId = response.optInt("liveCategoryId", 0);
            expand = response.optString("expand", "");
            if (result != 1) {
                RLog.debug(TAG, "[GetPropsByAppIdResponse]get prop list failed, result=%d" + String.valueOf(result));
            }
            // ---------- 礼物列表解析开始 --------------
            compressData = response.optString("compressData", "");
            propsList = GiftListUtil.parserGiftList(compressData, usedChannel, urlPrefix, liveCategoryId);
        } catch (Exception e) {
            RLog.error("GetPropsByAppIdResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public String getUrlPrefix() {
        return urlPrefix;
    }

    public int getSpecialList() {
        return specialList;
    }

    public String getMd5Version() {
        return md5Version;
    }

    public List<GiftInfo> getPropsList() {
        return propsList;
    }

    public int getUsedChannel() {
        return usedChannel;
    }

    public int getLiveCategoryId() {
        return liveCategoryId;
    }

    public String getCompressData() {
        return compressData;
    }

    public String getExpand() {
        return expand;
    }
}
