/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.RankInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RankEntranceResponse
implements IBaseJsonResponse {
    private String seq;
    private int result;
    private String message;
    private int cmd;
    private List<RankInfo> rankList;

    public RankEntranceResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            this.seq = response.optString("seq", "");
            this.result = response.optInt("result", 0);
            this.message = response.optString("message", "");
            this.cmd = response.optInt("cmd", 0);
            this.rankList = new ArrayList<RankInfo>();
            JSONArray rankArray = response.optJSONArray("ranks");
            if (rankArray != null && rankArray.length() > 0) {
                for (int i = 0; i < rankArray.length(); ++i) {
                    JSONObject rankItem = rankArray.optJSONObject(i);
                    if (rankItem == null) continue;
                    RankInfo rankInfo = new RankInfo();
                    rankInfo.uid = rankItem.optLong("uid", 0L);
                    rankInfo.value = rankItem.optLong("value", 0L);
                    rankInfo.rank = rankItem.optInt("rank", 0);
                    this.rankList.add(rankInfo);
                }
            }
        }
        catch (Exception e) {
            RLog.error((Object)"RankEntranceResponse", (String)"parserResponse error.", (Throwable)e);
        }
    }

    public String getSeq() {
        return this.seq;
    }

    public int getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public int getCmd() {
        return this.cmd;
    }

    public List<RankInfo> getRankList() {
        return this.rankList;
    }
}

