/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftListUtil;
import java.util.List;
import org.json.JSONObject;

public class GetPropsByAppIdResponse
implements IBaseJsonResponse {
    private static final String TAG = "GetPropsByAppIdResponse";
    private String seq;
    private long uid;
    private int result;
    private String message;
    private String urlPrefix;
    private int specialList;
    private String md5Version;
    private int usedChannel;
    private int liveCategoryId;
    private String compressData;
    private List<GiftInfo> propsList;
    private String expand;

    public GetPropsByAppIdResponse(String jsonMsg) {
        this.parserResponse(jsonMsg);
    }

    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            this.seq = response.optString("seq", "");
            this.uid = response.optLong("uid", 0L);
            this.result = response.optInt("result", -1);
            this.message = response.optString("message", "");
            this.urlPrefix = response.optString("urlPrefix", "");
            this.specialList = response.optInt("specialList", 0);
            this.md5Version = response.optString("md5Version", "");
            this.usedChannel = response.optInt("usedChannel", 0);
            this.liveCategoryId = response.optInt("liveCategoryId", 0);
            this.expand = response.optString("expand", "");
            if (this.result != 1) {
                RLog.debug((Object)TAG, (String)("[GetPropsByAppIdResponse]get prop list failed, result=%d" + String.valueOf(this.result)));
            }
            this.compressData = response.optString("compressData", "");
            this.propsList = GiftListUtil.parserGiftList(this.compressData, this.usedChannel, this.urlPrefix, this.liveCategoryId);
        }
        catch (Exception e) {
            RLog.error((Object)TAG, (String)"parserResponse error.", (Throwable)e);
        }
    }

    public String getSeq() {
        return this.seq;
    }

    public long getUid() {
        return this.uid;
    }

    public int getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public int getSpecialList() {
        return this.specialList;
    }

    public String getMd5Version() {
        return this.md5Version;
    }

    public List<GiftInfo> getPropsList() {
        return this.propsList;
    }

    public int getUsedChannel() {
        return this.usedChannel;
    }

    public int getLiveCategoryId() {
        return this.liveCategoryId;
    }

    public String getCompressData() {
        return this.compressData;
    }

    public String getExpand() {
        return this.expand;
    }
}

