package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.AccountCurrencyInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.AccountPeriodInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.UserProps;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lhf on 2018/7/12.
 * <p>
 * YY.Inc
 */
public class ToInfoResponse implements IBaseJsonResponse {

    private String seq;
    private long uid;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明
    private long minAmountLimit;
    private List<AccountCurrencyInfo> accountList; // 每用户会有0至3个账户，每个账户对应一种货币
    private List<UserProps> userPropsList;
    private List<AccountPeriodInfo> accountPeriodList;

    public ToInfoResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            uid = response.optLong("uid", 0);
            result = response.optInt("result", 0);
            message = response.optString("message", "");
            minAmountLimit = response.optLong("minAmountLimit", 0);
            accountList = new ArrayList<>();
            JSONArray accountArray = response.optJSONArray("accountList");
            if (accountArray != null && accountArray.length() > 0) {
                for (int i = 0; i < accountArray.length(); ++i) {
                    JSONObject accountItem = accountArray.optJSONObject(i);
                    if (accountItem != null) {
                        AccountCurrencyInfo currencyInfo = new AccountCurrencyInfo();
                        currencyInfo.currencyType = accountItem.optInt("currencyType", 0);
                        currencyInfo.amount = accountItem.optLong("amount", 0);
                        currencyInfo.freezed = accountItem.optLong("freezed", 0);
                        currencyInfo.accountFrozen = accountItem.optInt("accountFrozen", 0);
                        currencyInfo.expireAmount = accountItem.optInt("expireAmount", 0);
                        currencyInfo.expireDate = accountItem.optString("expireDate", "");
                        accountList.add(currencyInfo);
                    }
                }
            }
            userPropsList = new ArrayList<>();
            JSONArray userPropsArray = response.optJSONArray("userPropsList");
            if (userPropsArray != null && userPropsArray.length() > 0) {
                for (int i = 0; i < userPropsArray.length(); ++i) {
                    JSONObject userPropsObj = userPropsArray.optJSONObject(i);
                    if (userPropsObj != null) {
                        UserProps userProps = new UserProps();
                        userProps.appId = userPropsObj.optInt("appId", 0);
                        List<UserProps.PropsItem> propsItemList = new ArrayList<>();
                        JSONArray propsItemArray = userPropsObj.optJSONArray("userPropsList");
                        if (propsItemArray != null && propsItemArray.length() > 0) {
                            for (int j = 0; j < propsItemArray.length(); ++j) {
                                JSONObject propsItemObj = propsItemArray.optJSONObject(j);
                                if (propsItemObj != null) {
                                    UserProps.PropsItem propsItem = new UserProps.PropsItem();
                                    propsItem.propsId = propsItemObj.optInt("propsId", 0);
                                    propsItem.count = propsItemObj.optInt("count", 0);
                                    propsItem.expireCount = propsItemObj.optInt("expireCount", 0);
                                    propsItem.expireDate = propsItemObj.optString("expireDate");
                                    propsItemList.add(propsItem);
                                }
                            }
                        }
                        userProps.propsItemList = propsItemList;
                        userPropsList.add(userProps);
                    }
                }
            }
            accountPeriodList = new ArrayList<>();
            JSONArray accountPeriodArray = response.optJSONArray("accountPeriodList");
            if (accountPeriodArray != null && accountPeriodArray.length() > 0) {
                for (int i = 0; i < accountPeriodArray.length(); ++i) {
                    JSONObject json = accountPeriodArray.optJSONObject(i);
                    if (json != null) {
                        int currencyType = json.optInt("currencyType", 0);
                        int amount = json.optInt("amount", 0);
                        long startTime = json.optLong("startTime", 0);
                        long endTime = json.optLong("endTime", 0);
                        accountPeriodList.add(new AccountPeriodInfo(currencyType, amount, startTime, endTime));
                    }
                }
            }
        } catch (Exception e) {
            RLog.error("ToInfoResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public long getMinAmountLimit() {
        return minAmountLimit;
    }

    public List<AccountCurrencyInfo> getAccountList() {
        return accountList;
    }

    public List<UserProps> getUserPropsList() {
        return userPropsList;
    }

    public List<AccountPeriodInfo> getAccountPeriodList() {
        return accountPeriodList;
    }
}
