package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONObject;

/**
 * 贡献榜入口请求
 */
public class RankEntranceRequest extends BaseJsonRequest {

    private static final String TAG = "RankEntranceRequest";

//  # Requst
//    {
//        "cmd":1048,
//            "appId":$appId, // hamo：1801
//            "usedChannel":$usedChannel, //游戏模板（10000：web端，10001：IOS端，10002：安卓端）、
//            秀场模板（1850：web端，1851：IOS端，1852：安卓端，1853：PC端）、
//            语音模板（1858：web端，1859：IOS端，1860：安卓端，1861：PC端）
//            "code":$code,  //1、视频直播7天榜（包括游戏和秀场）：hamoWeekAnchorBoard；
//            2、语音直播7天榜：hamoAnchorWeeklyBoardForVoice；
//            3、视频直播总榜:hamoAnchorTotalBoard ；4、语音直播总榜:hamoVoiceAnchorTotalBoard
//            "rtype":$rtype, //排行榜类型，total：总榜，incr：增量榜，peek：峰值榜
//            "ctype":$ctype,   //排行统计周期，总榜：all; N天榜: days：周榜:week; 月榜:month; 小时榜:hours
//            "latest":true,   //是否查询最新排行信息.默认为false，该标识仅对日/周/月/近n天榜有效
//            "uid":$uidOrSid,   //1、视频直播（包括游戏和秀场）则传主播uid；2、语音直播则传sid
//            "size":$size,  //uid为空时，size字段必填； uid不为空时，size字段可不填（可传默认值0）
//            "timeParam":$timeParam,   // 最近 小时/日/周/月/近n天
//    }

    public String seq;
    public long uid;
    public int appId;
    public int usedChannel;
    public String code;
    public String rtype;
    public String ctype;
    public boolean latest;
    public int size;
    public int timeParam;
    public String ticket;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", ProtocolCmd.RankEntranceRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("code", code);
            jMsg.put("rtype", rtype);
            jMsg.put("ctype", ctype);
            jMsg.put("latest", latest);
            jMsg.put("size", size);
            jMsg.put("timeParam", timeParam);
            // jMsg.put("ticket", ticket); // data 不需要传递ticket，否则是service协议出错
            jsonMsg = jMsg.toString();
        } catch (Exception e) {
            RLog.error(TAG, "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest = new PSCIMessageRequest(ProtocolCmd.RankEntranceRequest, appId, 0,
                ticket, "", jsonMsg);
    }
}
