package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.ReceiveGiftAmountInfo;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhongjh on 2019/6/15.
 * <p>
 * YY.Inc
 *
 *
 * # Response
 * {
 *     "cmd":2006,
 *     "seq":"$seq",
 *     "uid":$uid,
 *     "result":$result,           // 业务错误码：-1、-3、-4、-5, -10
 *     "message":$message,           // 业务返回码信息说明
 *
 *     "appId":$appId,
 *     "anchorUid":$anchorUid    // 主播uid（hello业务为要查询的用户uid）
 *     "recvPropsList":[     // 收到的道具列表
 *         {
 *           "propsId":1,      // 道具id
 *           "count":20,       // 数量
 *           "propName":"",      // 名称
 *           "iconUrl":"",      // 图片
 *           "priority":""      // 排列优先级
 *           "tagBgImgUrl":""  //寻欢角标图片
 *           "tagName":""      //寻欢角标上文案
 *         },
 *         { ... }
 *     ]
 * }
 *
 */
public class GetUserReceivePropsAmountResponse implements IBaseJsonResponse {

    private String seq;
    private long uid;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明
    private int appId;
    private int anchorUid;
    private int usedChannel;
    private List<ReceiveGiftAmountInfo> recvPropsList;

    public GetUserReceivePropsAmountResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            uid = response.optLong("uid", 0);
            result = response.optInt("result", 0);
            message = response.optString("message", "");
            appId = response.optInt("appId", 0);
            usedChannel = response.optInt("usedChannel", 0);
            recvPropsList = new ArrayList<>();
            JSONArray propsItemArray = response.optJSONArray("recvPropsList");
            if (propsItemArray != null && propsItemArray.length() > 0) {
                for (int j = 0; j < propsItemArray.length(); ++j) {
                    JSONObject propsItemObj = propsItemArray.optJSONObject(j);
                    if (propsItemObj != null) {
                        ReceiveGiftAmountInfo propsItem = new ReceiveGiftAmountInfo();
                        propsItem.propsId = propsItemObj.optInt("propsId", 0);
                        propsItem.count = propsItemObj.optInt("count", 0);
                        propsItem.propName = propsItemObj.optString("propName", "");
                        propsItem.iconUrl = propsItemObj.optString("iconUrl", "");
                        propsItem.priority = propsItemObj.optString("priority", "");
                        propsItem.tagBgImgUrl = propsItemObj.optString("tagBgImgUrl", "");
                        propsItem.tagName = propsItemObj.optString("tagName", "");
                        recvPropsList.add(propsItem);
                    }
                }
            }
        } catch (Exception e) {
            RLog.error("", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public int getAppId() {
        return appId;
    }

    public int getAnchorUid() {
        return anchorUid;
    }

    public int getUsedChannel() {
        return usedChannel;
    }

    public List<ReceiveGiftAmountInfo> getRecvPropsList() {
        return recvPropsList;
    }
}
