package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONObject;

/**
 * Created by zhongjh on 2019/6/15.
 * <p>
 * YY.Inc
 */
public class GetUserReceivePropsAmountRequest extends BaseJsonRequest {

    private static final String TAG = "GetUserReceivePropsAmountRequest";

// # Request
//     {
//         "cmd":1006,
//             "seq":"$seq",   // 选传
//             "ticket":"$ticket"    // 不需验证，选传
//         "uid":$uid,
//             "sid":$sid,
//             "ssid":$ssid,
//             "appId":$appId,   // 业务id，分配而得，必传
//             "usedChannel":$usedChannel,   // 渠道id，分配而得，不传
//             "ip":$ip,   // ip地址，选传
//
//             "anchorUid":$anchorUid    // 主播uid（hello业务为要查询的用户uid）
//     }

    public String seq;
    public long uid;
    public long sid;
    public long ssid;
    public int appId;
    public int usedChannel;
    public long anchorUid;
    public String ticket;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", ProtocolCmd.ConsumeUserReceivePropsAmountRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("ssid", ssid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("anchorUid", anchorUid);
            // jMsg.put("ticket", ticket); // data 不需要传递ticket，否则是service协议出错
            jsonMsg = jMsg.toString();
        } catch (Exception e) {
            RLog.error(TAG, "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest =
                new PSCIMessageRequest(ProtocolCmd.ConsumeUserReceivePropsAmountRequest, appId, 0,
                        ticket, "", jsonMsg);
    }
}
