package com.yy.mobile.framework.revenuesdk.gift.bean;

import org.json.JSONObject;

import java.util.List;

/**
 * Created by lhf on 2018/7/10.
 * <p>
 * YY.Inc
 */
public class GiftInfo {

    public int propsId; //道具ID
    public String name; //道具名称
    public int type; //类型？
    public int appId; //appId
    public int usedChannel; //渠道id
    public boolean visible; //是否在礼物栏显示
    public boolean usable; // 道具是否可用
    public List<Pricing> pricingList; //价格列表,一般都只有1个货币定价 ，但不排除有多个，如交友的爱心
    public String staticIcon; //礼物icon静态图片
    public String description; //礼物描述
    public String priority; //礼物栏展示优先级，按ascii表排序
    public String urlPrefix; //为了压缩返回内容，礼物图片及礼物特效图片会通过替换固定url前缀减少返回。如真实图片url=urlPrefix+staticIcon
    public JSONObject desc; //desc里的字段都可以根据业务需求自定义,这里后面有扩展业务可以自己去拿数据
    public JSONObject expand; //扩展数据，业务自己去拿
    public int count; // 道具数量
    public int expireCount; // 当天过期道具数量
    public int liveCategoryId; //直播品类，海外营收用
    public List<Number> numberList; //送礼数量配
    public List<Effect> effectList; // 流光等级配置
    public String usetype; // 未知用途

    public static class Pricing {
        public long currencyAmount; // 价格
        public int currencyType; // 货币类型
        public long revenueAmount; //礼物分成字段
        // 这个字段一般不返回，只有当用户有特殊身份时可使用的道具价格跟普通身份不一样，才会返回
        // userTypeLimit跟服务器协商；一般只处理userTypeLimit为-1，则表示价格不可用的情况即可
        public int userTypeLimit;
    }

    public static class Number {
        public int number; // 数量
        public String priority; // 优先级,按ascii表排序
        public String desc; // 描述
    }

    public static class Effect {
        public int level; // 流光等级
        public int value; // 送礼价值阈值
        public boolean large; // 是否大礼物
        public String image; // 流光背景url
        public String effectUrls; // 扩展字段
        public long displayTime; // 流光展示时间
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        } else if (this == obj) {
            return true;
        } else if (getClass() != obj.getClass()) {
            return false;
        } else {
            GiftInfo other = (GiftInfo) obj;
            return this.propsId == other.propsId;
        }
    }
}