/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift.util;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBroInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboFinishInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.MultiGiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BroadcastMsgParser {
    public static GiftBroInfo parseGiftBroInfo(JSONObject data) {
        GiftBroInfo giftBroInfo = new GiftBroInfo();
        giftBroInfo.propsId = data.optInt("props_id", 0);
        giftBroInfo.count = data.optInt("props_count", 0);
        giftBroInfo.usedChannel = data.optInt("used_channel", 0);
        giftBroInfo.senderuid = data.optLong("uid", 0L);
        giftBroInfo.sendernickname = data.optString("user_nick_name", "");
        giftBroInfo.recveruid = data.optLong("recv_uid", 0L);
        giftBroInfo.recvernickname = data.optString("recv_nick_name", "");
        giftBroInfo.realRecveruid = data.optLong("real_recv_uid", 0L);
        giftBroInfo.realRecvernickname = data.optString("real_recv_nick_name", "");
        giftBroInfo.business_type = data.optInt("business_type", 0);
        giftBroInfo.expend = data.optString("expand", "");
        giftBroInfo.props_currency_amount = data.optLong("props_currency_amount", 0L);
        giftBroInfo.used_time = data.optLong("used_time", 0L);
        try {
            JSONObject expend = new JSONObject(giftBroInfo.expend);
            GiftComboInfo comboInfo = new GiftComboInfo();
            JSONObject combo = expend.optJSONObject("comboInfo");
            if (combo != null) {
                comboInfo.comboHits = combo.optLong("comboHits", 0L);
                comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                comboInfo.intervalTime = combo.optLong("intervalTime", 0L);
            }
            giftBroInfo.giftComboInfo = comboInfo;
        }
        catch (JSONException e) {
            RLog.error((Object)"parseGiftBroInfo", (String)"parse expend error.", (Throwable)e);
        }
        return giftBroInfo;
    }

    public static GiftComboFinishInfo parseGiftComboFinishInfo(JSONObject data) {
        GiftComboFinishInfo comboFinishInfo = new GiftComboFinishInfo();
        comboFinishInfo.propsId = data.optInt("props_id", 0);
        comboFinishInfo.count = data.optInt("props_count", 0);
        comboFinishInfo.usedChannel = data.optInt("used_channel", 0);
        comboFinishInfo.senderuid = data.optLong("uid", 0L);
        comboFinishInfo.sendernickname = data.optString("user_nick_name", "");
        comboFinishInfo.recveruid = data.optLong("recv_uid", 0L);
        comboFinishInfo.recvernickname = data.optString("recv_nick_name", "");
        comboFinishInfo.business_type = data.optInt("business_type", 0);
        comboFinishInfo.expend = data.optString("expand", "");
        try {
            JSONObject expend = new JSONObject(comboFinishInfo.expend);
            GiftComboInfo comboInfo = new GiftComboInfo();
            JSONObject combo = expend.optJSONObject("comboInfo");
            if (combo != null) {
                comboInfo.comboHits = combo.optLong("comboHits", 0L);
                comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                comboInfo.intervalTime = combo.optLong("intervalTime", 0L);
            }
            comboFinishInfo.giftComboInfo = comboInfo;
        }
        catch (JSONException e) {
            RLog.error((Object)"parseGiftComboFinishInfo", (String)"parse expend error.", (Throwable)e);
        }
        return comboFinishInfo;
    }

    public static MultiGiftInfo parseMultiGiftInfo(JSONObject resp) {
        MultiGiftInfo multiGiftInfo = new MultiGiftInfo();
        try {
            JSONArray receiver;
            multiGiftInfo.seq = resp.optString("seq", "");
            multiGiftInfo.uid = resp.optLong("uid", 0L);
            multiGiftInfo.usedChannel = resp.optInt("usedChannel", -1);
            multiGiftInfo.result = resp.optInt("result", -1);
            multiGiftInfo.message = resp.optString("message", "");
            multiGiftInfo.propsId = resp.optInt("props_id", 0);
            multiGiftInfo.count = resp.optInt("props_count", 0);
            multiGiftInfo.appId = resp.optInt("app_id", 0);
            JSONObject sender = resp.optJSONObject("senderUserInfo");
            if (sender != null) {
                multiGiftInfo.senderUid = sender.optLong("uid", 0L);
                multiGiftInfo.sendernickname = sender.optString("nickName", "");
            }
            if ((receiver = resp.optJSONArray("recverUserInfos")) != null) {
                for (int i = 0; i < receiver.length(); ++i) {
                    JSONObject temp = receiver.optJSONObject(i);
                    SendGiftParamV2.TargetUser target = new SendGiftParamV2.TargetUser(temp.optLong("uid"));
                    target.yyNum = temp.optString("yyno", "");
                    target.nickName = temp.optString("nickName", "");
                    multiGiftInfo.targetUsers.add(target);
                }
            }
            multiGiftInfo.expend = resp.optString("expand", "");
            try {
                JSONObject expend = new JSONObject(multiGiftInfo.expend);
                GiftComboInfo comboInfo = new GiftComboInfo();
                JSONObject combo = expend.optJSONObject("comboInfo");
                if (combo != null) {
                    comboInfo.comboHits = combo.optLong("comboHits", 0L);
                    comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                    comboInfo.intervalTime = combo.optLong("intervalTime", 0L);
                }
                multiGiftInfo.giftComboInfo = comboInfo;
            }
            catch (JSONException e) {
                RLog.error((Object)"parseGiftBroInfo", (String)"parse expend error.", (Throwable)e);
            }
            multiGiftInfo.confirmUrl = resp.optString("confirmUrl", "");
        }
        catch (Exception e) {
            RLog.error((Object)"parseMultiGiftInfo", (String)"parserResponse error.", (Throwable)e);
        }
        return multiGiftInfo;
    }
}

