/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataReceiver;
import com.yy.mobile.framework.revenuesdk.baseapi.data.IRevenueDataSender;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageBroadcast;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageResponse;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageUnicast;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.HiidoReport;
import com.yy.mobile.framework.revenuesdk.baseapi.reporter.IReporter;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.SeqUtil;
import com.yy.mobile.framework.revenuesdk.gift.CallbackMode;
import com.yy.mobile.framework.revenuesdk.gift.GiftCache;
import com.yy.mobile.framework.revenuesdk.gift.IGiftEventCallback;
import com.yy.mobile.framework.revenuesdk.gift.IGiftRequestCallback;
import com.yy.mobile.framework.revenuesdk.gift.IGiftService;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAcquireMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAddMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBroInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboFinishInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.MultiGiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.PackageWalletUpdateMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.SendGiftResInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.UserProps;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.GetGiftBagInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadAllGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadPackageGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.LoadReceiveGiftAmountResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.QueryCouponStoreResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.RankEntranceResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.SendGiftResult;
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.ToInfoResult;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetGiftBagRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetGiftBagResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetPropsByAppIdRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetPropsByAppIdResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserCouponStoreRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserCouponStoreResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserPropsRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserPropsResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserReceivePropsAmountRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.GetUserReceivePropsAmountResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.RankEntranceRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.RankEntranceResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.SendGiftToMultiUserRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.SendGiftToMultiUserResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.ToInfoRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.ToInfoResponse;
import com.yy.mobile.framework.revenuesdk.gift.protocol.UseItemRequest;
import com.yy.mobile.framework.revenuesdk.gift.protocol.UseItemResponse;
import com.yy.mobile.framework.revenuesdk.gift.reporter.DefaultGiftReporter;
import com.yy.mobile.framework.revenuesdk.gift.reporter.IGiftReporter;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetGiftBagParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.GetToInfoParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadAllGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadPackageGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.LoadReceiveGiftAmountParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.QueryCouponStoreParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.RankEntranceParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParam;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;
import com.yy.mobile.framework.revenuesdk.gift.util.BroadcastMsgParser;
import com.yy.mobile.framework.revenuesdk.gift.util.UnicastMsgParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class GiftServiceImpl
implements IGiftService,
IRevenueDataReceiver {
    private static final String TAG = "GiftServiceImpl";
    private int mAppId;
    private int mUsedChannel;
    private int currentUsedchannel;
    private Context mContext;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private Handler workHandler;
    private IRevenueDataSender iDataSender;
    private IGiftReporter iGiftReporter;
    private String mCountryCode;
    private String mDefalutServiceName;
    private String mDefalutFunctionName;
    private GiftCache mGiftCache;
    private int retryCount = 0;
    private Map<String, Pair<Integer, Integer>> loadGiftParamMap = new HashMap<String, Pair<Integer, Integer>>();
    private List<IGiftEventCallback> giftCallbackList = new ArrayList<IGiftEventCallback>();

    public GiftServiceImpl(int appId, int usedChannel, String country, String clientVer, String serviceName, String functionName, boolean requestReuse, IRevenueDataSender iDataSender, Context context, IReporter iReporter) {
        this.mAppId = appId;
        this.mUsedChannel = usedChannel;
        this.mContext = context;
        this.mCountryCode = country;
        this.mDefalutServiceName = serviceName;
        this.mDefalutFunctionName = functionName;
        HandlerThread workThread = new HandlerThread("Revenue_GiftServiceImpl");
        workThread.start();
        this.workHandler = new Handler(workThread.getLooper());
        this.mGiftCache = new GiftCache(appId, this.mContext, this.workHandler, usedChannel);
        this.iGiftReporter = new DefaultGiftReporter(iReporter, clientVer, country);
        this.iDataSender = iDataSender;
    }

    @Override
    public void loadAllGift(@NonNull LoadAllGiftParam param, @NonNull IGiftRequestCallback<LoadAllGiftResult> callback, boolean forceUpdate) {
        int channelId;
        RLog.info((Object)TAG, (String)"loadAllGift: appId = %d, usedChannel = %d, uid = %d, liveCategoryId = %d, ticket = %d", (Object[])new Object[]{param.appId, param.channelId, param.uid, param.liveCategoryId, param.ticket});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        List<GiftInfo> giftInfos = this.mGiftCache.getGiftList(channelId, param.liveCategoryId);
        if (forceUpdate || giftInfos == null || giftInfos.isEmpty()) {
            GetPropsByAppIdRequest request = new GetPropsByAppIdRequest();
            request.seq = SeqUtil.increaseSeqId();
            request.uid = param.uid;
            request.appId = appId;
            request.usedChannel = channelId;
            request.sid = param.sid;
            request.ssid = param.ssid;
            request.recvUid = param.recvUid;
            request.filterPropsTypes = param.filterPropsTypes;
            request.countryCode = param.countryCode;
            request.liveCategoryId = param.liveCategoryId;
            request.lastMd5Hash = this.mGiftCache.getLastMd5Hash(channelId, param.liveCategoryId);
            if (forceUpdate) {
                request.lastMd5Hash = "";
            }
            request.clientVersion = param.clientVersion;
            request.ticket = param.ticket;
            this.sendRequest(request.seq, request, param.retry, callback);
            this.loadGiftParamMap.put(request.seq, (Pair<Integer, Integer>)new Pair((Object)request.usedChannel, (Object)request.liveCategoryId));
        } else {
            LoadAllGiftResult result = new LoadAllGiftResult();
            result.appId = this.mAppId;
            result.channelId = this.mUsedChannel;
            result.giftList = giftInfos;
            callback.onSuccess(result);
        }
    }

    @Override
    public void loadPackageGift(@NonNull LoadPackageGiftParam param, @NonNull IGiftRequestCallback<LoadPackageGiftResult> callback) {
        int channelId;
        RLog.info((Object)TAG, (String)"loadPackageGift: appId = %d, usedChannel = %d, uid = %d", (Object[])new Object[]{param.appId, param.channelId, param.uid});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        GetUserPropsRequest request = new GetUserPropsRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.ticket = param.ticket;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void loadReceiveGiftAmount(@NonNull LoadReceiveGiftAmountParam param, @NonNull IGiftRequestCallback<LoadReceiveGiftAmountResult> callback) {
        int channelId;
        RLog.info((Object)TAG, (String)"loadReceiveGiftAmount: appId = %d, usedChannel = %d, uid = %d", (Object[])new Object[]{param.appId, param.channelId, param.uid});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        GetUserReceivePropsAmountRequest request = new GetUserReceivePropsAmountRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.anchorUid = param.anchorUid;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void sendGiftToUser(@NonNull SendGiftParam param, @NonNull IGiftRequestCallback<SendGiftResult> callback) {
        RLog.info((Object)TAG, (String)"loadPackageGift: appId = %d, usedChannel = %d, senderUid = %d, reciverUid = %d", (Object[])new Object[]{this.mAppId, this.mUsedChannel, param.senderuid, param.recveruid});
        this.sendUseItemRequest(param, callback);
    }

    @Override
    public void sendGiftToMultiUser(@NonNull SendGiftParamV2 param, @NonNull IGiftRequestCallback<SendGiftResult> callback) {
        String seq;
        int channelId;
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        SendGiftToMultiUserRequest request = new SendGiftToMultiUserRequest();
        request.seq = seq = SeqUtil.increaseSeqId();
        request.uid = param.senderuid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.propsId = param.propsId;
        request.count = param.count;
        request.senderUid = param.senderuid;
        request.sendernickname = param.sendernickname;
        request.expend = param.expand;
        request.isAutoBuy = param.isAutoBuy;
        request.payGateOrderId = param.payGateOrderId;
        request.payWay = param.payWay;
        request.payAdditionInfo = param.payAdditionInfo;
        request.targetUsers = param.targetUsers;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getToInfo(@NonNull GetToInfoParam param, @NonNull IGiftRequestCallback<ToInfoResult> callback) {
        int channelId;
        RLog.info((Object)TAG, (String)"getToInfo: appId = %d, usedChannel = %d, uid = %d", (Object[])new Object[]{this.mAppId, this.mUsedChannel, param.uid});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        ToInfoRequest request = new ToInfoRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getRankEntranceInfo(@NonNull RankEntranceParam param, @NonNull IGiftRequestCallback<RankEntranceResult> callback) {
        int channelId;
        RLog.info((Object)TAG, (String)"getRankEntranceInfo: appId = %d, usedChannel = %d, uid = %d", (Object[])new Object[]{this.mAppId, this.mUsedChannel, param.uid});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        RankEntranceRequest request = new RankEntranceRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.uid = param.uid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.code = param.code;
        request.rtype = param.rtype;
        request.ctype = param.ctype;
        request.latest = param.latest;
        request.size = param.size;
        request.timeParam = param.timeParam;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void getGiftBagInfo(@NonNull GetGiftBagParam param, @NonNull IGiftRequestCallback<GetGiftBagInfoResult> callback) {
        int channelId;
        RLog.info((Object)TAG, (String)"getGiftBagInfo: appId = %d, usedChannel = %d", (Object[])new Object[]{this.mAppId, this.mUsedChannel});
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.usedChannel) == 0) {
            channelId = this.mUsedChannel;
        }
        GetGiftBagRequest request = new GetGiftBagRequest();
        request.seq = SeqUtil.increaseSeqId();
        request.appId = appId;
        request.uid = param.uid;
        request.usedChannel = channelId;
        request.giftPropId = param.giftPropId;
        request.currencyType = param.currencyType;
        request.actId = param.actId;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    @Override
    public void queryUserCouponStore(@NonNull QueryCouponStoreParam param, @NonNull IGiftRequestCallback<QueryCouponStoreResult> callback) {
        RLog.info((Object)TAG, (String)"queryUserCouponStore: appId = %d, usedChannel = %d", (Object[])new Object[]{this.mAppId, this.mUsedChannel});
        String seq = SeqUtil.increaseSeqId();
        GetUserCouponStoreRequest request = new GetUserCouponStoreRequest(param);
        param.setSeq(seq);
        this.sendRequest(seq, request, null, callback);
    }

    @Override
    public List<GiftInfo> getAllGift(int usedChannel) {
        return this.getAllGift(usedChannel, 0);
    }

    @Override
    public List<GiftInfo> getAllGift(int usedChannel, int liveCategoryId) {
        return this.mGiftCache.getGiftList(usedChannel, liveCategoryId);
    }

    @Override
    public List<GiftInfo> getAllChannelGift() {
        return new ArrayList<GiftInfo>();
    }

    @Override
    public GiftInfo findGiftById(int propsId) {
        return this.mGiftCache.findGiftById(propsId);
    }

    @Override
    public GiftInfo findGiftById(int propsId, int usedChannel) {
        return this.mGiftCache.findGiftById(propsId, usedChannel);
    }

    @Override
    public void setCurrentUsedChannel(int usedChannel) {
        this.currentUsedchannel = usedChannel;
    }

    @Override
    public void addGiftEventCallback(@NonNull IGiftEventCallback giftCallback) {
        if (!this.giftCallbackList.contains(giftCallback)) {
            this.giftCallbackList.add(giftCallback);
        }
    }

    @Override
    public void removeGiftEventCallback(@NonNull IGiftEventCallback giftCallback) {
        if (this.giftCallbackList.contains(giftCallback)) {
            this.giftCallbackList.remove(giftCallback);
        }
    }

    @Override
    public void registerGiftReporter(IGiftReporter iGiftReporter) {
        this.iGiftReporter = iGiftReporter;
    }

    @Override
    public void clearAllGiftCache() {
        this.mGiftCache.clearAllGiftCache();
    }

    @Override
    public void clearGiftCacheByChannelAndCategoryId(int usedChannel, int liveCategoryId) {
        this.mGiftCache.clearGiftCacheByChannelAndCategoryId(usedChannel, liveCategoryId);
    }

    @Override
    public void setCountryCode(String countryCode) {
        this.mCountryCode = countryCode;
    }

    private void sendRequest(String seq, BaseJsonRequest request, ArrayList<Integer> retry, IGiftRequestCallback callback) {
        if (this.iDataSender != null) {
            this.iDataSender.sendData(this.mAppId, seq, retry, request.marshall());
            if (callback != null) {
                CallbackMode.getInstance().registerCallback(seq, callback);
            }
        }
    }

    private void onGetPropsByAppIdResp(GetPropsByAppIdResponse responseData) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = responseData.getUid();
        Pair<Integer, Integer> reqParam = this.loadGiftParamMap.remove(responseData.getSeq());
        if (responseData.getResult() == 1) {
            List<GiftInfo> giftInfos = this.mGiftCache.getGiftList(responseData.getUsedChannel(), responseData.getLiveCategoryId());
            if ("".equals(responseData.getCompressData())) {
                RLog.info((Object)TAG, (String)"onGetPropsByAppIdResp : md5Hash not change");
            } else {
                giftInfos = responseData.getPropsList();
                this.mGiftCache.updateGiftList(responseData.getUsedChannel(), responseData.getLiveCategoryId(), responseData.getPropsList(), responseData.getUrlPrefix(), responseData.getCompressData(), giftInfos.isEmpty() ? "" : responseData.getMd5Version());
            }
            if (giftInfos == null) {
                giftInfos = new ArrayList<GiftInfo>();
            }
            LoadAllGiftResult result = new LoadAllGiftResult();
            result.appId = this.mAppId;
            result.channelId = responseData.getUsedChannel();
            result.giftList = giftInfos;
            result.expand = responseData.getExpand();
            CallbackMode.getInstance().onCallbackSuccess(responseData.getSeq(), result);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "34";
                reportResponse.mEventaliae = "\u62c9\u53d6\u6240\u6709\u793c\u7269\u6210\u529f";
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                this.iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
        } else {
            if (reqParam != null) {
                this.mGiftCache.loadGiftListFromCache((Integer)reqParam.first, (Integer)reqParam.second);
            }
            CallbackMode.getInstance().onCallbackFail(responseData.getSeq(), responseData.getResult(), responseData.getMessage());
            RLog.error((Object)TAG, (String)"GetPropsByAppIdResp fail reason = %s", (Object[])new Object[]{responseData.getMessage()});
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "35";
                reportResponse.mEventaliae = "\u62c9\u53d6\u6240\u6709\u793c\u7269\u5931\u8d25";
                reportResponse.mErrCode = responseData.getResult() + "";
                reportResponse.mErrMsg = responseData.getMessage();
                this.iGiftReporter.onLoadAllGiftResault(reportResponse);
            }
        }
    }

    private void onToInfoResponse(ToInfoResponse toInfoResponse) {
        if (toInfoResponse.getResult() == 1) {
            ToInfoResult result = new ToInfoResult(toInfoResponse.getAccountList(), toInfoResponse.getUserPropsList(), toInfoResponse.getAccountPeriodList(), toInfoResponse.getMinAmountLimit());
            CallbackMode.getInstance().onCallbackSuccess(toInfoResponse.getSeq(), result);
        } else {
            RLog.error((Object)TAG, (String)"onToInfoResponse fail reason = %s", (Object[])new Object[]{toInfoResponse.getMessage()});
            CallbackMode.getInstance().onCallbackFail(toInfoResponse.getSeq(), toInfoResponse.getResult(), toInfoResponse.getMessage());
        }
    }

    private void onGetUserPropsResponse(GetUserPropsResponse res) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = res.getUid();
        if (res.getResult() == 1) {
            RLog.info((Object)TAG, (String)"onGetUserPropsResponse: uid = %d, appId = %d, usedChannel = %d", (Object[])new Object[]{res.getUid(), res.getAppId(), res.getUsedChannel()});
            ArrayList<GiftInfo> packageGiftList = new ArrayList<GiftInfo>();
            if (res.getUserProps().propsItemList != null) {
                for (UserProps.PropsItem propsItem : res.getUserProps().propsItemList) {
                    GiftInfo giftInfo = this.findGiftById(propsItem.propsId, res.getUsedChannel());
                    if (giftInfo == null) continue;
                    giftInfo.count = propsItem.count;
                    giftInfo.expireCount = propsItem.expireCount;
                    packageGiftList.add(giftInfo);
                }
            }
            LoadPackageGiftResult result = new LoadPackageGiftResult();
            result.appId = this.mAppId;
            result.channelId = this.mUsedChannel;
            result.packageGiftList = packageGiftList;
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "36";
                reportResponse.mEventaliae = "\u62c9\u53d6\u5305\u88f9\u793c\u7269\u6210\u529f";
                reportResponse.mErrCode = res.getResult() + "";
                reportResponse.mErrMsg = res.getMessage();
                this.iGiftReporter.onLoadPackageGiftResault(reportResponse);
            }
        } else {
            RLog.error((Object)TAG, (String)"onGetUserPropsResponse fail reason = %s", (Object[])new Object[]{res.getMessage()});
            CallbackMode.getInstance().onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "37";
                reportResponse.mEventaliae = "\u62c9\u53d6\u5305\u88f9\u793c\u7269\u5931\u8d25";
                reportResponse.mErrCode = res.getResult() + "";
                reportResponse.mErrMsg = res.getMessage();
                this.iGiftReporter.onLoadPackageGiftResault(reportResponse);
            }
        }
    }

    private void onRankEntranceResponse(RankEntranceResponse res) {
        if (res.getResult() == 1) {
            RLog.info((Object)TAG, (String)"onRankEntranceResponse success");
            RankEntranceResult result = new RankEntranceResult(res.getRankList());
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error((Object)TAG, (String)"onGetUserPropsResponse fail reason = %s", (Object[])new Object[]{res.getMessage()});
            CallbackMode.getInstance().onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    private void onGetGiftBagResponse(GetGiftBagResponse res) {
        if (res.getResult() == 1) {
            RLog.info((Object)TAG, (String)"onGetGiftBagResponse success");
            GetGiftBagInfoResult result = new GetGiftBagInfoResult();
            result.firstCharge = res.getFirstCharge();
            result.hasBuy = res.getHasBuy();
            result.purchasedNum = res.getPurchasedNum();
            result.giftBags = res.getGiftBags();
            result.beginTime = res.getBeginTime();
            result.endTime = res.getEndTime();
            result.currentActivityConf = res.getCurrentActivityConf();
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error((Object)TAG, (String)"onGetGiftBagResponse fail reason = %s", (Object[])new Object[]{res.getMessage()});
            CallbackMode.getInstance().onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    private void onSendGiftToMultiUserResponse(SendGiftToMultiUserResponse response) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = response.getUid();
        String seq = response.getSeq();
        int code = response.getResult();
        String message = response.getMessage();
        SendGiftResInfo sendGiftResInfo = new SendGiftResInfo();
        sendGiftResInfo.propsId = response.getPropsId();
        sendGiftResInfo.count = response.getCount();
        sendGiftResInfo.appId = response.getAppId();
        sendGiftResInfo.senderuid = response.getSenderUid();
        sendGiftResInfo.sendernickname = response.getSendernickname();
        sendGiftResInfo.expend = response.getExpend();
        sendGiftResInfo.confirmUrl = response.getConfirmUrl();
        if (code == 1 || code == -10) {
            SendGiftResult result = new SendGiftResult();
            result.appId = this.mAppId;
            result.channelId = this.mUsedChannel;
            result.resInfo = sendGiftResInfo;
            CallbackMode.getInstance().onCallbackSuccess(seq, result);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "32";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u591a\u4e2a\u7528\u6237\u6210\u529f";
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                this.iGiftReporter.onSendGiftToMultiUserResault(reportResponse);
                reportResponse.mEventId = "202";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u591a\u4eba\u6210\u529f";
                this.iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        } else {
            CallbackMode.getInstance().onCallbackFail(seq, code, message);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "33";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u591a\u4e2a\u7528\u6237\u5931\u8d25";
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                this.iGiftReporter.onSendGiftToMultiUserResault(reportResponse);
                reportResponse.mEventId = "203";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u591a\u4eba\u6210\u529f";
                this.iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        }
    }

    private void onGetUserReceivePropsAmountResponse(GetUserReceivePropsAmountResponse res) {
        if (res.getResult() == 1) {
            RLog.info((Object)TAG, (String)"onGetUserReceivePropsAmountResponse: uid = %d, appId = %d, usedChannel = %d", (Object[])new Object[]{res.getUid(), res.getAppId(), res.getUsedChannel()});
            LoadReceiveGiftAmountResult result = new LoadReceiveGiftAmountResult();
            result.appId = this.mAppId;
            result.channelId = this.mUsedChannel;
            result.giftList = res.getRecvPropsList();
            CallbackMode.getInstance().onCallbackSuccess(res.getSeq(), result);
        } else {
            RLog.error((Object)TAG, (String)"onGetUserReceivePropsAmountResponse fail reason = %s", (Object[])new Object[]{res.getMessage()});
            CallbackMode.getInstance().onCallbackFail(res.getSeq(), res.getResult(), res.getMessage());
        }
    }

    private void onGetUserCouponStoreResponse(GetUserCouponStoreResponse rsp) {
        RLog.info((Object)TAG, (String)"onGetUserCouponStoreResponse: uid = %d, appId = %d, result = %d, message = %s", (Object[])new Object[]{rsp.getUid(), rsp.getAppId(), rsp.getResult(), rsp.getMessage()});
        if (rsp.isSuccess()) {
            CallbackMode.getInstance().onCallbackSuccess(rsp.getSeq(), rsp.getRspResult());
        } else {
            CallbackMode.getInstance().onCallbackFail(rsp.getSeq(), rsp.getResult(), rsp.getMessage());
        }
    }

    private void sendUseItemRequest(SendGiftParam param, IGiftRequestCallback<SendGiftResult> callback) {
        String seq;
        int channelId;
        int appId = param.appId;
        if (appId == 0) {
            appId = this.mAppId;
        }
        if ((channelId = param.channelId) == 0) {
            channelId = this.mUsedChannel;
        }
        this.retryCount = 3;
        UseItemRequest request = new UseItemRequest();
        request.seq = seq = SeqUtil.increaseSeqId();
        request.uid = param.senderuid;
        request.sid = param.sid;
        request.ssid = param.ssid;
        request.appId = appId;
        request.usedChannel = channelId;
        request.propsId = param.propsId;
        request.count = param.count;
        request.senderUid = param.senderuid;
        request.sendernickname = param.sendernickname;
        request.recveruid = param.recveruid;
        request.recvernickname = param.recvernickname;
        request.realRecveruid = param.realRecveruid;
        request.realRecvernickname = param.realRecvernickname;
        request.anchorUid = param.recveruid;
        request.expend = param.expand;
        request.isAutoBuy = param.isAutoBuy;
        request.payGateOrderId = param.payGateOrderId;
        request.payWay = param.payWay;
        request.payAdditionInfo = param.payAdditionInfo;
        this.sendRequest(request.seq, request, param.retry, callback);
    }

    private void onUseItemResponse(UseItemResponse useItemResponse) {
        HiidoReport.CReportResponse reportResponse = new HiidoReport.CReportResponse();
        reportResponse.mUid = useItemResponse.getUid();
        String seq = useItemResponse.getSeq();
        int code = useItemResponse.getResult();
        String message = useItemResponse.getMessage();
        SendGiftResInfo sendGiftResInfo = new SendGiftResInfo();
        sendGiftResInfo.propsId = useItemResponse.getPropsId();
        sendGiftResInfo.count = useItemResponse.getCount();
        sendGiftResInfo.appId = useItemResponse.getAppId();
        sendGiftResInfo.senderuid = useItemResponse.getSenderUid();
        sendGiftResInfo.sendernickname = useItemResponse.getSendernickname();
        sendGiftResInfo.recveruid = useItemResponse.getRecveruid();
        sendGiftResInfo.recvernickname = useItemResponse.getRecvernickname();
        sendGiftResInfo.realRecveruid = useItemResponse.getRealRecveruid();
        sendGiftResInfo.realRecvernickname = useItemResponse.getRealRecvernickname();
        sendGiftResInfo.expend = useItemResponse.getExpend();
        sendGiftResInfo.confirmUrl = useItemResponse.getConfirmUrl();
        sendGiftResInfo.buyCount = useItemResponse.getBuyCount();
        if (code == 1 || code == -10) {
            SendGiftResult result = new SendGiftResult();
            result.appId = this.mAppId;
            result.channelId = this.mUsedChannel;
            result.resInfo = sendGiftResInfo;
            CallbackMode.getInstance().onCallbackSuccess(seq, result);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "30";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u5355\u4e2a\u7528\u6237\u6210\u529f";
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                this.iGiftReporter.onSendGiftToUserResault(reportResponse);
                reportResponse.mEventId = "200";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u4e2a\u4eba\u6210\u529f";
                this.iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        } else {
            CallbackMode.getInstance().onCallbackFail(seq, code, message);
            if (this.iGiftReporter != null) {
                reportResponse.mEventId = "31";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u5355\u4e2a\u7528\u6237\u5931\u8d25";
                reportResponse.mErrCode = code + "";
                reportResponse.mErrMsg = message;
                this.iGiftReporter.onSendGiftToUserResault(reportResponse);
                reportResponse.mEventId = "201";
                reportResponse.mEventaliae = "\u8d60\u9001\u793c\u7269\u7ed9\u4e2a\u4eba\u6210\u529f";
                this.iGiftReporter.onSendSingleSummaryResult(reportResponse);
            }
        }
    }

    private void onGiftBroadcastData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        int usedChannel = data.optInt("used_channel", this.mUsedChannel);
        GiftInfo giftInfo = this.findGiftById(propsId, this.currentUsedchannel);
        if (giftInfo != null) {
            GiftBroInfo giftBroInfo = BroadcastMsgParser.parseGiftBroInfo(data);
            giftBroInfo.giftInfo = giftInfo;
            this.mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                    iGiftEventCallback.onGiftBroadcastInfo(this.mAppId, giftBroInfo.usedChannel, giftBroInfo);
                }
            });
        } else {
            RLog.error((Object)TAG, (String)"onGiftBroadcastData findGiftInfo == null! propsId = %d", (Object[])new Object[]{propsId});
        }
    }

    private void onGiftBagAddMessage(PSCIMessageUnicast unicastData) {
        GiftBagAddMessage giftBagAddMessage = UnicastMsgParser.parseGiftBagAddMessage(unicastData.getData());
        this.mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                iGiftEventCallback.onGiftBagAddUnicast(unicastData.getAppId(), unicastData.getChannelId(), giftBagAddMessage);
            }
        });
    }

    private void onGiftBagAcquireMessage(PSCIMessageUnicast unicastData) {
        GiftBagAcquireMessage acquireMessage = UnicastMsgParser.parseGiftBagAcquireMessage(unicastData.getData());
        this.mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                iGiftEventCallback.onGiftBagAcquireUnicast(unicastData.getAppId(), unicastData.getChannelId(), acquireMessage);
            }
        });
    }

    private void onUpdatePackageWallet(PSCIMessageUnicast data) {
        PackageWalletUpdateMessage message = UnicastMsgParser.parsePackageUpdateMessage(data.getData());
        this.mainHandler.post(() -> {
            for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                iGiftEventCallback.onPackageWalletUpdate(data.getAppId(), data.getChannelId(), message);
            }
        });
    }

    private void onGiftComboFinishData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        int usedChannel = data.optInt("used_channel", this.mUsedChannel);
        GiftInfo giftInfo = this.findGiftById(propsId, this.currentUsedchannel);
        if (giftInfo != null) {
            GiftComboFinishInfo comboFinishInfo = BroadcastMsgParser.parseGiftComboFinishInfo(data);
            comboFinishInfo.giftInfo = giftInfo;
            this.mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                    iGiftEventCallback.onGiftComboFinishInfo(this.mAppId, comboFinishInfo.usedChannel, comboFinishInfo);
                }
            });
        } else {
            RLog.error((Object)TAG, (String)"onGiftComboFinishData findGiftInfo == null! propsId = %d", (Object[])new Object[]{propsId});
        }
    }

    private void onMultiGiftBroadcastData(PSCIMessageBroadcast broadcastData) {
        JSONObject data = broadcastData.getData();
        int propsId = data.optInt("props_id", 0);
        GiftInfo giftInfo = this.findGiftById(propsId, this.currentUsedchannel);
        MultiGiftInfo multiGiftInfo = BroadcastMsgParser.parseMultiGiftInfo(data);
        if (giftInfo != null) {
            multiGiftInfo.giftInfo = giftInfo;
            this.mainHandler.post(() -> {
                for (IGiftEventCallback iGiftEventCallback : this.giftCallbackList) {
                    iGiftEventCallback.onMultiGiftBroadcastInfo(this.mAppId, multiGiftInfo.usedChannel, multiGiftInfo);
                }
            });
        } else {
            RLog.error((Object)TAG, (String)"onMultiGiftBroadcastData multiGiftInfo == null! propsId = %d", (Object[])new Object[]{propsId});
        }
    }

    public void onResponseData(int appId, PSCIMessageResponse responseData) {
        RLog.info((Object)TAG, (String)"onResponseData: appId = %d, cmd = %d", (Object[])new Object[]{appId, responseData.cmd});
        switch (responseData.cmd) {
            case 2010: {
                this.onGetPropsByAppIdResp(new GetPropsByAppIdResponse(responseData.jsonMsg));
                break;
            }
            case 2001: {
                this.onToInfoResponse(new ToInfoResponse(responseData.jsonMsg));
                break;
            }
            case 2007: 
            case 2009: {
                this.onUseItemResponse(new UseItemResponse(responseData.jsonMsg));
                break;
            }
            case 2012: {
                this.onGetUserPropsResponse(new GetUserPropsResponse(responseData.jsonMsg));
                break;
            }
            case 2048: {
                this.onRankEntranceResponse(new RankEntranceResponse(responseData.jsonMsg));
                break;
            }
            case 2042: {
                this.onSendGiftToMultiUserResponse(new SendGiftToMultiUserResponse(responseData.jsonMsg));
                break;
            }
            case 2006: {
                this.onGetUserReceivePropsAmountResponse(new GetUserReceivePropsAmountResponse(responseData.jsonMsg));
                break;
            }
            case 2047: {
                this.onGetUserCouponStoreResponse(new GetUserCouponStoreResponse(responseData.jsonMsg));
                break;
            }
            case 2049: {
                this.onGetGiftBagResponse(new GetGiftBagResponse(responseData.jsonMsg));
                break;
            }
        }
    }

    public void onUnicastData(int appId, PSCIMessageUnicast unicastData) {
        if (unicastData.getUri() == 4042324323L) {
            this.onGiftBagAddMessage(unicastData);
        } else if (unicastData.getUri() == 4042389603L) {
            this.onGiftBagAcquireMessage(unicastData);
        } else if (unicastData.getUri() == 4042390371L) {
            this.onUpdatePackageWallet(unicastData);
        } else {
            RLog.error((Object)TAG, (String)"onUnicastData not match any uri!", (Object[])new Object[0]);
        }
    }

    public void onBroadcastData(int appId, PSCIMessageBroadcast broadcastData) {
        if (broadcastData.getUri() == 4042323043L) {
            this.onGiftBroadcastData(broadcastData);
        } else if (broadcastData.getUri() == 4042392419L) {
            this.onGiftComboFinishData(broadcastData);
        } else if (broadcastData.getUri() == 4042393955L) {
            this.onMultiGiftBroadcastData(broadcastData);
        } else {
            RLog.error((Object)TAG, (String)"onBroadcastData not match any uri!", (Object[])new Object[0]);
        }
    }

    public void onRequestError(int appId, String seq, int cmd, int srvErrorCode, String message) {
        CallbackMode.getInstance().onCallbackFail(seq, srvErrorCode, message);
    }
}

