/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.framework.revenuesdk.gift;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.GiftCacheInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftCacheInfoUtil;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GiftCache {
    private static final String TAG = "Revenue.GiftCache";
    private static final String SHARED_PRE_TAG = "Revenue_GiftCache";
    private static final String KEY_GIFT_CACHE_INFO_SET = "key_gift_cache_info_set";
    private int mAppId;
    private int defaultUsedChannel;
    private Context mContext;
    private Handler mWorkHandler;
    private SharedPreferences sp;
    private Map<String, GiftCacheInfo> giftCacheInfoMap = new HashMap<String, GiftCacheInfo>();
    private Map<String, List<GiftInfo>> cacheGiftMap = new HashMap<String, List<GiftInfo>>();
    private SparseArray<GiftInfo> allGiftInfos = new SparseArray();
    private SparseArray<SparseArray<GiftInfo>> giftInfoMap = new SparseArray();

    GiftCache(int appId, Context context, Handler workHandler, int usedChannel) {
        this.mAppId = appId;
        this.mContext = context;
        this.mWorkHandler = workHandler;
        if (this.mContext != null) {
            this.sp = this.mContext.getSharedPreferences(SHARED_PRE_TAG + appId, 0);
        }
        this.defaultUsedChannel = usedChannel;
    }

    public synchronized List<GiftInfo> getGiftList(int channelId, int liveCategoryId) {
        String key = String.valueOf(channelId) + String.valueOf(liveCategoryId);
        return this.cacheGiftMap.get(key);
    }

    public synchronized void updateGiftList(int usedChannel, int liveCategoryId, List<GiftInfo> propsList, String urlPrefix, String compressData, String md5Hash) {
        RLog.debug((Object)TAG, (String)"updateGiftList: compressData = %s", (Object[])new Object[]{compressData});
        GiftCacheInfo cacheInfo = new GiftCacheInfo(usedChannel, liveCategoryId, urlPrefix, md5Hash, compressData);
        if (GiftCacheInfoUtil.writeGiftCacheInfoData(this.mContext, cacheInfo)) {
            String key = String.valueOf(usedChannel) + "_" + String.valueOf(liveCategoryId);
            this.giftCacheInfoMap.put(key, cacheInfo);
            if (this.sp != null) {
                HashSet resource = this.sp.getStringSet(KEY_GIFT_CACHE_INFO_SET, null);
                if (resource == null) {
                    resource = new HashSet();
                }
                HashSet<String> modifyData = new HashSet<String>(resource);
                modifyData.add(key);
                this.sp.edit().putStringSet(KEY_GIFT_CACHE_INFO_SET, modifyData).apply();
            }
        }
        this.updateGiftList(usedChannel, liveCategoryId, propsList);
    }

    private synchronized void updateGiftList(int usedChannel, int liveCategoryId, List<GiftInfo> propsList) {
        RLog.info((Object)TAG, (String)"updateGiftList: usedChannel = %d, liveCategoryId = %d, propsList Size = %d", (Object[])new Object[]{usedChannel, liveCategoryId, propsList != null ? propsList.size() : 0});
        String key = String.valueOf(usedChannel) + String.valueOf(liveCategoryId);
        this.cacheGiftMap.put(key, propsList);
        this.updateGiftListMap(propsList, usedChannel);
    }

    private synchronized void updateGiftListMap(List<GiftInfo> propsList, int usedChannel) {
        SparseArray tempGiftInfos = (SparseArray)this.giftInfoMap.get(usedChannel);
        if (tempGiftInfos == null) {
            tempGiftInfos = new SparseArray();
        }
        if (propsList != null && propsList.size() > 0) {
            for (GiftInfo giftInfo : propsList) {
                tempGiftInfos.put(giftInfo.propsId, (Object)giftInfo);
            }
        }
        this.giftInfoMap.put(usedChannel, (Object)tempGiftInfos);
    }

    @Deprecated
    private synchronized void updateAllGiftList(@Nullable List<GiftInfo> propsList) {
        if (propsList != null) {
            for (GiftInfo giftInfo : propsList) {
                this.allGiftInfos.put(giftInfo.propsId, (Object)giftInfo);
            }
        }
    }

    @Deprecated
    public synchronized List<GiftInfo> getAllChannelGift() {
        ArrayList<GiftInfo> allChannelGifts = new ArrayList<GiftInfo>();
        for (int i = 0; i < this.allGiftInfos.size(); ++i) {
            allChannelGifts.add((GiftInfo)this.allGiftInfos.valueAt(i));
        }
        return allChannelGifts;
    }

    public synchronized GiftInfo findGiftById(int propsId) {
        return this.findGiftById(propsId, this.defaultUsedChannel);
    }

    public synchronized GiftInfo findGiftById(int propsId, int usedChannel) {
        SparseArray giftInfos = (SparseArray)this.giftInfoMap.get(usedChannel);
        if (giftInfos != null) {
            return (GiftInfo)giftInfos.get(propsId);
        }
        return null;
    }

    public void loadGiftListFromCache(int usedChannel, int liveCategoryId) {
        GiftCacheInfo giftCacheInfo = GiftCacheInfoUtil.readGiftCacheInfoData(this.mContext, usedChannel, liveCategoryId);
        if (giftCacheInfo != null) {
            this.giftCacheInfoMap.put(String.format(Locale.ENGLISH, "%d_%d", usedChannel, liveCategoryId), giftCacheInfo);
            if (this.getGiftList(usedChannel, liveCategoryId) == null) {
                List<GiftInfo> propsList = GiftListUtil.parserGiftList(giftCacheInfo.compressData, usedChannel, giftCacheInfo.urlPreFix, liveCategoryId);
                this.updateGiftList(usedChannel, liveCategoryId, propsList);
            }
        }
    }

    public String getLastMd5Hash(int usedChannel, int liveCategoryId) {
        String key = String.valueOf(usedChannel) + "_" + String.valueOf(liveCategoryId);
        GiftCacheInfo cacheInfo = this.giftCacheInfoMap.get(key);
        if (cacheInfo != null) {
            return cacheInfo.md5Hash;
        }
        return "";
    }

    public void clearAllGiftCache() {
        this.giftCacheInfoMap.clear();
        this.cacheGiftMap.clear();
        this.allGiftInfos.clear();
        this.giftInfoMap.clear();
    }

    public void clearGiftCacheByChannelAndCategoryId(int usedChannel, int liveCategoryId) {
        this.giftInfoMap.remove(usedChannel);
        String key_cacheInfo = String.valueOf(usedChannel) + "_" + String.valueOf(liveCategoryId);
        this.giftCacheInfoMap.remove(key_cacheInfo);
        String key = String.valueOf(usedChannel) + String.valueOf(liveCategoryId);
        this.cacheGiftMap.remove(key);
    }
}

