package com.yy.mobile.framework.revenuesdk.gift.util;

import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAcquireMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBagAddMessage;
import com.yy.mobile.framework.revenuesdk.gift.bean.PackageWalletUpdateMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ConsumeConfirmMessage;
import com.yy.mobile.framework.revenuesdk.payapi.bean.CurrencyChargeMessage;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lhf on 2018/7/17.
 * <p>
 * YY.Inc
 */
@SuppressWarnings("javadoc")
public class UnicastMsgParser {

    public static GiftBagAddMessage parseGiftBagAddMessage(JSONObject data) {
        GiftBagAddMessage bagAddMsg = new GiftBagAddMessage();
        bagAddMsg.uid = data.optLong("uid", 0);
        bagAddMsg.giftBagId = data.optLong("giftBagId", 0);
        bagAddMsg.giftBagName = data.optString("giftBagName", "");
        bagAddMsg.addCount = data.optLong("addCount", 0);
        bagAddMsg.expand = data.optString("expand", "");
        return bagAddMsg;
    }

    public static GiftBagAcquireMessage parseGiftBagAcquireMessage(JSONObject data) {
        GiftBagAcquireMessage bagAcquireMsg = new GiftBagAcquireMessage();
        bagAcquireMsg.giftBagId = data.optLong("giftBagId", 0);
        bagAcquireMsg.giftBagName = data.optString("giftBagName", "");
        List<GiftBagAcquireMessage.GiftBagPropMessage> acquireList = new ArrayList<>();
        JSONArray acquiresArray = data.optJSONArray("acquires");
        if (acquiresArray != null && acquiresArray.length() > 0) {
            for (int i = 0; i < acquiresArray.length(); ++i) {
                JSONObject item = acquiresArray.optJSONObject(i);
                if (item != null) {
                    GiftBagAcquireMessage.GiftBagPropMessage propMessage =
                            new GiftBagAcquireMessage.GiftBagPropMessage();
                    propMessage.propId = item.optInt("propId", 0);
                    propMessage.propName = item.optString("propName", "");
                    propMessage.count = item.optInt("count", 0);
                    acquireList.add(propMessage);
                }
            }
        }
        bagAcquireMsg.acquires = acquireList;
        bagAcquireMsg.acquireCount = data.optLong("acquireCount", 0);
        bagAcquireMsg.expand = data.optString("expand", "");
        return bagAcquireMsg;
    }

    /**
     * 解析充值后发货成功单播
     *
     * @param data
     * @return
     */
    public static CurrencyChargeMessage parseCurrencyChargeMessage(JSONObject data) {
        if (null == data) {
            return null;
        }
        CurrencyChargeMessage message = new CurrencyChargeMessage();
        message.appid = data.optInt("appid");
        message.uid = data.optLong("uid");
        message.usedChannel = data.optInt("usedChannel");
        message.currencyType = data.optInt("currencyType");
        message.amount = data.optLong("amount");
        message.currencyAmount = data.optLong("currencyAmount");
        message.orderId = data.optString("orderId");
        message.expand = data.optString("expand");
        return message;
    }

    /**
     * 解析Y币二次确认 购买成功 确认单播
     *
     * @param data
     * @return
     */
    public static ConsumeConfirmMessage parseConsumeConfirmMessage(JSONObject data) {
        ConsumeConfirmMessage message = null;
        if (data != null) {
            message = new ConsumeConfirmMessage();
            message.result = data.optInt("result", -1);
            message.seq = data.optString("seq", "");
            message.uid = data.optLong("uid", 0);
            message.user_yy_num = data.optString("user_yy_num", "");
            message.user_nick_name = data.optString("user_nick_name", "");
            message.recv_uid = data.optLong("recv_uid", 0);
            message.recv_yy_num = data.optString("recv_yy_num", "");
            message.recv_nick_name = data.optString("recv_nick_name", "");
            message.business_type = data.optInt("business_type", 0);
            message.props_id = data.optInt("props_id", 0);
            message.props_count = data.optInt("props_count", 0);
            message.props_buy_count = data.optInt("props_buy_count", 0);
            message.props_buy_currency_type = data.optInt("props_buy_currency_type", 0);
            message.props_buy_currency_amount = data.optDouble("props_buy_currency_amount", 0);
            message.version = data.optInt("version", 0);
            message.expand = data.optString("expand", "");
            message.appid = data.optInt("appid", 0);
        }
        return message;
    }

    public static PackageWalletUpdateMessage parsePackageUpdateMessage(JSONObject data) {
        PackageWalletUpdateMessage message = new PackageWalletUpdateMessage();
        if (data != null) {
            //int length = data.optInt("currencyCount");
            JSONArray jsonArray = data.optJSONArray("accountList");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                List<PackageWalletUpdateMessage.WalletInfo> walletInfos = new ArrayList<>(length);
                for (int i = 0; i < length; i++) {
                    JSONObject jsonWallet = jsonArray.optJSONObject(i);
                    if (jsonWallet != null) {
                        PackageWalletUpdateMessage.WalletInfo walletInfo =
                                new PackageWalletUpdateMessage.WalletInfo();
                        walletInfo.setCurrencyType(jsonWallet.optInt("currencyType"));
                        walletInfo.setAmount(jsonWallet.optLong("amount"));
                        walletInfo.setFreezed(jsonWallet.optInt("freezed"));
                        walletInfo.setAccountFrozen(jsonWallet.optInt("accountFrozen"));
                        walletInfo.setExpireAmount(jsonWallet.optInt("expireAmount"));
                        walletInfo.setExpireDate(jsonWallet.optString("expireDate"));
                        walletInfos.add(walletInfo);
                    }
                }
                message.setUserWallet(walletInfos);
            }

            jsonArray = data.optJSONArray("propList");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                List<PackageWalletUpdateMessage.PackageInfo> packageInfos =
                        new ArrayList<>(/*length*/);
                for (int i = 0; i < length; i++) {
                    JSONObject jsonPackage = jsonArray.optJSONObject(i);
                    if (jsonPackage != null) {
                        PackageWalletUpdateMessage.PackageInfo packageInfo =
                                new PackageWalletUpdateMessage.PackageInfo();
                        packageInfo.setPropId(jsonPackage.optInt("propId"));
                        packageInfo.setCount(jsonPackage.optInt("pricingId"));
                        packageInfo.setCount(jsonPackage.optInt("count"));
                        packageInfos.add(packageInfo);
                    }
                }
                message.setUserPackage(packageInfos);
            }
            message.setExpand(data.optString("expand"));
        }
        return message;
    }
}
