package com.yy.mobile.framework.revenuesdk.gift.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.GiftCacheInfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;

/**
 * Created by lhf on 2018/8/6.
 * <p>
 * YY.Inc
 */
public class GiftCacheInfoUtil {

    private static final String TAG = "GiftCacheInfoUtil";

    private static String FileDirPathName = "/revenue";

    //getFilesDir存在着返回null的情况.
    private static String getDataFileDirPath(Context context) {
        File esdf = context.getFilesDir();
        if (esdf == null) {
            return "";
        }
        return esdf.getAbsolutePath() + FileDirPathName;
    }

    private static String getDataFilePath(Context context, int usedChannel, int liveCategoryId) {
        File esdf = context.getFilesDir();
        if (esdf == null) {
            return "";
        }
        return esdf.getAbsolutePath() + FileDirPathName + "/giftCompress_" + usedChannel + "_" +
                liveCategoryId + ".txt";
    }

    public static synchronized boolean writeGiftCacheInfoData(Context context,
                                                              @NonNull GiftCacheInfo cacheInfo) {
        if (context == null) {
            RLog.error(TAG, "writeGiftCacheInfoData: context == null!");
            return false;
        }
        String path = getDataFileDirPath(context);
        if (path.equals("")) {
            return false;
        }
        File dirFile = new File(path);
        boolean isDirMkSuccess = false;
        if (!dirFile.exists()) {
            isDirMkSuccess = dirFile.mkdir();
        }
        RLog.info(TAG, "writeGiftCacheInfoData: makeDir result = " + isDirMkSuccess);
        String savePath = getDataFilePath(context, cacheInfo.usedChannel, cacheInfo.liveCategoryId);
        if (path.equals("")) {
            return false;
        }
        File dataFile = new File(savePath);
        if (!dataFile.exists()) {
            // 不存在则创建
            try {
                boolean isCreateFileSuccess = dataFile.createNewFile();
                RLog.info(TAG,
                        "writeGiftCacheInfoData: createFile result = " + isCreateFileSuccess);
            } catch (Exception e) {
                RLog.error(TAG, "writeGiftCacheInfoData: create dataFile error.", e);
                return false;
            }
        }
        try {
            PrintWriter printWriter = new PrintWriter(dataFile);
            printWriter.print("");
            printWriter.flush();
            printWriter.print(cacheInfo.toJsonStr());
            printWriter.flush();
            printWriter.close();
        } catch (Exception e) {
            RLog.error(TAG, "writeGiftCacheInfoData: write data error.", e);
            return false;
        }
        return true;
    }

    @Nullable
    public static synchronized GiftCacheInfo readGiftCacheInfoData(Context context, int usedChannel,
                                                                   int liveCategoryId) {
        if (context == null) {
            RLog.error(TAG, "readGiftCacheInfoData: context == null!");
            return new GiftCacheInfo();
        }
        String path = getDataFilePath(context, usedChannel, liveCategoryId);
        if (path.equals("")) {
            return null;
        }
        File dataFile = new File(path);
        StringBuilder jsonData = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(dataFile));
            String line;
            while ((line = br.readLine()) != null) {
                jsonData.append(line);
            }
            br.close();
        } catch (Exception e) {
            RLog.error(TAG, "readGiftCacheInfoData: read data error.", e);
        }
        return GiftCacheInfo.parseFromJson(jsonData.toString());
    }
}
