package com.yy.mobile.framework.revenuesdk.gift.util;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftBroInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboFinishInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftComboInfo;
import com.yy.mobile.framework.revenuesdk.gift.bean.MultiGiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/17.
 * <p>
 * YY.Inc
 */
public class BroadcastMsgParser {

    public static GiftBroInfo parseGiftBroInfo(JSONObject data) {
        GiftBroInfo giftBroInfo = new GiftBroInfo();
        giftBroInfo.propsId = data.optInt("props_id", 0);
        giftBroInfo.count = data.optInt("props_count", 0);
        giftBroInfo.usedChannel = data.optInt("used_channel", 0);
        giftBroInfo.senderuid = data.optLong("uid", 0);
        giftBroInfo.sendernickname = data.optString("user_nick_name", "");
        giftBroInfo.recveruid = data.optLong("recv_uid", 0);
        giftBroInfo.recvernickname = data.optString("recv_nick_name", "");
        giftBroInfo.realRecveruid = data.optLong("real_recv_uid", 0);
        giftBroInfo.realRecvernickname = data.optString("real_recv_nick_name", "");
        giftBroInfo.business_type = data.optInt("business_type", 0);
        giftBroInfo.expend = data.optString("expand", "");
        giftBroInfo.props_currency_amount = data.optLong("props_currency_amount", 0);
        giftBroInfo.used_time = data.optLong("used_time", 0);
        try {
            JSONObject expend = new JSONObject(giftBroInfo.expend);
            GiftComboInfo comboInfo = new GiftComboInfo();
            JSONObject combo = expend.optJSONObject("comboInfo");
            if (combo != null) {
                comboInfo.comboHits = combo.optLong("comboHits", 0);
                comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                comboInfo.intervalTime = combo.optLong("intervalTime", 0);
            }
            giftBroInfo.giftComboInfo = comboInfo;
        } catch (JSONException e) {
            RLog.error("parseGiftBroInfo", "parse expend error.", e);
        }
        return giftBroInfo;
    }

    public static GiftComboFinishInfo parseGiftComboFinishInfo(JSONObject data) {
        GiftComboFinishInfo comboFinishInfo = new GiftComboFinishInfo();
        comboFinishInfo.propsId = data.optInt("props_id", 0);
        comboFinishInfo.count = data.optInt("props_count", 0);
        comboFinishInfo.usedChannel = data.optInt("used_channel", 0);
        comboFinishInfo.senderuid = data.optLong("uid", 0);
        comboFinishInfo.sendernickname = data.optString("user_nick_name", "");
        comboFinishInfo.recveruid = data.optLong("recv_uid", 0);
        comboFinishInfo.recvernickname = data.optString("recv_nick_name", "");
        comboFinishInfo.business_type = data.optInt("business_type", 0);
        comboFinishInfo.expend = data.optString("expand", "");
        try {
            JSONObject expend = new JSONObject(comboFinishInfo.expend);
            GiftComboInfo comboInfo = new GiftComboInfo();
            JSONObject combo = expend.optJSONObject("comboInfo");
            if (combo != null) {
                comboInfo.comboHits = combo.optLong("comboHits", 0);
                comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                comboInfo.intervalTime = combo.optLong("intervalTime", 0);
            }
            comboFinishInfo.giftComboInfo = comboInfo;
        } catch (JSONException e) {
            RLog.error("parseGiftComboFinishInfo", "parse expend error.", e);
        }
        return comboFinishInfo;
    }

    public static MultiGiftInfo parseMultiGiftInfo(JSONObject resp) {
        MultiGiftInfo multiGiftInfo = new MultiGiftInfo();
        try {
            multiGiftInfo.seq = resp.optString("seq", "");
            multiGiftInfo.uid = resp.optLong("uid", 0);
            multiGiftInfo.usedChannel = resp.optInt("usedChannel", -1);
            multiGiftInfo.result = resp.optInt("result", -1);
            multiGiftInfo.message = resp.optString("message", "");
            multiGiftInfo.propsId = resp.optInt("props_id", 0);
            multiGiftInfo.count = resp.optInt("props_count", 0);
            multiGiftInfo.appId = resp.optInt("app_id", 0);
            //sender
            JSONObject sender = resp.optJSONObject("senderUserInfo");
            if (sender != null) {
                multiGiftInfo.senderUid = sender.optLong("uid", 0);
                multiGiftInfo.sendernickname = sender.optString("nickName", "");
            }
            //receiver
            JSONArray receiver = resp.optJSONArray("recverUserInfos");
            if (receiver != null) {
                for (int i = 0; i < receiver.length(); i++) {
                    JSONObject temp = receiver.optJSONObject(i);
                    SendGiftParamV2.TargetUser target = new SendGiftParamV2.TargetUser(temp.optLong("uid"));
                    target.yyNum = temp.optString("yyno", "");
                    target.nickName = temp.optString("nickName", "");
                    multiGiftInfo.targetUsers.add(target);
                }
            }

            multiGiftInfo.expend = resp.optString("expand", "");
            try {
                JSONObject expend = new JSONObject(multiGiftInfo.expend);
                GiftComboInfo comboInfo = new GiftComboInfo();
                JSONObject combo = expend.optJSONObject("comboInfo");
                if (combo != null) {
                    comboInfo.comboHits = combo.optLong("comboHits", 0);
                    comboInfo.isFinishCombo = Boolean.parseBoolean(combo.optString("isFinishCombo", "false"));
                    comboInfo.intervalTime = combo.optLong("intervalTime", 0);
                }
                multiGiftInfo.giftComboInfo = comboInfo;
            } catch (JSONException e) {
                RLog.error("parseGiftBroInfo", "parse expend error.", e);
            }
            multiGiftInfo.confirmUrl = resp.optString("confirmUrl", "");
        } catch (Exception e) {
            RLog.error("parseMultiGiftInfo", "parserResponse error.", e);
        }
        return multiGiftInfo;
    }

}
