package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by nls on 2019/6/13.
 * Nothing.
 */
public class SendGiftParamV2 {

    public int appId; //分配给业务的appID 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的channelId
    public int propsId; //道具id
    public int count; //赠送数量
    public long senderuid; //赠送者uid，必填
    public String sendernickname; //赠送者昵称，选填
    public long recveruid; //主持人或房主uid，必填
    public String recvernickname; //主持人或房主昵称，选填
    public List<TargetUser> targetUsers; //真正的接收者.
    public long sid; //使用时频道号，频道外传0
    public long ssid; //使用时子频道号,没有传0
    public String expand; //扩展字段，原文附于返回
    public boolean isAutoBuy; //是否自动购买礼物, false 只赠送包裹里有的礼物 true自动消耗账号内的货币
    public int currencyType; //购买礼物的货币类型
    public String payGateOrderId; //payGateOrderId 选填
    public String payWay; //选填，需要指定支付方式时候填写
    public String payAdditionInfo; //选填，指定了支付方式后，苹果或银行支付需要指定填入信息
    public String ticket;
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

    public SendGiftParamV2() {
        appId = 0;
        channelId = 0;
        propsId = 0;
        count = 0;
        senderuid = 0;
        sendernickname = "";
        recveruid = 0;
        recvernickname = "";
        sid = 0;
        ssid = 0;
        expand = "";
        isAutoBuy = false;
        currencyType = 0;
        payGateOrderId = "";
        payWay = "";
        payAdditionInfo = "";
        ticket = "";
        targetUsers = Collections.emptyList();
        retry = null;
    }

    //uid必填, 其他选填.
    public static final class TargetUser {
        public long uid; //uid
        public String yyNum; //YY号
        public String nickName;
        public String expand;

        public TargetUser(long uid) {
            this.uid = uid;
        }

        public TargetUser(long uid, String yyNum, String nickName, String expand) {
            this.uid = uid;
            this.yyNum = yyNum;
            this.nickName = nickName;
            this.expand = expand;
        }
    }

    public static final class SendGiftParamV2Builder {
        public int appId; //分配给业务的appID 不填或者填0使用默认的appId
        public int channelId; //渠道id 不填或者填0使用默认的channelId
        public int propsId; //道具id
        public int count; //赠送数量
        public long senderuid; //赠送者uid，必填
        public String sendernickname; //赠送者昵称，选填
        public long recveruid; //主持人或房主uid，必填
        public String recvernickname; //主持人或房主昵称，选填
        public List<TargetUser> targetUsers; //真正的接收者.
        public long sid; //使用时频道号，频道外传0
        public long ssid; //使用时子频道号,没有传0
        public String expand; //扩展字段，原文附于返回
        public boolean isAutoBuy; //是否自动购买礼物, false 只赠送包裹里有的礼物 true自动消耗账号内的货币
        public int currencyType; //购买礼物的货币类型
        public String payGateOrderId; //payGateOrderId 选填
        public String payWay; //选填，需要指定支付方式时候填写
        public String payAdditionInfo; //选填，指定了支付方式后，苹果或银行支付需要指定填入信息
        public ArrayList<Integer> retry = null; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

        private SendGiftParamV2Builder() {
        }

        public static SendGiftParamV2Builder aSendGiftParam() {
            return new SendGiftParamV2Builder();
        }

        public SendGiftParamV2Builder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public SendGiftParamV2Builder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public SendGiftParamV2Builder setPropsId(int propsId) {
            this.propsId = propsId;
            return this;
        }

        public SendGiftParamV2Builder setCount(int count) {
            this.count = count;
            return this;
        }

        public SendGiftParamV2Builder setSenderuid(long senderuid) {
            this.senderuid = senderuid;
            return this;
        }

        public SendGiftParamV2Builder setSendernickname(String sendernickname) {
            this.sendernickname = sendernickname;
            return this;
        }

        public SendGiftParamV2Builder setRecveruid(long recveruid) {
            this.recveruid = recveruid;
            return this;
        }

        public SendGiftParamV2Builder setRecvernickname(String recvernickname) {
            this.recvernickname = recvernickname;
            return this;
        }

        public SendGiftParamV2Builder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public SendGiftParamV2Builder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public SendGiftParamV2Builder setExpand(String expand) {
            this.expand = expand;
            return this;
        }

        public SendGiftParamV2Builder setIsAutoBuy(boolean isAutoBuy) {
            this.isAutoBuy = isAutoBuy;
            return this;
        }

        public SendGiftParamV2Builder setCurrencyType(int currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public SendGiftParamV2Builder setPayGateOrderId(String payGateOrderId) {
            this.payGateOrderId = payGateOrderId;
            return this;
        }

        public SendGiftParamV2Builder setPayWay(String payWay) {
            this.payWay = payWay;
            return this;
        }

        public SendGiftParamV2Builder setPayAdditionInfo(String payAdditionInfo) {
            this.payAdditionInfo = payAdditionInfo;
            return this;
        }

        public SendGiftParamV2Builder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public SendGiftParamV2Builder setTargetUsers(List<TargetUser> users) {
            this.targetUsers = users;
            return this;
        }

        public SendGiftParamV2 build() {
            SendGiftParamV2 sendGiftParamV2 = new SendGiftParamV2();
            if (targetUsers == null || targetUsers.isEmpty()) {
                throw new IllegalArgumentException("target user must be set!!");
            }
            sendGiftParamV2.targetUsers = targetUsers;
            sendGiftParamV2.appId = this.appId;
            sendGiftParamV2.senderuid = this.senderuid;
            sendGiftParamV2.recveruid = this.recveruid;
            sendGiftParamV2.count = this.count;
            sendGiftParamV2.ssid = this.ssid;
            sendGiftParamV2.propsId = this.propsId;
            sendGiftParamV2.expand = this.expand;
            sendGiftParamV2.sendernickname = this.sendernickname;
            sendGiftParamV2.isAutoBuy = this.isAutoBuy;
            sendGiftParamV2.recvernickname = this.recvernickname;
            sendGiftParamV2.sid = this.sid;
            sendGiftParamV2.channelId = this.channelId;
            sendGiftParamV2.currencyType = this.currencyType;
            sendGiftParamV2.payGateOrderId = this.payGateOrderId;
            sendGiftParamV2.payWay = this.payWay;
            sendGiftParamV2.payAdditionInfo = this.payAdditionInfo;
            sendGiftParamV2.retry = this.retry;
            return sendGiftParamV2;
        }
    }
}
