package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

/**
 * Created by lhf on 2018/7/13.
 * <p>
 * YY.Inc
 */
public class SendGiftParam {

    public int appId; //分配给业务的appID 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的channelId
    public int propsId; //道具id
    public int count; //赠送数量
    public long senderuid; //赠送者uid，必填
    public String sendernickname; //赠送者昵称，选填
    public long recveruid; //主持人或房主uid，必填
    public String recvernickname; //主持人或房主昵称，选填
    public long realRecveruid; //真正接收者uid，必填
    public String realRecvernickname; //真正接收者昵称，选填
    public long sid; //使用时频道号，频道外传0
    public long ssid; //使用时子频道号,没有传0
    public String expand; //扩展字段，原文附于返回
    public boolean isAutoBuy; //是否自动购买礼物, false 只赠送包裹里有的礼物 true自动消耗账号内的货币
    public int currencyType; //购买礼物的货币类型
    public String payGateOrderId; //payGateOrderId 选填
    public String payWay; //选填，需要指定支付方式时候填写
    public String payAdditionInfo; //选填，指定了支付方式后，苹果或银行支付需要指定填入信息
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

    public SendGiftParam() {
        appId = 0;
        channelId = 0;
        propsId = 0;
        count = 0;
        senderuid = 0;
        sendernickname = "";
        recveruid = 0;
        recvernickname = "";
        sid = 0;
        ssid = 0;
        expand = "";
        isAutoBuy = false;
        currencyType = 0;
        payGateOrderId = "";
        payWay = "";
        payAdditionInfo = "";

        ArrayList<Integer> retrylist = new ArrayList<Integer>();
        retry = retrylist;
    }

    public static final class SendGiftParamBuilder {
        public int appId; //分配给业务的appID 不填或者填0使用默认的appId
        public int channelId; //渠道id 不填或者填0使用默认的channelId
        public int propsId; //道具id
        public int count; //赠送数量
        public long senderuid; //赠送者uid，必填
        public String sendernickname; //赠送者昵称，选填
        public long recveruid; //主持人或房主uid，必填
        public String recvernickname; //主持人或房主昵称，选填
        public long realRecveruid; //真正接收者uid，必填
        public String realRecvernickname; //真正接收者昵称，选填
        public long sid; //使用时频道号，频道外传0
        public long ssid; //使用时子频道号,没有传0
        public String expand; //扩展字段，原文附于返回
        public boolean isAutoBuy; //是否自动购买礼物, false 只赠送包裹里有的礼物 true自动消耗账号内的货币
        public int currencyType; //购买礼物的货币类型
        public String payGateOrderId; //payGateOrderId 选填
        public String payWay; //选填，需要指定支付方式时候填写
        public String payAdditionInfo; //选填，指定了支付方式后，苹果或银行支付需要指定填入信息
        public ArrayList<Integer> retry = null; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

        private SendGiftParamBuilder() {
        }

        public static SendGiftParamBuilder aSendGiftParam() {
            return new SendGiftParamBuilder();
        }

        public SendGiftParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public SendGiftParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public SendGiftParamBuilder setPropsId(int propsId) {
            this.propsId = propsId;
            return this;
        }

        public SendGiftParamBuilder setCount(int count) {
            this.count = count;
            return this;
        }

        public SendGiftParamBuilder setSenderuid(long senderuid) {
            this.senderuid = senderuid;
            return this;
        }

        public SendGiftParamBuilder setSendernickname(String sendernickname) {
            this.sendernickname = sendernickname;
            return this;
        }

        public SendGiftParamBuilder setRecveruid(long recveruid) {
            this.recveruid = recveruid;
            return this;
        }

        public SendGiftParamBuilder setRecvernickname(String recvernickname) {
            this.recvernickname = recvernickname;
            return this;
        }

        public SendGiftParamBuilder setRealRecveruid(long realRecveruid) {
            this.realRecveruid = realRecveruid;
            return this;
        }

        public SendGiftParamBuilder setRealRecvernickname(String realRecvernickname) {
            this.realRecvernickname = realRecvernickname;
            return this;
        }

        public SendGiftParamBuilder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public SendGiftParamBuilder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public SendGiftParamBuilder setExpand(String expand) {
            this.expand = expand;
            return this;
        }

        public SendGiftParamBuilder setIsAutoBuy(boolean isAutoBuy) {
            this.isAutoBuy = isAutoBuy;
            return this;
        }

        public SendGiftParamBuilder setCurrencyType(int currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public SendGiftParamBuilder setPayGateOrderId(String payGateOrderId) {
            this.payGateOrderId = payGateOrderId;
            return this;
        }

        public SendGiftParamBuilder setPayWay(String payWay) {
            this.payWay = payWay;
            return this;
        }

        public SendGiftParamBuilder setPayAdditionInfo(String payAdditionInfo) {
            this.payAdditionInfo = payAdditionInfo;
            return this;
        }

        public SendGiftParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public SendGiftParam build() {
            SendGiftParam sendGiftParam = new SendGiftParam();
            sendGiftParam.appId = this.appId;
            sendGiftParam.senderuid = this.senderuid;
            sendGiftParam.recveruid = this.recveruid;
            sendGiftParam.count = this.count;
            sendGiftParam.ssid = this.ssid;
            sendGiftParam.realRecveruid = this.realRecveruid;
            sendGiftParam.propsId = this.propsId;
            sendGiftParam.expand = this.expand;
            sendGiftParam.sendernickname = this.sendernickname;
            sendGiftParam.realRecvernickname = this.realRecvernickname;
            sendGiftParam.isAutoBuy = this.isAutoBuy;
            sendGiftParam.recvernickname = this.recvernickname;
            sendGiftParam.sid = this.sid;
            sendGiftParam.channelId = this.channelId;
            sendGiftParam.currencyType = this.currencyType;
            sendGiftParam.payGateOrderId = this.payGateOrderId;
            sendGiftParam.payWay = this.payWay;
            sendGiftParam.payAdditionInfo = this.payAdditionInfo;
            sendGiftParam.retry = this.retry;
            return sendGiftParam;
        }
    }
}
