package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

public class RankEntranceParam {
    public int appId; //分配给业务的appId 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的appId
    public long uid; //用户uid
    public String code;
    public String rtype;
    public String ctype;
    public boolean latest;
    public int size;
    public int timeParam;
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

    public RankEntranceParam() {
        appId = 0;
        channelId = 0;
        uid = 0;
        code = null;
        rtype = null;
        ctype = null;
        latest = false;
        size = 0;
        timeParam = 0;
        retry = null;
    }

    public static final class RankEntranceParamBuilder {
        public int appId; //分配给业务的appId 不填或者填0使用默认的appId
        public int channelId; //渠道id 不填或者填0使用默认的appId
        public long uid; //1、视频直播（包括游戏和秀场）则传主播uid；2、语音直播则传sid
        public String code; //1、视频直播7天榜（包括游戏和秀场）：hamoWeekAnchorBoard；2、语音直播7
        // 天榜：hamoAnchorWeeklyBoardForVoice；3、视频直播总榜:hamoAnchorTotalBoard ；4、语音直播总榜:hamoVoiceAnchorTotalBoard
        public String rtype; //排行榜类型，total：总榜，incr：增量榜，peek：峰值榜
        public String ctype; //排行统计周期，总榜：all; N天榜: days：周榜:week; 月榜:month; 小时榜:hours
        public boolean latest; //是否查询最新排行信息.默认为false，该标识仅对日/周/月/近n天榜有效
        public int size; //uid为空时，size字段必填； uid不为空时，size字段可不填（可传默认值0）
        public int timeParam; // 最近 小时/日/周/月/近n天
        public ArrayList<Integer> retry = null; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

        private RankEntranceParamBuilder() {
        }

        public static RankEntranceParamBuilder getBuilder() {
            return new RankEntranceParamBuilder();
        }

        public RankEntranceParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public RankEntranceParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public RankEntranceParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public RankEntranceParamBuilder setCode(String code) {
            this.code = code;
            return this;
        }

        public RankEntranceParamBuilder setRtype(String rtype) {
            this.rtype = rtype;
            return this;
        }

        public RankEntranceParamBuilder setCtype(String ctype) {
            this.ctype = ctype;
            return this;
        }

        public RankEntranceParamBuilder setLatest(boolean latest) {
            this.latest = latest;
            return this;
        }

        public RankEntranceParamBuilder setSize(int size) {
            this.size = size;
            return this;
        }

        public RankEntranceParamBuilder setTimeParam(int timeParam) {
            this.timeParam = timeParam;
            return this;
        }

        public RankEntranceParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public RankEntranceParam build() {
            RankEntranceParam param = new RankEntranceParam();
            param.appId = this.appId;
            param.channelId = this.channelId;
            param.uid = this.uid;
            param.code = this.code;
            param.rtype = this.rtype;
            param.ctype = this.ctype;
            param.latest = this.latest;
            param.size = this.size;
            param.timeParam = this.timeParam;
            param.retry = this.retry;
            return param;
        }
    }
}
