package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

/**
 * Created by lhf on 2018/7/13.
 * <p>拉取全部礼物列表请求参数
 * YY.Inc
 */
public class LoadAllGiftParam {

    public int appId; //分配给业务的appID 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的channelId
    public long uid; //用户uid
    public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long recvUid; //当前主播，可以针对频道设置礼物的价格和是否展示(选填)
    public String filterPropsTypes; //过滤礼物类型，逗号分割，当不为空时会进行过滤处理，返回指定礼物类型的礼物配置(选填)
    public String countryCode; //国家代码，采用ISO 3166-1二位字母代码，海外营收必填
    public int liveCategoryId; //直播品类，海外营收必填
    public String clientVersion; //客户端版本
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.
    public String ticket; //验证需要，选填

    public LoadAllGiftParam() {
        appId = 0;
        channelId = 0;
        uid = 0;
        sid = 0;
        ssid = 0;
        recvUid = 0;
        filterPropsTypes = "";
        countryCode = "NA";
        liveCategoryId = 0;
        clientVersion = "";
        retry = null;
        ticket = "";
    }

    public static final class LoadAllGiftParamBuilder {
        public int appId;
        public int channelId;
        public long uid;
        public long sid;
        public long ssid;
        public long recvUid;
        public String filterPropsTypes;
        public String countryCode;
        public int liveCategoryId;
        public String clientVersion;
        public ArrayList<Integer> retry;
        public String ticket; //验证需要，选填

        private LoadAllGiftParamBuilder() {
        }

        public static LoadAllGiftParamBuilder aLoadAllGiftParam() {
            return new LoadAllGiftParamBuilder();
        }

        public LoadAllGiftParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public LoadAllGiftParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public LoadAllGiftParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public LoadAllGiftParamBuilder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public LoadAllGiftParamBuilder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public LoadAllGiftParamBuilder setRecvUid(long recvUid) {
            this.recvUid = recvUid;
            return this;
        }

        public LoadAllGiftParamBuilder setFilterPropsTypes(String filterPropsTypes) {
            this.filterPropsTypes = filterPropsTypes;
            return this;
        }

        public LoadAllGiftParamBuilder setCountryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public LoadAllGiftParamBuilder setLiveCategoryId(int liveCategoryId) {
            this.liveCategoryId = liveCategoryId;
            return this;
        }

        public LoadAllGiftParamBuilder setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        public LoadAllGiftParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public LoadAllGiftParamBuilder setTicket(String ticket) {
            this.ticket = ticket;
            return this;
        }

        public LoadAllGiftParam build() {
            LoadAllGiftParam loadAllGiftParam = new LoadAllGiftParam();
            loadAllGiftParam.uid = this.uid;
            loadAllGiftParam.recvUid = this.recvUid;
            loadAllGiftParam.channelId = this.channelId;
            loadAllGiftParam.countryCode = this.countryCode;
            loadAllGiftParam.appId = this.appId;
            loadAllGiftParam.filterPropsTypes = this.filterPropsTypes;
            loadAllGiftParam.ssid = this.ssid;
            loadAllGiftParam.sid = this.sid;
            loadAllGiftParam.liveCategoryId = this.liveCategoryId;
            loadAllGiftParam.clientVersion = this.clientVersion;
            loadAllGiftParam.retry = this.retry;
            loadAllGiftParam.ticket = this.ticket;
            return loadAllGiftParam;
        }
    }
}
