package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

public class GetGiftBagParam {

    public int appId;
    public long uid;
    public int usedChannel;
    public int giftPropId;
    public int currencyType;
    public int actId;
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.

    public GetGiftBagParam() {
        appId = 0;
        uid = 0;
        usedChannel = 0;
        giftPropId = 0;
        currencyType = 0;
        actId = 0;
        retry = null;
    }

    public static final class GetGiftBagParamBuilder {

        public int appId;
        public long uid;
        public int usedChannel;
        public int giftPropId;
        public int currencyType;
        public int actId;
        public ArrayList<Integer> retry;

        private GetGiftBagParamBuilder() {
        }

        public static GetGiftBagParam.GetGiftBagParamBuilder aGetToInfoParam() {
            return new GetGiftBagParam.GetGiftBagParamBuilder();
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setUsedChannel(int usedChannel) {
            this.usedChannel = usedChannel;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setGiftPropId(int giftPropId) {
            this.giftPropId = giftPropId;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setCurrencyType(int currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setActId(int actId) {
            this.actId = actId;
            return this;
        }

        public GetGiftBagParam.GetGiftBagParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public GetGiftBagParam build() {
            GetGiftBagParam getGiftBagParam = new GetGiftBagParam();
            getGiftBagParam.appId = this.actId;
            getGiftBagParam.uid = this.uid;
            getGiftBagParam.usedChannel = this.usedChannel;
            getGiftBagParam.giftPropId = this.giftPropId;
            getGiftBagParam.currencyType = this.currencyType;
            getGiftBagParam.actId = this.actId;
            getGiftBagParam.retry = this.retry;
            return getGiftBagParam;
        }
    }
}
