package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/13.
 * <p>
 * YY.Inc
 */
public class UseItemRequest extends BaseJsonRequest {

//    # Request
//    {
//            "cmd":1007,
//            "seq":"$seq",   //
//            "ticket":"$ticket",   // 需验证
//            "uid":$uid,              // 使用者uid，必填
//            "sid":$sid,            //使用时频道号，频道外传0
//            "ssid":$ssid,      //使用时子频道号
//            "appId":$appId,   // 业务id，分配而得，必传
//            "usedChannel":usedChannel,   // 渠道id，分配而得，必填
//            "ip":$ip,   // ip地址，选传
//
//            "propsId":$propsId,   // 道具id
//            "count":$count,       // 赠送数量
//            "senderuid":$senderuid,    //赠送者uid，必填
//            "senderimid":$senderimid,  //赠送者imid，选填
//            "sendernickname":$sendernickname,  //赠送者昵称，选填
//            "recveruid":$recveruid,    //主持人或房主uid，必填
//            "recverimid":$recverimid,  //主持人或房主imid，选填
//            "recvernickname":$recvernickname,  //主持人或房主昵称，选填
//
//            // 真正接收者，可以是嘉宾，或者主持人、房主
//            "realRecveruid":$realRecveruid,    //真正接收者uid
//            "realRecverimid":$realRecverimid,      //真正接收者imid
//            "realRecvernickname":$realRecvernickname,      //真正接收者昵称
//
//            "anchorUid":$anchorUid,    //主持人 or 房主，必填，没有主持人or房主时，填0
//            "expand":"$expand"    // 扩展字段，原文附于返回
//    }

    public String seq;
    public long uid;
    public long sid;
    public long ssid;
    public int appId;
    public int usedChannel;
    public int propsId;
    public int count;
    public long senderUid;
    public String sendernickname;
    public long recveruid;
    public String recvernickname;
    public long realRecveruid;
    public String realRecvernickname;
    public long anchorUid;
    public String expend;
    public boolean isAutoBuy;
    public String payGateOrderId;
    public String payWay;
    public String payAdditionInfo;
    public String ticket;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        int cmd = isAutoBuy ? ProtocolCmd.ConsumeAndUseRequest : ProtocolCmd.UseItemRequest;
        try {
            jMsg.put("cmd", cmd);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("ssid", ssid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            jMsg.put("propsId", propsId);
            jMsg.put("count", count);
            jMsg.put("senderuid", senderUid);
            jMsg.put("sendernickname", sendernickname);
            jMsg.put("recveruid", recveruid);
            jMsg.put("recvernickname", recvernickname);
            jMsg.put("realRecveruid", realRecveruid);
            jMsg.put("realRecvernickname", realRecvernickname);
            jMsg.put("anchorUid", anchorUid);
            jMsg.put("expand", expend);
            jMsg.put("payGateOrderId", payGateOrderId);
            jMsg.put("payWay", payWay);
            jMsg.put("payAdditionInfo", payAdditionInfo);
            // jMsg.put("ticket", ticket); // data 不需要传递ticket，否则是service协议出错
            jsonMsg = jMsg.toString();
        } catch (JSONException e) {
            RLog.error("UseItemRequest", "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest = new PSCIMessageRequest(cmd, appId, 0, ticket, "", jsonMsg);
    }
}
