package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/12.
 * <p>
 * YY.Inc
 */
public class ToInfoRequest extends BaseJsonRequest {

    private static final String TAG = "ToInfoRequest";

//    # Requst
//    {
//            "cmd":1001,
//            "seq":"$seq",   //
//            "ticket":"$ticket",   // 不需验证，选填
//            "uid":$uid,
//            "sid":$sid,
//            "ssid":$ssid,
//            "appId": $appId,          //业务appid，必填
//            "usedChannel":usedChannel,   // 渠道id，分配而得，必填
//            "ip":$ip,   // ip地址，选传
//    }

    public String seq;
    public long uid;
    public long sid;
    public long ssid;
    public int appId;
    public int usedChannel;
    public String ticket;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", ProtocolCmd.ToInfoRequest);
            jMsg.put("seq", seq);
            jMsg.put("uid", uid);
            jMsg.put("sid", sid);
            jMsg.put("ssid", ssid);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            // jMsg.put("ticket", ticket);  // data 不需要传递ticket，否则是service协议出错

            jsonMsg = jMsg.toString();
        } catch (Exception e) {
            RLog.error(TAG, "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest = new PSCIMessageRequest(ProtocolCmd.ToInfoRequest, appId, 0, ticket,
                "", jsonMsg);
    }
}
