package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.requestparam.SendGiftParamV2;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by nls on 2019/6/13.
 * <p>
 * # Response
 * {
 * "cmd":2042,
 * "seq":"$seq",   //
 * "uid":$uid,        //赠送者uid
 * "result":$result,           // 业务错误码：-1、-3、-4、-5, -10
 * "message":$message,           // 业务返回码信息说明
 * <p>
 * "propsId":$propsId,   // 道具id
 * "count":$count,       // 使用数量
 * "buyCount":$buyCount, // 需购买数量：使用数量-包裹数量
 * "currencyType":$ctype,// 购买所用货币
 * "amount":$amount,     // 购买所需数量
 * "appid":$appid,       // 业务id
 * <p>
 * "senderUserInfo":{
 * "uid":$uid, //赠送者uid，必填
 * "yyno":$yyno, //赠送者yy号，不传请填0
 * "nickName":$nickName //赠送者昵称，不传请填空串
 * },
 * "recverUserInfos":[
 * {
 * "uid":$uid, //收礼者-A uid，必填
 * "yyno":$yyno, //收礼者-A yy号，不传请填0
 * "nickName":$nickName //收礼者-A 昵称，不传请填空串
 * },
 * {
 * "uid":$uid, //收礼者-B uid，必填
 * "yyno":$yyno, //收礼者-B yy号，不传请填0
 * "nickName":$nickName //收礼者-B 昵称，不传请填空串
 * }
 * ],
 * <p>
 * <p>
 * "confirmUrl":"",//当result=-10时，充值中心的弹窗确认url,其他方式（weixin、支付宝等相同）
 * "expand":"$expand"    // 扩展字段，原文附于返回
 * }
 */
public class SendGiftToMultiUserResponse implements IBaseJsonResponse {

    private String seq;
    private long uid;
    private int result;
    private int usedChannel;
    private String message;
    private int propsId;
    private int count;
    private int appId;
    private long senderUid;
    private String sendernickname;
    private String expend;
    private String confirmUrl;
    private List<SendGiftParamV2.TargetUser> targetUsers = new ArrayList<>();

    public SendGiftToMultiUserResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject resp = new JSONObject(jsonMsg);
            seq = resp.optString("seq", "");
            uid = resp.optLong("uid", 0);
            result = resp.optInt("result", -1);
            usedChannel = resp.optInt("usedChannel", -1);
            message = resp.optString("message", "");
            propsId = resp.optInt("propsId", 0);
            count = resp.optInt("count", 0);
            appId = resp.optInt("appId", 0);
            //sender
            JSONObject sender = resp.optJSONObject("senderUserInfo");
            if (sender != null) {
                senderUid = resp.optLong("uid", 0);
                sendernickname = resp.optString("nickName", "");
            }

            //receiver
            JSONArray receiver = resp.optJSONArray("recverUserInfos");
            if (receiver != null) {
                for (int i = 0; i < receiver.length(); i++) {
                    JSONObject temp = receiver.optJSONObject(i);
                    SendGiftParamV2.TargetUser target = new SendGiftParamV2.TargetUser(temp.optLong("uid"));
                    target.yyNum = temp.optString("yyno", "");
                    target.nickName = temp.optString("nickName", "");
                    targetUsers.add(target);
                }
            }

            expend = resp.optString("expand", "");
            confirmUrl = resp.optString("confirmUrl", "");
        } catch (Exception e) {
            RLog.error("SendGiftToMultiUserResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getUsedChannel() {
        return usedChannel;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public int getPropsId() {
        return propsId;
    }

    public int getCount() {
        return count;
    }

    public int getAppId() {
        return appId;
    }

    public long getSenderUid() {
        return senderUid;
    }

    public String getSendernickname() {
        return sendernickname;
    }

    public String getExpend() {
        return expend;
    }

    public String getConfirmUrl() {
        return confirmUrl;
    }

    public List<SendGiftParamV2.TargetUser> getTargetUsers() {
        return targetUsers;
    }
}
