package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.UserProps;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lhf on 2018/8/7.
 * <p>
 * YY.Inc
 */
public class GetUserPropsResponse implements IBaseJsonResponse {

    private String seq;
    private long uid;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明
    private int appId;
    private UserProps userProps;
    private int usedChannel;

    public GetUserPropsResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            uid = response.optLong("uid", 0);
            result = response.optInt("result", 0);
            message = response.optString("message", "");
            appId = response.optInt("appId", 0);
            usedChannel = response.optInt("usedChannel", 0);
            userProps = new UserProps();
            JSONArray propsItemArray = response.optJSONArray("propsList");
            List<UserProps.PropsItem> propsItemList = new ArrayList<>();
            if (propsItemArray != null && propsItemArray.length() > 0) {
                for (int j = 0; j < propsItemArray.length(); ++j) {
                    JSONObject propsItemObj = propsItemArray.optJSONObject(j);
                    if (propsItemObj != null) {
                        UserProps.PropsItem propsItem = new UserProps.PropsItem();
                        propsItem.propsId = propsItemObj.optInt("propsId", 0);
                        propsItem.count = propsItemObj.optInt("count", 0);
                        propsItem.expireCount = propsItemObj.optInt("expireCount", 0);
                        propsItemList.add(propsItem);
                    }
                }
            }
            userProps.appId = appId;
            userProps.propsItemList = propsItemList;
        } catch (Exception e) {
            RLog.error("", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public int getAppId() {
        return appId;
    }

    public UserProps getUserProps() {
        return userProps;
    }

    public int getUsedChannel() {
        return usedChannel;
    }
}
