package com.yy.mobile.framework.revenuesdk.gift.protocol

import com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse
import com.yy.mobile.framework.revenuesdk.gift.bean.CouponStore
import com.yy.mobile.framework.revenuesdk.gift.callbackresult.QueryCouponStoreResult
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd
import org.json.JSONObject

/**
 * Created by nls on 2019-11-11.
 * # Response
{
"cmd":2047,
"seq": "6039533151359860737",
"uid": 50012928,
"appId": 1801,
"result":$result,           // 业务错误码：-1、-3、-4、-5, -10
"message":$message,           // 业务返回码信息说明
"serverCurrentTime":1535792400000, // 服务器当前时间戳，可用于计算每张优惠券失效的具体时间间隔（天）
"userCouponList":[       // 每用户会有0至3个账户，每个账户对应一种货币
{
"id":1, //用户包裹使用优惠券id
"uid":50012928, // uid
"appid": 25, // 业务id
"acquireTime": 1535186629000, // 获得优惠券时间
"validStartTime": 1535186629000, // 优惠券有效时间
"validEndTime": 1535792400000, // 优惠券失效时间
"lockReleaseTime": null, // 优惠券锁定，被解开时间
"status": 1, // 优惠券状态，1=未使用
"couponId": 40, // 优惠券ID
"couponType": 1, // 优惠券类型，1=代金券，2=满减券，3=折扣券，4=满赠券
"couponName": "开心斗充值1元代金券",
"couponLimitAmount": 6.0, // 优惠券使用需满足的条件，如充值6元以上可用此券
"couponAmount": 1.0, // 优惠券金额
"couponUseWay": 8, // 优惠券使用途径
"couponUseWayInfo": "", // 优惠券使用途径限制，如有是json
"srcType": 9,  // 优惠券来源，9=活动优惠券发放
"humanId": "1juPnq" // 展示给用户看的优惠券ID
},
{ ... }
]
}
 */
class GetUserCouponStoreResponse(val data: String) : IBaseJsonResponse {

    var seq = ""
    var message = ""
    var appId = 0
    var result = 0
    var uid: Long = 0
    var serverCurrentTime: Long = 0
    var userCouponList: MutableList<CouponStore>? = null

    init {
        parserResponse(data)
    }

    override fun parserResponse(jsonMsg: String?) {
        val jsonObject = JSONObject(jsonMsg)
        if (jsonObject.optInt("cmd", 0)
                != ProtocolCmd.GetUserCouponStoreResponse) {
            return
        }
        seq = jsonObject.optString("seq")
        uid = jsonObject.optLong("uid")
        appId = jsonObject.optInt("appId")
        result = jsonObject.optInt("result")
        message = jsonObject.optString("message")
        serverCurrentTime = jsonObject.optLong("serverCurrentTime")
        val itemArray = jsonObject.optJSONArray("userCouponList")
        if (itemArray != null && itemArray.length() > 0) {
            userCouponList = mutableListOf()
            userCouponList?.apply {
                for (i in 0 until itemArray.length()) {
                    add(CouponStore.fromJson(itemArray.optJSONObject(i)))
                }
            }
        }
    }

    fun isSuccess(): Boolean = result == ErrorCode.SUCCESS

    fun getRspResult(): QueryCouponStoreResult {
        val result = QueryCouponStoreResult()
        result.appId = appId
        result.message = message
        result.serverCurrentTime = serverCurrentTime
        result.userCouponList = userCouponList
        return result
    }
}