package com.yy.mobile.framework.revenuesdk.gift.protocol

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd
import com.yy.mobile.framework.revenuesdk.gift.requestparam.QueryCouponStoreParam
import org.json.JSONObject

/**
 * Created by nls on 2019-11-11.
 * {
"cmd":1047,
"seq":"$seq",   //客户端请求流水号，如有原值返回，选填
"ticket":"$ticket",   // 需验证，必填
"uid":$uid,
"appId": $appId,          //业务appid，必填
"goodsType": $goodsType,       // 优惠券使用途径，如充值代金券传8，其他咨询营收后端童鞋，不传即获取所有范围代金券
"hasUsed":true/false, // 是否已使用优惠券列表，海外业务支持
"page"：分页，从1开始 // 海外业务支持
"pageSize":条数，默认20 // 海外业务支持
}
 */
class GetUserCouponStoreRequest(private val params: QueryCouponStoreParam) : BaseJsonRequest() {

    companion object {
        private const val TAG = "GetUserCouponStoreRequest"
    }

    override fun constructPSCIMessageRequest() {
        var jsonMsg = ""
        val jMsg = JSONObject()
        try {
            jMsg.put("cmd", ProtocolCmd.GetUserCouponStoreRequest)
            jMsg.put("seq", params.seq)
            jMsg.put("uid", params.uid)
            jMsg.put("appId", params.appId)
//            jMsg.put("ticket", params.ticket)   // data 不需要传递ticket，否则是service协议出错
            jMsg.put("goodsType", params.goodsType)
            jMsg.put("hasUsed", params.hasUsed)
            jMsg.put("page", params.page)
            jMsg.put("pageSize", params.pageSize)
            jMsg.put("includeExpire", params.includeExpire)
            jMsg.put("expand", params.expand)
            jsonMsg = jMsg.toString()
        } catch (e: Exception) {
            RLog.error(TAG, "constructPSCIMessageRequest error.", e)
        }
        psciMessageRequest = PSCIMessageRequest(ProtocolCmd.GetUserCouponStoreRequest, params
                .appId, 0, params.ticket, "", jsonMsg)
    }
}