package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.BaseJsonRequest;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.PSCIMessageRequest;
import com.yy.mobile.framework.revenuesdk.gift.cmd.ProtocolCmd;

import org.json.JSONObject;

public class GetGiftBagRequest extends BaseJsonRequest {

    private static final String TAG = "GetGiftBagRequest";

//# Requst
//    {
//        "cmd":1049,
//            "appId":$appId, // hamo：1801
//            "usedChannel":$usedChannel, //渠道号，ios:10001; andriod:10002
//            "giftPropId":&giftPropId, //礼包id，选填，由营收分配
//            "currencyType":¤cyType, //货币类型，选填，如果是首充礼包则需要填写充值所得货币类型，如GirGir业务¤cyType=1901
//            "actId":&actId //活动id，选填，默认值为0
//    }

    public String seq;
    public int appId;
    public long uid;
    public int usedChannel;
    public int giftPropId;
    public int currencyType;
    public int actId;
    public String ticket;

    @Override
    public void constructPSCIMessageRequest() {
        String jsonMsg = "";
        JSONObject jMsg = new JSONObject();
        try {
            jMsg.put("cmd", ProtocolCmd.GetGiftBagRequest);
            jMsg.put("uid", uid);
            jMsg.put("seq", seq);
            jMsg.put("appId", appId);
            jMsg.put("usedChannel", usedChannel);
            // jMsg.put("ticket", ticket); // data 不需要传递ticket，否则是service协议出错
            jMsg.put("giftPropId", giftPropId);
            jMsg.put("currencyType", currencyType);
            jMsg.put("actId", actId);
            jsonMsg = jMsg.toString();
        } catch (Exception e) {
            RLog.error(TAG, "constructPSCIMessageRequest error.", e);
        }
        psciMessageRequest = new PSCIMessageRequest(ProtocolCmd.GetGiftBagRequest, appId, 0,
                ticket, "", jsonMsg);
    }
}

